/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmInt16
extends SingletonPrimitiveType {
    private static final EdmInt16 INSTANCE = new EdmInt16();

    public static EdmInt16 getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16;
    }

    @Override
    public Class<?> getDefaultType() {
        return Short.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Short valueShort;
        try {
            valueShort = Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.", e);
        }
        try {
            return EdmInt64.convertNumber(valueShort, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' cannot be converted to value type " + String.valueOf(returnType) + ".", e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("The value type " + String.valueOf(returnType) + " is not supported.", e);
        }
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte || value instanceof Short) {
            return value.toString();
        }
        if (value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= -32768L && ((Number)value).longValue() <= 32767L) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.");
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).bitLength() < 16) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("The value '" + String.valueOf(value) + "' is not valid.");
        }
        throw new EdmPrimitiveTypeException("The value type " + String.valueOf(value.getClass()) + " is not supported.");
    }
}

