/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.expression;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;

public class BinaryImpl
implements Binary {
    private final Expression left;
    private final BinaryOperatorKind operator;
    private final Expression right;
    private final EdmType type;
    private final List<Expression> expressions;

    public BinaryImpl(Expression left, BinaryOperatorKind operator, Expression right, EdmType type) {
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.type = type;
        this.expressions = null;
    }

    public BinaryImpl(Expression left, BinaryOperatorKind operator, List<Expression> right, EdmType type) {
        this.left = left;
        this.operator = operator;
        this.right = null;
        this.type = type;
        this.expressions = right;
    }

    @Override
    public BinaryOperatorKind getOperator() {
        return this.operator;
    }

    @Override
    public Expression getLeftOperand() {
        return this.left;
    }

    @Override
    public Expression getRightOperand() {
        return this.right;
    }

    public EdmType getType() {
        return this.type;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        T localLeft = this.left.accept(visitor);
        if (this.right != null) {
            T localRight = this.right.accept(visitor);
            return visitor.visitBinaryOperator(this.operator, localLeft, localRight);
        }
        if (this.expressions != null) {
            ArrayList<T> expressions = new ArrayList<T>();
            for (Expression expression : this.expressions) {
                expressions.add(expression.accept(visitor));
            }
            return visitor.visitBinaryOperator(this.operator, localLeft, (List<T>)expressions);
        }
        return null;
    }

    public String toString() {
        return "{" + String.valueOf(this.left) + " " + this.operator.name() + " " + String.valueOf(null != this.right ? this.right : this.expressions) + "}";
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

