/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.build.ImportPackageAllowlist;
import com.sap.cloud.adk.build.ManifestAnalyzer;
import com.sap.cloud.adk.build.MetadataCapabilityProvider;
import com.sap.cloud.adk.build.SubsystemContentInformation;
import com.sap.cloud.adk.build.SubsystemInfoCube;
import com.sap.cloud.adk.checks.VersionComparator;
import com.sap.cloud.adk.exception.AdapterBuildException;
import com.sap.cloud.adk.util.AdapterMetadataBuildUtil;
import com.sap.cloud.adk.util.EsaOutputStream;
import com.sap.cloud.adk.util.FileUtil;
import com.sap.cloud.adk.util.XMLParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AdapterSubsystemBuildHandler {
    private static final Logger log = LoggerFactory.getLogger(AdapterSubsystemBuildHandler.class);
    private static final String JAR_EXTENSION = "jar";
    private static final String MONITOR_FILE_EXTENSION = ".monitor";
    private static final CharSequence VENDOR = "vendor::";
    private final ManifestAnalyzer manifestAnalyzer = new ManifestAnalyzer();
    private final ImportPackageAllowlist importPackageAllowlist;
    private final SubsystemContentInformation subsystemInformation = new SubsystemContentInformation();
    Boolean isVendorPresentComponentId = false;
    private MetadataCapabilityProvider metadataCapabilityProvider;
    private String componentBundleVersion;
    private List<String> allCMDPaths = null;
    private boolean isInternal = false;

    public AdapterSubsystemBuildHandler(ImportPackageAllowlist importPackageAllowlist) {
        this.importPackageAllowlist = importPackageAllowlist;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public List<byte[]> build(byte[] project, String path, boolean skipImportAllowlist) throws AdapterBuildException {
        if (project == null) {
            throw new IllegalArgumentException("Content must not be null.");
        }
        ByteArrayOutputStream subsystemByteArrayOutputStream = new ByteArrayOutputStream();
        try (EsaOutputStream subsystemOutputStream = new EsaOutputStream(subsystemByteArrayOutputStream);){
            SubsystemInfoCube sic = this.gatherBundleManifests(project);
            List<String> calculatedSubsystemImports = sic.calculateSubsystemImports(skipImportAllowlist);
            log.debug("Calculated subsystem imports: {}", calculatedSubsystemImports);
            String componentId = this.getComponentId(path);
            if (componentId != null) {
                this.isVendorPresentComponentId = componentId.contains(VENDOR);
            }
            Manifest subsystemManifest = this.manifestAnalyzer.createSubsystemManifest(path, sic.getSubsysManifestContent(), calculatedSubsystemImports, componentId);
            this.populateSubsystemContent(subsystemManifest);
            this.metadataCapabilityProvider = new MetadataCapabilityProvider(this.subsystemInformation);
            log.debug("Subsystem manifest calculated:");
            this.logManifest(subsystemManifest);
            this.updateMetadataCapability(subsystemManifest, this.allCMDPaths, this.isVendorPresentComponentId);
            subsystemOutputStream.setMethod(8);
            this.buildSubsystem(project, subsystemManifest, subsystemOutputStream);
        }
        catch (IOException e) {
            throw new AdapterBuildException("Exception during Adapter build.", e);
        }
        return Collections.singletonList(subsystemByteArrayOutputStream.toByteArray());
    }

    private String getComponentId(String path) throws AdapterBuildException {
        try {
            this.allCMDPaths = AdapterMetadataBuildUtil.getCMDAndBMDFilesInProject(new File(path));
            return this.getLatestCMDId(this.allCMDPaths);
        }
        catch (Exception e) {
            throw new AdapterBuildException("Build Error: Cannot Find Metadata files : " + e.getMessage(), e);
        }
    }

    private void populateSubsystemContent(Manifest subsystemManifest) {
        String name = subsystemManifest.getMainAttributes().getValue("Subsystem-Name");
        String version = subsystemManifest.getMainAttributes().getValue("Subsystem-Version");
        String vendor = subsystemManifest.getMainAttributes().getValue("Bundle-Vendor");
        String dname = subsystemManifest.getMainAttributes().getValue("SAP-AdapterName");
        this.subsystemInformation.setAdapterName(dname);
        this.subsystemInformation.setSubsystemName(name);
        this.subsystemInformation.setSubsystemVersion(version);
        this.subsystemInformation.setBundleVendor(vendor);
    }

    private void updateMetadataCapability(Manifest subsystemManifest, List<String> allCMDPaths, Boolean isVendorPresentComponentId) throws AdapterBuildException {
        for (String cmdPath : allCMDPaths) {
            try {
                this.metadataCapabilityProvider.addCapabilityDefinitionToManifest(subsystemManifest, isVendorPresentComponentId, cmdPath);
            }
            catch (Exception e) {
                throw new AdapterBuildException("Capability Update in Manifest Unsuccessful: " + e.getMessage(), e);
            }
        }
    }

    private void logManifest(Manifest subsystemManifest) {
        Attributes mainAttributes = subsystemManifest.getMainAttributes();
        for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
            log.debug("{} : {}", entry.getKey(), entry.getValue());
        }
    }

    private String getComponentIdFromMetadataFile(String path) {
        try {
            if (path == null) {
                log.error("cmd could not be located!");
                return null;
            }
            log.info(path);
            File metadataFile = new File(path);
            XMLParser parser = new XMLParser();
            Document document = parser.parseWithLineNumbers(metadataFile);
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node comp = ((NodeList)xPath.compile("/ComponentMetadata").evaluate(document, XPathConstants.NODESET)).item(0);
            NamedNodeMap nodeMap = comp.getAttributes();
            return nodeMap.getNamedItem("ComponentId").getNodeValue();
        }
        catch (Exception e) {
            log.info("Component Id Access failed ! {}", (Object)e.getMessage());
            return null;
        }
    }

    private String getLatestCMDId(List<String> allCMDPaths) {
        String latestCMDId = this.getComponentIdFromMetadataFile(allCMDPaths.get(0));
        String latestVersion = "1.0.0";
        for (String cmdPath : allCMDPaths) {
            String version;
            String componentId = this.getComponentIdFromMetadataFile(cmdPath);
            if (componentId == null || !VersionComparator.isLessThanOrEqual(latestVersion, version = VersionComparator.getVersionFromComponent(componentId))) continue;
            latestCMDId = componentId;
        }
        return latestCMDId;
    }

    private SubsystemInfoCube gatherBundleManifests(byte[] project) throws IOException {
        SubsystemInfoCube sic = new SubsystemInfoCube(this.importPackageAllowlist);
        try (JarInputStream adapterJarInputStream = new JarInputStream(new ByteArrayInputStream(project));){
            JarEntry entry;
            while ((entry = adapterJarInputStream.getNextJarEntry()) != null) {
                if (this.isInComponentFolder(entry) && this.isJarFile(entry)) {
                    Manifest componentManifest = new JarInputStream(adapterJarInputStream).getManifest();
                    sic.addCamelComponentManifest(componentManifest);
                    continue;
                }
                if (!this.isInLibsFolder(entry) || !this.isJarFile(entry)) continue;
                Manifest manifest = new JarInputStream(adapterJarInputStream).getManifest();
                sic.addDependentLibraryManifest(manifest);
            }
            SubsystemInfoCube subsystemInfoCube = sic;
            return subsystemInfoCube;
        }
    }

    private boolean isJarFile(JarEntry entry) {
        return entry.getName().endsWith(".jar");
    }

    private void buildSubsystem(byte[] project, Manifest subsystemManifest, EsaOutputStream subsystemOutputStream) throws IOException, AdapterBuildException {
        try (JarInputStream adapterJarInputStream = new JarInputStream(new ByteArrayInputStream(project));){
            String symbolicName;
            JarEntry componentEntry;
            while ((componentEntry = adapterJarInputStream.getNextJarEntry()) != null) {
                if ((this.isInComponentFolder(componentEntry) || this.isInLibsFolder(componentEntry)) && this.isJarFile(componentEntry)) {
                    log.debug("Extract and append component entry: {}", (Object)componentEntry.getName());
                    symbolicName = this.extractAndAppendComponent(subsystemOutputStream, adapterJarInputStream, componentEntry);
                    if (this.isInComponentFolder(componentEntry)) {
                        this.subsystemInformation.setCamelComponentSymbolicName(symbolicName);
                        continue;
                    }
                    if (!this.isInLibsFolder(componentEntry)) continue;
                    this.subsystemInformation.addLibrarySymbolicNames(symbolicName);
                    continue;
                }
                if (componentEntry.getName().startsWith("metadata/") && componentEntry.getName().endsWith("bpMetadata.xml")) {
                    log.debug("Load BMD file for IFlow generation: {}", (Object)componentEntry.getName().endsWith("bpMetadata.xml"));
                    this.copyMetadataFile(subsystemOutputStream, adapterJarInputStream, componentEntry, true);
                    continue;
                }
                if (!componentEntry.getName().startsWith("metadata/") || !componentEntry.getName().endsWith(".xml")) continue;
                log.debug("Load CMD file for IFlow generation: {}", (Object)componentEntry.getName().endsWith(".xml"));
                this.copyMetadataFile(subsystemOutputStream, adapterJarInputStream, componentEntry, false);
            }
            if (this.isInternal) {
                symbolicName = subsystemManifest.getMainAttributes().getValue("Subsystem-SymbolicName");
                this.addPomEntry(subsystemOutputStream, symbolicName);
            }
            subsystemOutputStream.putNextEntry(new ZipEntry("OSGI-INF/"));
            subsystemOutputStream.closeEntry();
            subsystemOutputStream.putNextEntry(new ZipEntry("OSGI-INF/SUBSYSTEM.MF"));
            this.writeSubsystemManifest(subsystemManifest, subsystemOutputStream);
        }
        this.createAndAppendAdapterMonitor(this.subsystemInformation, subsystemManifest.getMainAttributes().getValue("Subsystem-SymbolicName"), subsystemManifest, subsystemOutputStream);
    }

    private void copyMetadataFile(EsaOutputStream subsystemOutputStream, JarInputStream adapterJarInputStream, JarEntry componentEntry, boolean isBpMetadata) throws IOException {
        try (ByteArrayOutputStream bufferedStream = new ByteArrayOutputStream();){
            FileUtil.copyStream(adapterJarInputStream, bufferedStream);
            if (isBpMetadata) {
                this.metadataCapabilityProvider.copyBPMetadataFile(bufferedStream.toByteArray(), subsystemOutputStream);
            } else {
                this.metadataCapabilityProvider.copyMetadataFile(bufferedStream, subsystemOutputStream, componentEntry.getName());
            }
        }
    }

    private void writeSubsystemManifest(Manifest subsystemManifest, EsaOutputStream subsystemOutputStream) throws IOException {
        BufferedOutputStream bufferedStream = new BufferedOutputStream(subsystemOutputStream);
        subsystemManifest.write(bufferedStream);
        subsystemOutputStream.closeEntry();
    }

    private void addPomEntry(EsaOutputStream subsystemOutputStream, String symbolicName) throws IOException, AdapterBuildException {
        ZipEntry pomEntry = new ZipEntry("META-INF/maven/pom.xml");
        subsystemOutputStream.putNextEntry(pomEntry);
        String pomString = this.resolveAndGetPom(symbolicName, this.componentBundleVersion);
        subsystemOutputStream.write(pomString.getBytes());
        subsystemOutputStream.closeEntry();
    }

    private boolean isInLibsFolder(JarEntry componentEntry) {
        return componentEntry.getName().startsWith("libs/");
    }

    private boolean isInComponentFolder(JarEntry componentEntry) {
        return componentEntry.getName().startsWith("component/");
    }

    private String extractAndAppendComponent(EsaOutputStream subsystemOutputStream, JarInputStream adapterJarInputStream, JarEntry componentEntry) throws IOException, AdapterBuildException {
        JarInputStream componentInputStream = new JarInputStream(adapterJarInputStream);
        Manifest manifest = componentInputStream.getManifest();
        String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        this.componentBundleVersion = manifest.getMainAttributes().getValue("Bundle-Version");
        log.debug("Manifest for: {}", (Object)componentEntry.getName());
        this.logManifest(manifest);
        if (symbolicName == null || "".equals(symbolicName.trim())) {
            componentInputStream.close();
            throw new AdapterBuildException("Dependency " + componentEntry.getName() + " is not a valid OSGi bundle");
        }
        if (this.isInternal) {
            this.updateMetadataCapability(manifest, this.allCMDPaths, this.isVendorPresentComponentId);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JarOutputStream jarOut = new JarOutputStream((OutputStream)out, manifest);
        this.copyContent(componentInputStream, jarOut);
        jarOut.finish();
        jarOut.close();
        this.addJarEntryToSubsystem(new JarEntry(componentEntry.getName().split("/")[1]), out.toByteArray(), subsystemOutputStream);
        return symbolicName;
    }

    private void addJarEntryToSubsystem(JarEntry jarEntry, byte[] bytes, EsaOutputStream subsystemOutputStream) throws IOException {
        subsystemOutputStream.putNextEntry(jarEntry);
        subsystemOutputStream.write(bytes);
        subsystemOutputStream.closeEntry();
    }

    private void addImportPackagesToManifest(Manifest componentManifest) {
        String importPackages = this.ensureNotNull(componentManifest.getMainAttributes().getValue("Import-Package"));
        StringBuilder builder = new StringBuilder(importPackages);
        for (String importPackage : SubsystemInfoCube.staticMonitorImports) {
            if (!importPackage.isEmpty() && !builder.toString().isEmpty()) {
                builder.append(",");
            }
            builder.append(importPackage);
        }
        componentManifest.getMainAttributes().putValue("Import-Package", builder.toString());
    }

    private String ensureNotNull(String value) {
        return value == null ? "" : value;
    }

    private void copyContent(JarInputStream componentJarInputStream, JarOutputStream componentJarOutputStream) throws IOException {
        JarEntry entryToTransfer;
        while ((entryToTransfer = componentJarInputStream.getNextJarEntry()) != null) {
            componentJarOutputStream.putNextEntry(entryToTransfer);
            if (!entryToTransfer.isDirectory()) {
                FileUtil.copyStream(componentJarInputStream, componentJarOutputStream);
            }
            componentJarOutputStream.closeEntry();
            componentJarInputStream.closeEntry();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getComponentStatusBeans(String bundleSymbolicName, String adapterVersion, String adapterName, SubsystemContentInformation contentInformation) throws AdapterBuildException {
        try (InputStream templateStream = this.getClass().getResourceAsStream("/resources/beans/beans.xml");){
            String templateString = FileUtil.convertStreamToString(templateStream);
            templateString = templateString.replace("{BundleSymbolicName}", bundleSymbolicName);
            templateString = templateString.replace("{CamelComponentSymbolicName}", contentInformation.getCamelComponentSymbolicName());
            templateString = templateString.replace("{AdapterName}", adapterName);
            templateString = templateString.replace("{AdapterVersion}", adapterVersion);
            StringBuilder dependencies = new StringBuilder();
            for (String dependencySymbolicName : contentInformation.getAllSymbolicNames()) {
                dependencies.append("<value>");
                dependencies.append(dependencySymbolicName);
                dependencies.append("</value>");
            }
            templateString = templateString.replace("{DependentBundles}", dependencies.toString());
            String string = templateString;
            return string;
        }
        catch (IOException e) {
            throw new AdapterBuildException("Could not get Component status beans", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String resolveAndGetPom(String bundleSymbolicName, String adapterVersion) throws AdapterBuildException {
        try (InputStream templateStream = this.getClass().getResourceAsStream("/resources/pom.xml");){
            String templateString = FileUtil.convertStreamToString(templateStream);
            templateString = templateString.replace("{groupId}", bundleSymbolicName);
            templateString = templateString.replace("{artifactId}", bundleSymbolicName);
            if (adapterVersion.contains(".SNAPSHOT")) {
                adapterVersion = adapterVersion.replace(".SNAPSHOT", "-SNAPSHOT");
            }
            String string = templateString = templateString.replace("{version}", adapterVersion);
            return string;
        }
        catch (IOException e) {
            throw new AdapterBuildException("Could not resolve pom", e);
        }
    }

    private void createAndAppendAdapterMonitor(SubsystemContentInformation contentInformation, String symbolicName, Manifest subsystemManifest, EsaOutputStream subsystemOutputStream) throws AdapterBuildException {
        log.debug("Generating component monitor for adapter");
        String componentName = "";
        String manifestVersion = "1.0";
        String bundleVersion = "1.0";
        String bundleManifestVersion = "2";
        if (subsystemManifest != null) {
            String bundleName = subsystemManifest.getMainAttributes().getValue("Bundle-Name");
            String string = componentName = bundleName != null ? bundleName : symbolicName;
            if (subsystemManifest.getMainAttributes().getValue("Subsystem-Version") != null) {
                bundleVersion = subsystemManifest.getMainAttributes().getValue("Subsystem-Version");
            }
            if (subsystemManifest.getMainAttributes().getValue("Bundle-ManifestVersion") != null) {
                bundleManifestVersion = subsystemManifest.getMainAttributes().getValue("Bundle-ManifestVersion");
            }
            if (subsystemManifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION) != null) {
                manifestVersion = subsystemManifest.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION);
            }
        }
        Manifest monitorManifest = new Manifest();
        Attributes mainAttributes = monitorManifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        mainAttributes.putValue("Bundle-Name", componentName + " Monitor");
        mainAttributes.putValue("Bundle-Version", bundleVersion);
        mainAttributes.putValue("Bundle-ManifestVersion", bundleManifestVersion);
        mainAttributes.putValue("Bundle-SymbolicName", symbolicName + MONITOR_FILE_EXTENSION);
        if (this.isInternal) {
            mainAttributes.putValue("SAP-EssentialService", componentName);
        }
        this.addImportPackagesToManifest(monitorManifest);
        try (ByteArrayOutputStream monitoringStream = new ByteArrayOutputStream();
             JarOutputStream monitoringJar = new JarOutputStream((OutputStream)monitoringStream, monitorManifest);){
            monitoringJar.putNextEntry(new ZipEntry("OSGI-INF/blueprint/beans.xml"));
            log.debug("Monitor Symbolic-Name: {} and component name: {}", (Object)symbolicName, (Object)componentName);
            String beansXml = this.getComponentStatusBeans(symbolicName, bundleVersion, componentName, contentInformation);
            log.debug("Monitor beans xml: {}", (Object)beansXml);
            monitoringJar.write(beansXml.getBytes(StandardCharsets.UTF_8));
            monitoringJar.closeEntry();
            monitoringJar.finish();
            this.addJarEntryToSubsystem(new JarEntry(symbolicName + MONITOR_FILE_EXTENSION + "." + JAR_EXTENSION), monitoringStream.toByteArray(), subsystemOutputStream);
        }
        catch (IOException e) {
            throw new AdapterBuildException("Could not create Adapter Monitor", e);
        }
    }
}

