/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.build.AdapterSubsystemBuildHandler;
import com.sap.cloud.adk.build.ImportPackageAllowlist;
import com.sap.cloud.adk.checks.AdapterProjectChecks;
import com.sap.cloud.adk.exception.AdapterBuildException;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.BuildProviderUtil;
import com.sap.cloud.adk.util.FileUtil;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;

public class BuildProvider {
    private static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    private static final String METADATA_TXT = "metadata.txt";
    private static final String CONFIG_ADK = "config.adk";

    public static String getConfigFilePath(File adapterProjectDirectory) {
        if (adapterProjectDirectory.getAbsolutePath().endsWith("/runtime")) {
            return BuildProvider.getConfigFilePath(new File(adapterProjectDirectory.getParent()).getAbsolutePath());
        }
        return BuildProvider.getConfigFilePath(adapterProjectDirectory.getAbsolutePath());
    }

    private static String getConfigFilePath(String basePath) {
        String path = basePath + File.separatorChar + METADATA_TXT;
        if (new File(path).exists()) {
            return path;
        }
        return basePath + File.separatorChar + CONFIG_ADK;
    }

    public static void performBuild(File adapterProjectDirectory, List<MarkerInfo> markerList) throws CheckException, AdapterBuildException, IOException {
        block38: {
            String projectRootPath = adapterProjectDirectory.getAbsolutePath() + File.separatorChar;
            String srcManifest = BuildProvider.getConfigFilePath(adapterProjectDirectory);
            String tempManifest = adapterProjectDirectory.getAbsolutePath() + File.separatorChar + "META-INF" + File.separatorChar;
            Properties manifestProperties = BuildProviderUtil.getManifestProperties(srcManifest);
            boolean isNewComponentProject = BuildProviderUtil.isNewComponentProject(manifestProperties);
            boolean isInternal = BuildProviderUtil.isInternal(manifestProperties);
            AdapterProjectChecks adapterProjectChecks = new AdapterProjectChecks(isNewComponentProject);
            adapterProjectChecks.checkAdapterProject(adapterProjectDirectory, markerList);
            MarkerInfo info = new MarkerInfo("Adapter check has been executed successfully", -1, null, 0);
            markerList.add(info);
            File target = new File(adapterProjectDirectory.getAbsolutePath() + File.separatorChar + "target" + File.separatorChar + "build" + File.separatorChar + adapterProjectDirectory.getName());
            try {
                Files.deleteIfExists(target.toPath());
            }
            catch (IOException e1) {
                info = new MarkerInfo("Target folder could not be deleted", -1, null, 2);
                markerList.add(info);
                throw e1;
            }
            boolean mkdirs = target.mkdirs();
            if (!mkdirs) {
                info = new MarkerInfo("Target folder could not be created", -1, null, 1);
                markerList.add(info);
            }
            File tempManifestFile = null;
            File tempFile = null;
            try {
                boolean deleteFileWithChildren;
                tempManifestFile = new File(tempManifest);
                if (tempManifestFile.exists() && !(deleteFileWithChildren = FileUtil.deleteFileWithChildren(tempManifestFile))) {
                    info = new MarkerInfo("Target folder could not be deleted", -1, null, 1);
                    markerList.add(info);
                }
                if (tempManifestFile.mkdir()) {
                    tempFile = new File(tempManifest + MANIFEST_FILE_NAME);
                    boolean createNewFile = tempFile.createNewFile();
                    if (createNewFile) {
                        BuildProviderUtil.populateManifest(srcManifest, tempFile);
                    } else {
                        info = new MarkerInfo("Temporary file could not be created", -1, null, 1);
                        markerList.add(info);
                    }
                }
                Manifest manifestObject = null;
                if (tempFile != null && tempFile.exists()) {
                    manifestObject = BuildProvider.createManifest(markerList, tempFile);
                }
                BuildProviderUtil.populateOtherContent(adapterProjectDirectory, target);
                String jarAbsolutePath = target.getAbsolutePath() + File.separatorChar + target.getName() + ".jar";
                File buildResult = BuildProvider.getBuildResult(target, manifestObject, jarAbsolutePath);
                if (buildResult != null) {
                    info = new MarkerInfo("Building the adapter..", -1, null, 0);
                    markerList.add(info);
                    String esaPath = target.getAbsolutePath() + ".esa";
                    AdapterSubsystemBuildHandler provider = new AdapterSubsystemBuildHandler(new ImportPackageAllowlist());
                    provider.setInternal(isInternal);
                    byte[] projectContent = FileUtil.getByteContent(jarAbsolutePath);
                    List<byte[]> content = BuildProvider.getContent(markerList, projectRootPath, provider, projectContent);
                    File esaFile = new File(esaPath);
                    Files.deleteIfExists(esaFile.toPath());
                    info = new MarkerInfo(".esa file will be generated at: " + esaPath, -1, null, 0);
                    markerList.add(info);
                    try (FileOutputStream fos = new FileOutputStream(esaFile);
                         ByteArrayInputStream readInputStream = new ByteArrayInputStream(content.get(content.size() - 1));){
                        FileUtil.copyStream(readInputStream, fos);
                        break block38;
                    }
                }
                info = new MarkerInfo("Build failed", -1, null, 2);
                markerList.add(info);
                throw new AdapterBuildException("Build failed");
            }
            catch (Exception e) {
                info = new MarkerInfo("Adapter build failed: " + e.getMessage(), -1, null, 2);
                markerList.add(info);
                throw new AdapterBuildException("Adapter build failed: " + e.getMessage(), e);
            }
            finally {
                BuildProvider.checkForErrors(markerList, target, tempManifestFile);
            }
        }
    }

    private static void checkForErrors(List<MarkerInfo> markerList, File target, File tempManifestFile) {
        MarkerInfo info;
        boolean deleteFileWithChildren;
        if (tempManifestFile != null && tempManifestFile.exists() && !(deleteFileWithChildren = FileUtil.deleteFileWithChildren(tempManifestFile))) {
            info = new MarkerInfo(tempManifestFile.getName() + " could not be deleted", -1, null, 1);
            markerList.add(info);
        }
        if (target.exists() && !(deleteFileWithChildren = FileUtil.deleteFileWithChildren(target))) {
            info = new MarkerInfo(target.getName() + " could not be deleted", -1, null, 1);
            markerList.add(info);
        }
    }

    /*
     * Exception decompiling
     */
    private static File getBuildResult(File target, Manifest manifestObject, String jarAbsolutePath) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static File cleanBuild(File target) throws IOException {
        File buildResult = null;
        File[] files = target.listFiles();
        if (files == null) {
            throw new IOException("Target files could not be created");
        }
        for (File file : files) {
            if (!(target.getName() + ".jar").equals(file.getName())) {
                BuildProviderUtil.delete(file);
                continue;
            }
            buildResult = file;
        }
        return buildResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest createManifest(List<MarkerInfo> markerList, File tempFile) {
        try (FileInputStream manifestStream = new FileInputStream(tempFile);){
            Manifest throwable3 = new Manifest(manifestStream);
            return throwable3;
        }
        catch (Exception e) {
            MarkerInfo info = new MarkerInfo("Build failed: " + e.getMessage(), -1, null, 2);
            markerList.add(info);
            return null;
        }
    }

    private static List<byte[]> getContent(List<MarkerInfo> markerList, String projectRootPath, AdapterSubsystemBuildHandler provider, byte[] projectContent) throws AdapterBuildException {
        try {
            return provider.build(projectContent, projectRootPath, false);
        }
        catch (Exception e) {
            MarkerInfo info = new MarkerInfo("Build failed: " + e.getMessage(), -1, null, 2);
            markerList.add(info);
            throw new AdapterBuildException("Build failed:" + e.getMessage(), e);
        }
    }
}

