/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.util.PackageUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPackageAllowlist {
    private static final Logger log = LoggerFactory.getLogger(ImportPackageAllowlist.class);
    public static final String EXPORT_PACKAGE = "Export-Package";
    public final List<Pattern> allowedPatterns = new ArrayList<Pattern>();
    public final List<String> allowedPackages = new ArrayList<String>();

    public ImportPackageAllowlist() {
        this.allowedPatterns.add(Pattern.compile("^javax(.+)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.apache\\.camel(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.slf4j(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.apache\\.commons(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.osgi\\.(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.w3c\\.dom(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^org\\.xml\\.sax(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^com\\.sap\\.it\\.api(.*)$"));
        this.allowedPatterns.add(Pattern.compile("^com\\.sap\\.core\\.communication\\.server(.*)$"));
    }

    public void allowlistSystemBundlePackages(Dictionary<String, String> headers) {
        String exportPackage = headers.get(EXPORT_PACKAGE);
        if (exportPackage != null) {
            List<String> packages = PackageUtil.splitToPackageList(exportPackage);
            this.allowedPackages.addAll(packages);
            log.debug("Added {} packages from the system bundle to the import allowlist.", (Object)packages.size());
        }
    }

    public boolean matches(String calculatedImport) {
        for (Pattern pattern : this.allowedPatterns) {
            if (!pattern.matcher(calculatedImport).matches()) continue;
            return true;
        }
        return this.allowedPackages.contains(calculatedImport);
    }
}

