/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.util.PackageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestAnalyzer {
    public static final String SUBSYSTEM_EXPORT_SERVICES = "org.apache.camel.spi.ComponentResolver,org.osgi.service.blueprint.container.BlueprintListener,com.sap.it.nm.component.ComponentMonitor,com.sap.it.api.adapter.monitoring.AdapterEndpointInformationService";
    public static final String SUBSYSTEM_IMPORT_SERVICES = "com.sap.it.op.component.check.ServiceComponentRuntimeAccess; filter:=\"(service.id=*)\", com.sap.cloud.crypto.keystore.api.KeyStoreService; filter:=\"(service.id=*)\"";
    public static final String OSGI_EXTENDER_FILTER_APACHE_CAMEL = "osgi.extender; filter:=\"(osgi.extender=org.apache.camel)\"";
    private static final Logger log = LoggerFactory.getLogger(ManifestAnalyzer.class);
    private static final List<String> manifestAttributesToBeAddedToComponent = Arrays.asList("SAP-BundleType", "SAP-NodeType", "Developer-Id", "Adapter-Id", "SAP-AdapterName", "Adapter-Version", "Bundle-ManifestVersion");
    private static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    private static final String IGNORE_VENDOR = "sap";
    private static final CharSequence VENDOR = "vendor::";

    public Manifest createSubsystemManifest(String path, Map<String, String> manifestContent, List<String> manifestImports, String componentId) throws IOException {
        log.debug("creating subsystem manifest: transferring entries from adapter manifest");
        Manifest subsystemManifest = new Manifest();
        Manifest bundleManifest = this.readAdapterManifest(path);
        this.transferManifestAttributes(bundleManifest, subsystemManifest);
        log.debug("creating subsystem manifest: adding new manifest entries");
        subsystemManifest.getMainAttributes().putValue("Subsystem-ManifestVersion", "1.0");
        String bundleSymbolicName = this.normalizeSymbolicName(bundleManifest.getMainAttributes().getValue("Bundle-SymbolicName"));
        subsystemManifest.getMainAttributes().putValue("Subsystem-Name", bundleSymbolicName);
        String vendor = bundleManifest.getMainAttributes().getValue("Bundle-Vendor");
        if (componentId != null && componentId.contains(VENDOR)) {
            bundleSymbolicName = this.getUpdatedSubsystemSymbolicNameWithVendor(vendor, bundleSymbolicName);
        }
        subsystemManifest.getMainAttributes().putValue("Bundle-Vendor", vendor);
        subsystemManifest.getMainAttributes().putValue("Subsystem-SymbolicName", bundleSymbolicName);
        subsystemManifest.getMainAttributes().putValue("SAP-ArtifactId", bundleSymbolicName);
        String bundleVersion = bundleManifest.getMainAttributes().getValue("Bundle-Version");
        if (bundleVersion == null) {
            bundleVersion = bundleManifest.getMainAttributes().getValue("Adapter-Version");
        }
        subsystemManifest.getMainAttributes().putValue("Subsystem-Version", bundleVersion);
        subsystemManifest.getMainAttributes().putValue("Subsystem-Type", "osgi.subsystem.composite");
        subsystemManifest.getMainAttributes().put(new Attributes.Name("Subsystem-Content"), this.getSubsystemContentAsString(manifestContent, bundleSymbolicName, bundleVersion));
        String adapterName = bundleManifest.getMainAttributes().getValue("SAP-AdapterName");
        this.addPackagesFromManifest(adapterName, bundleManifest.getMainAttributes().getValue("Import-Package"), "imported", manifestImports);
        ArrayList<String> inheritedSubsystemPackageExports = new ArrayList<String>();
        this.addPackagesFromManifest(adapterName, bundleManifest.getMainAttributes().getValue("Export-Package"), "exported", inheritedSubsystemPackageExports);
        subsystemManifest.getMainAttributes().put(new Attributes.Name("Import-Package"), this.getSubsystemPackageAsString(manifestImports));
        if (!inheritedSubsystemPackageExports.isEmpty()) {
            subsystemManifest.getMainAttributes().putValue("Subsystem-Type", "osgi.subsystem.feature");
        }
        this.addMandatoryManifestAttributes(subsystemManifest);
        return subsystemManifest;
    }

    private String getUpdatedSubsystemSymbolicNameWithVendor(String vendor, String bundleSymbolicName) {
        if (!this.isNullOrEmpty(vendor) && !vendor.equalsIgnoreCase(IGNORE_VENDOR)) {
            return bundleSymbolicName + "_" + vendor;
        }
        return bundleSymbolicName;
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private void addPackagesFromManifest(String adapterName, String importPackages, String direction, List<String> manifestPackages) {
        if (importPackages != null && !importPackages.isEmpty()) {
            List<String> packages = PackageUtil.splitToPackageList(importPackages);
            for (String explicitImportPackage : packages) {
                if (manifestPackages.contains(explicitImportPackage)) continue;
                log.error("In adapter {}, explicitly {} non-allowing package found", (Object)adapterName, (Object)direction);
                log.error("This package: {}, is highly discouraged as the packages may be updated/removed withoutfurther notice and may break compatibility.", (Object)explicitImportPackage);
                manifestPackages.add(explicitImportPackage);
            }
        }
    }

    private String normalizeSymbolicName(String value) {
        return value.contains(";") ? value.split(";")[0] : value;
    }

    private void addMandatoryManifestAttributes(Manifest subsystemManifest) {
        subsystemManifest.getMainAttributes().put(new Attributes.Name("Require-Capability"), OSGI_EXTENDER_FILTER_APACHE_CAMEL);
        subsystemManifest.getMainAttributes().put(new Attributes.Name("Subsystem-ExportService"), SUBSYSTEM_EXPORT_SERVICES);
        subsystemManifest.getMainAttributes().put(new Attributes.Name("Subsystem-ImportService"), SUBSYSTEM_IMPORT_SERVICES);
    }

    private String getSubsystemPackageAsString(List<String> staticPackages) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < staticPackages.size(); ++i) {
            String staticImportPackage = staticPackages.get(i);
            sb.append(staticImportPackage);
            if (i + 1 == staticPackages.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getSubsystemContentAsString(Map<String, String> manifestContent, String subsystemSymbolicName, String subsystemVersion) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> next : manifestContent.entrySet()) {
            String symbolicName = next.getKey();
            String version = next.getValue();
            sb.append(symbolicName).append(";").append("version").append("=").append("\"[").append(version).append(",").append(version).append("]\"").append(",");
        }
        sb.append(subsystemSymbolicName).append(".monitor;version=\"[").append(subsystemVersion).append(",").append(subsystemVersion).append("]\"");
        return sb.toString();
    }

    private Manifest readAdapterManifest(String path) throws IOException {
        File manifestFile = new File(path + File.separatorChar + "META-INF" + File.separatorChar + MANIFEST_FILE_NAME);
        Manifest adapterManifest = null;
        if (manifestFile.exists()) {
            try (FileInputStream manifestStream = new FileInputStream(manifestFile);){
                adapterManifest = new Manifest(manifestStream);
            }
        }
        if (adapterManifest == null) {
            throw new RuntimeException("No Manifest found");
        }
        return adapterManifest;
    }

    private void transferManifestAttributes(Manifest adapterManifest, Manifest subsystemManifest) {
        this.setMandatoryVersionToAvoidAttributeLoss(subsystemManifest);
        for (String attributeName : manifestAttributesToBeAddedToComponent) {
            String value = adapterManifest.getMainAttributes().getValue(attributeName);
            if (value == null) continue;
            subsystemManifest.getMainAttributes().putValue(attributeName, value);
        }
    }

    private void setMandatoryVersionToAvoidAttributeLoss(Manifest subsystemManifest) {
        subsystemManifest.getMainAttributes().putValue("Manifest-Version", "1.0");
    }
}

