/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.build.SubsystemContentInformation;
import com.sap.cloud.adk.checks.VersionComparator;
import com.sap.cloud.adk.util.AdapterMetadataBuildUtil;
import com.sap.cloud.adk.util.EsaOutputStream;
import com.sap.cloud.adk.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCapabilityProvider {
    private static final Logger log = LoggerFactory.getLogger(MetadataCapabilityProvider.class);
    private static final String CAPABILITY_NS_PREFIX = "com.sap.it.capability.adapter";
    private static final String BP_CAPABILITY_NS_PREFIX = "com.sap.it.capability.bpMetadata";
    private static final String METADATA_LOCATION = "metadata/metadata.xml";
    private static final String BP_METADATA_LOCATION = "metadata/bluprintMetadata.xml";
    private static final String CAPABILITY_TEMPLATE_OLD = "{symbolicname}; name:String=\"{name}\"; description:String=\"{dname}\"; version:Version=\"{version}\"; metadata:String=\"/{path}\"; displayName:String=\"{dname}\"";
    private static final String CAPABILITY_TEMPLATE_NEW = "{symbolicname}; name:String=\"{name}\"; description:String=\"{dname}\"; vendor:String=\"{vendor}\"; version:Version=\"{version}\"; metadata:String=\"/{path}\"; displayName:String=\"{dname}\"";
    private static final String PROVIDE_CAPABILITY = "Provide-Capability";
    private final SubsystemContentInformation subsystemInformation;
    String metadataLocation = "metadata/metadata.xml";
    String version = null;
    String variantId = null;
    String name = null;
    private boolean isVendorPresentInComponentId;

    public MetadataCapabilityProvider(SubsystemContentInformation subsystemInformation) {
        this.subsystemInformation = subsystemInformation;
    }

    public void addCapabilityDefinitionToManifest(Manifest subsystemManifest, Boolean isVendorPresentComponentId, String cmdPath) throws IOException, ParserConfigurationException {
        this.name = this.subsystemInformation.getSubsystemName();
        this.isVendorPresentInComponentId = isVendorPresentComponentId;
        if (cmdPath.contains("bpMetadata.xml")) {
            this.createProvideCapabilityForBPMetadata(subsystemManifest, cmdPath);
        } else {
            this.getMetadataLocation(cmdPath);
            this.createProvideCapability(subsystemManifest, this.name, CAPABILITY_NS_PREFIX, this.metadataLocation);
        }
    }

    private void createProvideCapabilityForBPMetadata(Manifest manifest, String bmdPath) throws ParserConfigurationException, IOException {
        ByteArrayInputStream cmdInputStream = AdapterMetadataBuildUtil.getMetadataInputStreamFromPath(bmdPath);
        List<String> variantIds = AdapterMetadataBuildUtil.getVariantIds(AdapterMetadataBuildUtil.bytesToXml(cmdInputStream));
        for (String variantIdValue : variantIds) {
            this.version = VersionComparator.getVersionFromComponent(variantIdValue);
            this.createProvideCapability(manifest, variantIdValue, BP_CAPABILITY_NS_PREFIX, BP_METADATA_LOCATION);
        }
    }

    private void getMetadataLocation(String cmdPath) throws IOException, ParserConfigurationException {
        ByteArrayInputStream cmdInputStream = AdapterMetadataBuildUtil.getMetadataInputStreamFromPath(cmdPath);
        List<String> variantIds = AdapterMetadataBuildUtil.getVariantIds(AdapterMetadataBuildUtil.bytesToXml(cmdInputStream));
        if (!variantIds.isEmpty()) {
            this.variantId = AdapterMetadataBuildUtil.getLatestVariant(variantIds);
            this.version = VersionComparator.getVersionFromComponent(this.variantId);
        }
        try {
            this.metadataLocation = AdapterMetadataBuildUtil.getMetadataLocationForProvideCapability(cmdPath);
            if (!this.metadataLocation.contains(METADATA_LOCATION) && this.variantId != null) {
                this.name = this.variantId;
            }
        }
        catch (Exception e) {
            log.debug("Error: Metadata Location could not be computed - Taking deafult location for Provide Capability");
        }
    }

    private void createProvideCapability(Manifest subsystemManifest, String name, String capabilityNS, String metadataLocation) {
        if (this.version == null) {
            this.version = this.subsystemInformation.getSubsystemVersion();
        }
        String vendor = this.subsystemInformation.getBundleVendor();
        String dname = this.subsystemInformation.getAdapterName();
        if (this.isVendorPresentInComponentId) {
            subsystemManifest.getMainAttributes().putValue(PROVIDE_CAPABILITY, this.getActualValue(subsystemManifest, CAPABILITY_TEMPLATE_NEW.replace("{symbolicname}", capabilityNS).replace("{name}", this.getName(name, vendor)).replace("{vendor}", vendor).replace("{version}", this.version).replace("{path}", metadataLocation).replace("{dname}", dname)));
        } else {
            this.setCapabilityWithoutVendorFormat(subsystemManifest, name, vendor, dname, capabilityNS, this.version, metadataLocation);
        }
    }

    private void setCapabilityWithoutVendorFormat(Manifest subsystemManifest, String name, String vendor, String dname, String capabilityNS, String version, String metadataLocation) {
        subsystemManifest.getMainAttributes().putValue(PROVIDE_CAPABILITY, this.getActualValue(subsystemManifest, CAPABILITY_TEMPLATE_OLD.replace("{symbolicname}", capabilityNS).replace("{name}", this.getName(name, vendor)).replace("{vendor}", vendor).replace("{version}", version).replace("{path}", metadataLocation).replace("{dname}", dname)));
    }

    private String getActualValue(Manifest subsystemManifest, String newValue) {
        String existingValue = subsystemManifest.getMainAttributes().getValue(PROVIDE_CAPABILITY);
        if (existingValue == null) {
            return newValue;
        }
        return " " + newValue + "," + existingValue;
    }

    private String getName(String name, String vendor) {
        if (name.startsWith("ctype")) {
            return name;
        }
        return vendor + ":" + name;
    }

    public void copyMetadataFile(ByteArrayOutputStream bufferedStream, EsaOutputStream subsystemOutputStream, String cmdPath) {
        try (ByteArrayInputStream copyStream = new ByteArrayInputStream(bufferedStream.toByteArray());){
            ZipEntry metadataFile = new ZipEntry(AdapterMetadataBuildUtil.getMetadataLocationFromPath(cmdPath));
            subsystemOutputStream.putNextEntry(metadataFile);
            FileUtil.copyStream(copyStream, subsystemOutputStream);
            subsystemOutputStream.closeEntry();
        }
        catch (Exception e) {
            log.error("Cannot Copy Metadata Files to .esa bundle", (Throwable)e);
        }
    }

    public void copyBPMetadataFile(byte[] byteArray, EsaOutputStream subsystemOutputStream) throws IOException {
        try (ByteArrayInputStream bpStream = new ByteArrayInputStream(byteArray);){
            subsystemOutputStream.putNextEntry(new ZipEntry(BP_METADATA_LOCATION));
            FileUtil.copyStream(bpStream, subsystemOutputStream);
            subsystemOutputStream.closeEntry();
        }
    }
}

