/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build;

import com.sap.cloud.adk.build.ImportPackageAllowlist;
import com.sap.cloud.adk.util.PackageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemInfoCube {
    private static final Logger log = LoggerFactory.getLogger(SubsystemInfoCube.class);
    static final List<String> staticMonitorImports = Arrays.asList("com.sap.it.op.component.check", "org.osgi.service.blueprint.container", "com.sap.it.nm.component", "com.sap.esb.monitoring.messages.adapter");
    private final ImportPackageAllowlist importPackageAllowlist;
    private Manifest camelComponentManifest = null;
    private final Map<String, Manifest> dependentLibraries = new LinkedHashMap<String, Manifest>();
    private final Map<String, String> subsystemManifestContentNameVersion = new LinkedHashMap<String, String>();

    public SubsystemInfoCube(ImportPackageAllowlist importPackageAllowlist) {
        this.importPackageAllowlist = importPackageAllowlist;
    }

    public Map<String, String> getSubsysManifestContent() {
        return this.subsystemManifestContentNameVersion;
    }

    public List<String> calculateSubsystemImports(boolean skipImportAllowlist) {
        List<String> calculatedImports = new ArrayList<String>();
        String importPackage = this.camelComponentManifest.getMainAttributes().getValue("Import-Package");
        List<String> importPackages = PackageUtil.splitToPackageList(importPackage.toString());
        log.debug("Import-Packages specified on camel component: {}", importPackages);
        String exportPackage = this.camelComponentManifest.getMainAttributes().getValue("Export-Package");
        List<String> exportPackages = PackageUtil.splitToPackageList(exportPackage.toString());
        log.debug("Export-Packages specified on camel component: {}", exportPackages);
        this.addMissingComponentDependencies(calculatedImports, importPackages, this.dependentLibraries.values());
        log.debug("Calculated imports after adding missing component dependencies: {}", calculatedImports);
        Set<Map.Entry<String, Manifest>> entrySet = this.dependentLibraries.entrySet();
        for (Map.Entry<String, Manifest> entry : entrySet) {
            String libraryKey = entry.getKey();
            Manifest libraryManifest = entry.getValue();
            String libraryImportPackage = libraryManifest.getMainAttributes().getValue("Import-Package");
            if (libraryImportPackage == null) continue;
            List<String> libraryImportPackagesRaw = PackageUtil.splitToPackageList(libraryImportPackage.toString());
            List<String> libraryImportPackageClean = this.normalizePackageNames(libraryImportPackagesRaw);
            ArrayList<String> distinctLibraryImports = new ArrayList<String>(libraryImportPackageClean);
            this.checkComponentExports(exportPackages, distinctLibraryImports);
            this.checkLibraryExports(libraryKey, distinctLibraryImports);
            calculatedImports.addAll(distinctLibraryImports);
            log.debug("Added distinct library imports: {}", distinctLibraryImports);
        }
        calculatedImports = this.filterImportStatementsBasedOnAllowlist(calculatedImports, skipImportAllowlist);
        log.debug("Added static monitor in addition ot the calculated imports: {}", staticMonitorImports);
        calculatedImports.addAll(staticMonitorImports);
        return calculatedImports;
    }

    private List<String> filterImportStatementsBasedOnAllowlist(List<String> calculatedImports, boolean skipImportAllowlist) {
        ArrayList<String> result = new ArrayList<String>();
        for (String calculatedImport : calculatedImports) {
            if (skipImportAllowlist || this.importPackageAllowlist.matches(calculatedImport)) {
                result.add(calculatedImport);
                continue;
            }
            log.warn("Calculated import package {} is not allow listed and will be ignored.", (Object)calculatedImport);
        }
        return result;
    }

    private void checkLibraryExports(String libraryKey, List<String> distinctLibraryImports) {
        Set<Map.Entry<String, Manifest>> dependentLibraryEntries = this.dependentLibraries.entrySet();
        for (Map.Entry<String, Manifest> dependentLibraryEntry : dependentLibraryEntries) {
            String exportPackage;
            if (libraryKey.equals(dependentLibraryEntry.getKey()) || (exportPackage = dependentLibraryEntry.getValue().getMainAttributes().getValue("Export-Package")) == null) continue;
            List<String> packageList = PackageUtil.splitToPackageList(exportPackage);
            this.checkComponentExports(packageList, distinctLibraryImports);
        }
    }

    private void checkComponentExports(List<String> exportPackages, List<String> distinctLibraryImports) {
        List<String> normalizedComponentExportPackages = this.normalizePackageNames(exportPackages);
        for (String componentExportPackage : normalizedComponentExportPackages) {
            distinctLibraryImports.remove(componentExportPackage);
        }
    }

    private void addMissingComponentDependencies(List<String> resultingImports, List<String> importPackages, Collection<Manifest> otherLibraries) {
        resultingImports.addAll(importPackages);
        for (Manifest libraryManifest : otherLibraries) {
            String libraryExportPackage = libraryManifest.getMainAttributes().getValue("Export-Package");
            if (libraryExportPackage == null) continue;
            List<String> libraryExportPackagesRaw = PackageUtil.splitToPackageList(libraryExportPackage.toString());
            this.checkComponentExports(libraryExportPackagesRaw, resultingImports);
        }
    }

    private List<String> normalizePackageNames(List<String> rawLibraryExportPackages) {
        ArrayList<String> normalizedPackageList = new ArrayList<String>();
        for (String rawPackageName : rawLibraryExportPackages) {
            String correctedPackage;
            if (rawPackageName.contains(";")) {
                correctedPackage = rawPackageName.split(";")[0];
            } else {
                if (rawPackageName.contains(")")) continue;
                correctedPackage = rawPackageName;
            }
            normalizedPackageList.add(correctedPackage);
        }
        log.debug("Normalized packages names from \"{}\" to {}", rawLibraryExportPackages, normalizedPackageList);
        return normalizedPackageList;
    }

    public void addCamelComponentManifest(Manifest manifest) {
        if (this.camelComponentManifest != null) {
            throw new UnsupportedOperationException("Currently only one camel component is supported.");
        }
        this.camelComponentManifest = manifest;
        this.subsystemManifestContentNameVersion.put(this.camelComponentManifest.getMainAttributes().getValue("Bundle-SymbolicName"), this.camelComponentManifest.getMainAttributes().getValue("Bundle-Version"));
    }

    public void addDependentLibraryManifest(Manifest manifest) {
        String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        this.dependentLibraries.put(symbolicName, manifest);
        this.subsystemManifestContentNameVersion.put(symbolicName, manifest.getMainAttributes().getValue("Bundle-Version"));
    }
}

