/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.build.archive;

import com.sap.cloud.adk.build.BuildProvider;
import com.sap.cloud.adk.exception.AdapterBuildException;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.pluginutil.MarkerInfoHelper;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE)
public class AdapterBuilderMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", property="adapterProjectDirectory", required=false)
    private File adapterProjectDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        if (this.adapterProjectDirectory.exists()) {
            log.info((CharSequence)("Path of the adapter to be built: " + this.adapterProjectDirectory.getAbsolutePath()));
            try {
                this.performBuild(log);
            }
            catch (Exception e) {
                log.error((CharSequence)("Adapter build failed due to: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Build failed");
            }
        } else {
            log.error((CharSequence)"Could not find the project directory");
            throw new MojoExecutionException("Build failed: Could ot find the project directory");
        }
    }

    public void setProjectDirectory(File adapterProjectDirectory) {
        this.adapterProjectDirectory = adapterProjectDirectory;
    }

    private void performBuild(Log log) throws CheckException, AdapterBuildException, IOException {
        ArrayList<MarkerInfo> markerList = new ArrayList<MarkerInfo>();
        try {
            BuildProvider.performBuild(this.adapterProjectDirectory, markerList);
        }
        finally {
            MarkerInfoHelper.writeToLog(log, markerList);
        }
    }
}

