/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.check;

import com.sap.cloud.adk.checks.AdapterProjectChecks;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.generate.metadata.MetadataProperties;
import com.sap.cloud.adk.pluginutil.AdapterProjectUtil;
import com.sap.cloud.adk.pluginutil.MarkerInfoHelper;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.PACKAGE)
public class AdapterProjectChecksMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", property="adapterProjectDirectory", required=true)
    private File adapterProjectDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Execute adapter project checks");
        if (this.adapterProjectDirectory.exists()) {
            try {
                this.performChecks(log);
            }
            catch (Exception e) {
                log.error((CharSequence)("Adapter project checks failed due to: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Component metadata generate failed");
            }
        } else {
            log.error((CharSequence)"Could not find the project directory");
            throw new MojoExecutionException("Execute checks failed: Could ot find the project directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performChecks(Log log) throws IOException, CheckException {
        ArrayList<MarkerInfo> markerList = new ArrayList<MarkerInfo>();
        try {
            MetadataProperties properties = AdapterProjectUtil.populateMetadataProperties(this.adapterProjectDirectory);
            if (properties.isReuseProject()) {
                markerList.add(new MarkerInfo("Check adapter project for component reuse", -1, null, 0));
            }
            AdapterProjectChecks checks = new AdapterProjectChecks(!properties.isReuseProject());
            try {
                checks.checkAdapterProject(this.adapterProjectDirectory, markerList);
            }
            catch (CheckException e) {
                markerList.add(new MarkerInfo("Adapter project checks failed", -1, null, 2));
                throw e;
            }
            markerList.add(new MarkerInfo("Adapter project checks executed successfully", -1, null, 0));
        }
        finally {
            MarkerInfoHelper.writeToLog(log, markerList);
        }
    }

    public void setProjectDirectory(File adapterProjectDirectory) {
        this.adapterProjectDirectory = adapterProjectDirectory;
    }
}

