/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeValidation {
    public static Set<String> checkAttributesWithSameValues(NamedNodeMap attributeNodeMap, List<MarkerInfo> infoList, int lineNumber, String tagLocalName, File metadataFile) throws CheckException {
        HashSet<String> attributes = new HashSet<String>();
        HashMap<String, String> attributeValues = new HashMap<String, String>();
        for (int index = 0; index < attributeNodeMap.getLength(); ++index) {
            Node attributeNode = attributeNodeMap.item(index);
            if (!attributeValues.containsKey(attributeNode.getNodeValue())) {
                attributeValues.put(attributeNode.getNodeValue(), attributeNode.getNodeName());
                continue;
            }
            attributes.add(attributeNode.getNodeName());
            attributes.add((String)attributeValues.get(attributeNode.getNodeValue()));
        }
        if (!attributes.isEmpty()) {
            String msg = "You cannot have the same set of attribute " + ((Object)attributes).toString() + " values.";
            MarkerInfo markerInfo = new MarkerInfo(msg, lineNumber, metadataFile.getAbsolutePath(), 2);
            infoList.add(markerInfo);
            throw new CheckException("Build failed as the validation of Blueprint Metadata failed");
        }
        return attributes;
    }
}

