/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.checks.AttributeValidation;
import com.sap.cloud.adk.checks.ChecksUtil;
import com.sap.cloud.adk.checks.ComponentMetadataAttributes;
import com.sap.cloud.adk.checks.PatternValidator;
import com.sap.cloud.adk.checks.XSDValidation;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.MarkerInfo;
import com.sap.cloud.adk.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BlueprintMetadataValidator {
    private Document document = null;
    private boolean exceptionCaused = false;
    private XMLParser xmlParser = null;
    private File metadataFile = null;
    private static final String[] whitelistedTags = new String[]{"bean", "reference", "cxfEndpoint", "bus", "conduit"};
    private ComponentMetadataAttributes cmdAttributes;

    public BlueprintMetadataValidator(File bpMetadataFile, NodeList cmdAttributeNodeList) {
        this.metadataFile = bpMetadataFile;
        this.xmlParser = new XMLParser();
        this.cmdAttributes = new ComponentMetadataAttributes(cmdAttributeNodeList);
    }

    public void validateBlueprintMetadata(List<MarkerInfo> infoList) throws CheckException, SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        this.document = this.xmlParser.parseWithLineNumbers(this.metadataFile);
        try {
            XSDValidation.checkBPMetadataAgainstSchema(this.metadataFile, infoList);
            this.checkBlueprintTagsReferencesAndUniqueAttributeValues(infoList);
        }
        catch (CheckException e) {
            this.exceptionCaused = true;
        }
        if (this.exceptionCaused) {
            throw new CheckException("Build failed as the validation of ComponentMetadata failed");
        }
    }

    public void checkBlueprintTagsReferencesAndUniqueAttributeValues(List<MarkerInfo> infoList) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, CheckException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList blueprintTagList = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/descendant::*").evaluate(this.document, XPathConstants.NODESET);
        HashMap<String, List<String>> identifierToTagList = new HashMap<String, List<String>>();
        identifierToTagList.put("id", Arrays.asList(whitelistedTags));
        identifierToTagList.put("bus", Arrays.asList("bus"));
        this.checkReferencesForTags(blueprintTagList, whitelistedTags, identifierToTagList, infoList);
    }

    private void checkReferencesForTags(NodeList blueprintTagList, String[] whiteListedTags, Map<String, List<String>> identifierToTagList, List<MarkerInfo> infoList) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException, CheckException {
        for (int index = 0; index < blueprintTagList.getLength(); ++index) {
            Node tag = blueprintTagList.item(index);
            String tagLocalName = ChecksUtil.getTagNameWOPrefix(tag.getNodeName());
            NamedNodeMap attributesMap = tag.getAttributes();
            int lineNumber = Integer.parseInt((String)tag.getUserData("lineNumber"));
            if (ChecksUtil.containsListItem(whiteListedTags, tagLocalName)) {
                String[] identifiers = ChecksUtil.getIdentifier(identifierToTagList, tagLocalName);
                this.checkTagReferencesUsingIdentifiers(infoList, tagLocalName, attributesMap, lineNumber, identifiers);
                AttributeValidation.checkAttributesWithSameValues(attributesMap, infoList, lineNumber, tagLocalName, this.metadataFile);
            }
            PatternValidator.checkAttributesWithWrongPatterns(attributesMap, infoList, lineNumber, tagLocalName, this.metadataFile, this.cmdAttributes.getAttributeReferenceNodes());
        }
    }

    private void checkTagReferencesUsingIdentifiers(List<MarkerInfo> infoList, String tagLocalName, NamedNodeMap attributeNodeMap, int lineNumber, String[] identifiers) throws XPathExpressionException {
        for (String identifier : identifiers) {
            String identifierdValue;
            Node identifierAttributeNode = attributeNodeMap.getNamedItem(identifier);
            if (identifierAttributeNode == null || ChecksUtil.containsListItem(ChecksUtil.DEFAULT_TAG_IDS, identifierdValue = identifierAttributeNode.getNodeValue()) || this.checkBlueprintTagReferBeanORService(identifierdValue, tagLocalName)) continue;
            String msg = "The <bean> tag with identifier " + identifier + " is not referred by any tag in the blueprint";
            MarkerInfo markerInfo = new MarkerInfo(msg, lineNumber, this.metadataFile.getAbsolutePath(), 1);
            infoList.add(markerInfo);
        }
    }

    private boolean checkBlueprintTagReferBeanORService(String id, String tagLocalName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList refEleList = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/descendant-or-self::*/ref").evaluate(this.document, XPathConstants.NODESET);
        for (int index = 0; index < refEleList.getLength(); ++index) {
            Node refEle = refEleList.item(index);
            String referencedId = refEle.getAttributes().getNamedItem("component-id").getNodeValue();
            if (!id.equals(referencedId)) continue;
            return true;
        }
        NodeList propertyElementRef = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/descendant-or-self::*[@value-ref='" + id + "' or @ref = '" + id + "' or @bean='" + id + "' or @factory-ref='" + id + "']").evaluate(this.document, XPathConstants.NODESET);
        if (propertyElementRef.getLength() > 0) {
            return true;
        }
        NodeList tagsWtOtherRef = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/descendant-or-self::*[@" + tagLocalName + "='" + id + "']").evaluate(this.document, XPathConstants.NODESET);
        if (tagsWtOtherRef != null && tagsWtOtherRef.getLength() > 0) {
            return true;
        }
        NodeList camelToURIs = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/camelContext/descendant-or-self::*/to").evaluate(this.document, XPathConstants.NODESET);
        if (ChecksUtil.checkURIReferComponent(camelToURIs, id)) {
            return true;
        }
        NodeList camelFromURIs = (NodeList)xPath.compile("/ComponentMetadata/Variant/GenerationTags/blueprint/*[local-name()='camelContext']/descendant-or-self::*/from").evaluate(this.document, XPathConstants.NODESET);
        return ChecksUtil.checkURIReferComponent(camelFromURIs, id);
    }
}

