/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChecksUtil {
    public static final String SCHEMA_FILE = "/resources/ComponentMetadata.xsd";
    protected static final String[] CAMEL_COMPONENT_PREFIX = new String[]{"cxf:bean:"};
    protected static final String[] DEFAULT_TAG_IDS = new String[]{"customClassResolver", "MessageProcessingLogSink", "IntegrationOperationsErrorEventPublisher", "itOpAgentMplConfiguration", "itOpAgentMplInterceptor", "itOpAgentMplEventNotifier"};

    public static boolean checkURIReferComponent(NodeList camelURIs, String id) {
        for (int index = 0; index < camelURIs.getLength(); ++index) {
            Node camelTO = camelURIs.item(index);
            String uri = camelTO.getAttributes().getNamedItem("uri").getNodeValue();
            String[] uriOptionsString = uri.split("\\?");
            if (uriOptionsString.length > 1) {
                String[] uriOptions;
                for (String uriParameter : uriOptions = uriOptionsString[1].split("//&")) {
                    if (!ChecksUtil.checkReferencedID(uriParameter.split("=")[1], id)) continue;
                    return true;
                }
            }
            if (!ChecksUtil.checkAgainstCamelComponentPrefix(uriOptionsString[0], id)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAgainstCamelComponentPrefix(String string, String id) {
        for (String uriPrefix : CAMEL_COMPONENT_PREFIX) {
            if (!(uriPrefix + id).equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getTagNameWOPrefix(String tagQName) {
        String[] nameWOPrefix = null;
        if (tagQName != null) {
            nameWOPrefix = tagQName.split(":");
        }
        if (nameWOPrefix != null && nameWOPrefix.length > 1) {
            return nameWOPrefix[1];
        }
        return tagQName;
    }

    public static boolean containsListItem(String[] tagNames, String tagQName) {
        List<String> tagsList = Arrays.asList(tagNames);
        return tagsList.contains(ChecksUtil.getTagNameWOPrefix(tagQName));
    }

    public static String[] getIdentifier(Map<String, List<String>> identifierToTagList, String tagLocalName) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : identifierToTagList.entrySet()) {
            if (!entry.getValue().contains(tagLocalName)) continue;
            identifiers.add(entry.getKey());
        }
        return identifiers.toArray(new String[0]);
    }

    private static boolean checkReferencedID(String parameterValue, String id) {
        return parameterValue != null && parameterValue.startsWith("#") && parameterValue.equals("#" + id);
    }
}

