/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.checks.VersionComparator;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.AdapterMetadataBuildUtil;
import com.sap.cloud.adk.util.MarkerInfo;
import com.sap.cloud.adk.util.MetadataProperties;
import com.sap.cloud.adk.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentMetadataValidator {
    private static final String REQUIRED_PROPERTIES = "requiredIntegrationFlowProperties";
    private static final String BP_METADATA = "bpmetadata";
    private static final Logger log = LoggerFactory.getLogger(ComponentMetadataValidator.class);
    private static final String METADATA_FILE = "metadata.xml";
    private static final String ROOT_ELEMENT_XPATH = "/ComponentMetadata";
    private static final String COMPONENT_ID = "ComponentId";
    private static final String COMPONENT_NAME = "ComponentName";
    private static final String VARIANT = "//Variant";
    private static final String VARIANT_ID = "VariantId";
    private static final String ADAPTER_VERSION = "version::";
    private static final String TABLE_NAME_XPATH = "/ComponentMetadata/AttributeTableMetadata/Name";
    private static final String METADATA_NAME_XPATH = "/ComponentMetadata/AttributeMetadata/Name";
    private static final String REFERENCE_NAME_XPATH = "//AttributeReference/ReferenceName";
    private static final String REQUIRED_PROPERTIES_XPATH = "//Metadata/AdditionalMetadata/Name";
    private static final String CNAME = "cname::";
    private static final String LINE_NUMBER_KEY_NAME = "lineNumber";
    private static final String VENDOR = "vendor::";
    private static final String SEPARATOR = ":";
    private static final String VERSION = "/version";
    private final List<String> coveredAttributes = new ArrayList<String>();
    private Document document = null;
    private boolean exceptionCaused = false;
    private XMLParser xmlParser;
    private final File metadataFile;
    private static final String XPATH_EXPRESSION = "/ComponentMetadata/Variant";

    public ComponentMetadataValidator(File metadataFile) {
        this.metadataFile = metadataFile;
        this.xmlParser = new XMLParser();
    }

    public void validateComponentMetadata(List<MarkerInfo> infoList) throws CheckException, SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        this.coveredAttributes.clear();
        if (this.metadataFile == null) {
            throw new CheckException("The Entry for Project is not found or is null");
        }
        String cmdPath = this.metadataFile.getAbsolutePath();
        if (this.metadataFile.length() == 0L) {
            MarkerInfo info = new MarkerInfo("Metadata file is empty", 1, cmdPath, 2);
            infoList.add(info);
            throw new CheckException("Build failed as the metadata file is empty");
        }
        this.checkAgainstSchema(this.metadataFile, infoList);
        if (this.xmlParser == null) {
            this.xmlParser = new XMLParser();
        }
        this.document = this.xmlParser.parseWithLineNumbers(this.metadataFile);
        this.checkIfMultipleVariantsPresent(this.document, this.metadataFile, infoList);
        this.checkAttributeReferences(infoList);
        this.checkRequiredProperties(infoList);
        if (this.exceptionCaused) {
            throw new CheckException("Build failed as the validation of ComponentMetadata failed");
        }
    }

    @Deprecated
    public void compareEndPointNameAndUpdateInfoList(List<MarkerInfo> infoList, String endPointName) throws CheckException {
        this.compareEndPointNameAndUpdateInfoList(infoList, Collections.singleton(endPointName));
    }

    public void compareEndPointNameAndUpdateInfoList(List<MarkerInfo> infoList, Set<String> endPointNames) throws CheckException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(XPATH_EXPRESSION).evaluate(this.document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node variantNode = nodeList.item(i);
                int lineNumber = Integer.parseInt((String)variantNode.getUserData(LINE_NUMBER_KEY_NAME));
                String variantId = variantNode.getAttributes().getNamedItem("gen:RuntimeComponentBaseUri").getNodeValue();
                if (endPointNames == null || endPointNames.contains(variantId)) continue;
                this.exceptionCaused = true;
                String msg = "Attribute 'gen:RuntimeComponentBaseUri' value is not consistent with URI scheme";
                MarkerInfo info = new MarkerInfo(msg, lineNumber, this.metadataFile.getAbsolutePath(), 2);
                infoList.add(info);
            }
        }
        catch (XPathExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (this.exceptionCaused) {
            throw new CheckException("CMD validation failed");
        }
    }

    private void checkIfMultipleVariantsPresent(Document doc, File metadataFile, List<MarkerInfo> infoList) throws CheckException {
        String metadataFileName = AdapterMetadataBuildUtil.getMetadataLocationFromPath(metadataFile.getAbsolutePath());
        List<String> variants = AdapterMetadataBuildUtil.getVariantIds(doc);
        if (!this.isDefaultMetadataFile(metadataFileName) && !this.isBPMetadataFile(metadataFileName) && variants.size() > 1) {
            String errorMessage = "Invalid Content: More than one variants present in Metadata File" + metadataFileName;
            MarkerInfo info = new MarkerInfo(errorMessage, 1, metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            log.error(errorMessage);
            throw new CheckException(errorMessage);
        }
    }

    private boolean isBPMetadataFile(String metadataFileName) {
        return metadataFileName.toLowerCase().contains(BP_METADATA);
    }

    private boolean isDefaultMetadataFile(String metadataFileNameFile) {
        return metadataFileNameFile.contains(METADATA_FILE);
    }

    private void checkAgainstSchema(File cmdFile, List<MarkerInfo> infoList) throws SAXException, IOException {
        SchemaFactory validationFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        validationFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validationFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        Schema schemaFile = validationFactory.newSchema(this.getClass().getResource("/resources/ComponentMetadata.xsd"));
        Validator xmlValidator = schemaFile.newValidator();
        xmlValidator.setErrorHandler(new ErrorHandler(infoList));
        xmlValidator.validate(new StreamSource(cmdFile));
    }

    private void checkRequiredProperties(List<MarkerInfo> infoList) throws XPathExpressionException {
        NodeList attributeList = this.getNodeList(REQUIRED_PROPERTIES_XPATH);
        for (int i = 0; i < attributeList.getLength(); ++i) {
            if (!REQUIRED_PROPERTIES.equals(attributeList.item(i).getFirstChild().getNodeValue())) continue;
            this.validateSupportedRequiredValues(attributeList.item(i).getParentNode().getChildNodes(), infoList);
        }
    }

    private void validateSupportedRequiredValues(NodeList propertyNode, List<MarkerInfo> infoList) {
        for (int i = 0; i < propertyNode.getLength(); ++i) {
            if (!"Value".equals(propertyNode.item(i).getNodeName())) continue;
            String requiredProperties = propertyNode.item(i).getFirstChild().getNodeValue();
            String errorMessage = this.validateActualValuesOfProperties(requiredProperties);
            List<Integer> lineNumberList = this.xmlParser.getLineNumberOfRequiredProperties(this.document, requiredProperties);
            if (lineNumberList.isEmpty() || errorMessage == null) break;
            this.exceptionCaused = true;
            for (int lineNumber : lineNumberList) {
                MarkerInfo info = new MarkerInfo(errorMessage, lineNumber, this.metadataFile.getAbsolutePath(), 2);
                infoList.add(info);
            }
            break;
        }
    }

    private String validateActualValuesOfProperties(String requiredProperties) {
        String[] requiredPropertiesValues = requiredProperties.split("\\s*,\\s*");
        String errorMessage = this.checkForInvalidValue(requiredPropertiesValues);
        if (errorMessage == null) {
            errorMessage = this.checkForDuplicateValue(requiredPropertiesValues);
        }
        return errorMessage;
    }

    private String checkForInvalidValue(String[] requiredPropertiesValues) {
        HashSet<String> expectedValues = new HashSet<String>(Arrays.asList("adapterInstanceID", "adapterVersion", "projectID", "userDefinedNamespaces"));
        for (String requiredProperty : requiredPropertiesValues) {
            if (expectedValues.contains(requiredProperty)) continue;
            return "The given values for \u2018requiredIntegrationFlowProperties\u2019 are incorrect. The values are case sensitive, please check the spelling.";
        }
        return null;
    }

    private String checkForDuplicateValue(String[] requiredPropertiesValues) {
        int propertiesLengthWithRepetition = requiredPropertiesValues.length;
        HashSet<String> actualValues = new HashSet<String>(Arrays.asList(requiredPropertiesValues));
        int propertiesLengthWithOutRepetition = actualValues.size();
        if (propertiesLengthWithOutRepetition < propertiesLengthWithRepetition) {
            return "The given values for \u2018requiredIntegrationFlowProperties\u2019 are incorrect. Duplicate values found, remove the duplicate values.";
        }
        return null;
    }

    private void checkAttributeReferences(List<MarkerInfo> infoList) throws XPathExpressionException {
        int i;
        NodeList attributeList = this.getNodeList(METADATA_NAME_XPATH);
        for (i = 0; i < attributeList.getLength(); ++i) {
            if (!attributeList.item(i).hasChildNodes() || this.coveredAttributes.contains(attributeList.item(i).getFirstChild().getNodeValue())) continue;
            this.coveredAttributes.add(attributeList.item(i).getFirstChild().getNodeValue());
        }
        attributeList = this.getNodeList(TABLE_NAME_XPATH);
        for (i = 0; i < attributeList.getLength(); ++i) {
            if (!attributeList.item(i).hasChildNodes()) continue;
            this.coveredAttributes.add(attributeList.item(i).getFirstChild().getNodeValue());
        }
        NodeList nodeList = this.getNodeList(REFERENCE_NAME_XPATH);
        this.validateAttributes(infoList, nodeList);
    }

    private void validateAttributes(List<MarkerInfo> infoList, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            List<Integer> lineNumberList;
            String referenceName;
            if (!nodeList.item(i).hasChildNodes() || this.coveredAttributes.contains(referenceName = nodeList.item(i).getFirstChild().getNodeValue()) || (lineNumberList = this.xmlParser.getLineNumber(this.document, referenceName)).isEmpty()) continue;
            this.exceptionCaused = true;
            String msg = "AttributeMetadata reference for the AttributeReference " + referenceName + " is missing";
            for (int lineNumber : lineNumberList) {
                MarkerInfo info = new MarkerInfo(msg, lineNumber, this.metadataFile.getAbsolutePath(), 2);
                infoList.add(info);
            }
            this.coveredAttributes.add(referenceName);
        }
    }

    public NodeList getNodeList(String xPathValue) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.compile(xPathValue).evaluate(this.document, XPathConstants.NODESET);
    }

    public void checkConsistencyCMDAndManifest(String manifestFile, List<MarkerInfo> infoList) throws CheckException, XPathExpressionException, IOException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node comp = ((NodeList)xPath.compile(ROOT_ELEMENT_XPATH).evaluate(this.document, XPathConstants.NODESET)).item(0);
        String componentError = "ComponentMetadata not well formed";
        this.checkForNull(comp, 1, componentError, infoList);
        NamedNodeMap namedNodeMap = comp.getAttributes();
        this.checkForNull(namedNodeMap, 1, componentError, infoList);
        String componentId = namedNodeMap.getNamedItem(COMPONENT_ID).getNodeValue();
        this.checkForNull(componentId, 1, componentError, infoList);
        String vendorAdapter = this.getVendorFromComponentId(componentId);
        String componentNameFromId = this.getComponentNameFromId(componentId);
        this.checkForNull(vendorAdapter, 1, componentError, infoList);
        String componentName = namedNodeMap.getNamedItem(COMPONENT_NAME).getNodeValue();
        this.checkForNull(componentName, 1, componentError, infoList);
        String version = componentId.substring(componentId.indexOf(ADAPTER_VERSION) + ADAPTER_VERSION.length());
        this.checkForNull(version, 1, componentError, infoList);
        if (!componentName.equals(componentNameFromId)) {
            String msg = "Build failed as the ComponentId and ComponentName of ComponentMetadata are not consistent; please set the vendor name and adapter name properly";
            MarkerInfo info = new MarkerInfo("Build failed as the ComponentId and ComponentName of ComponentMetadata are not consistent; please set the vendor name and adapter name properly", 2, this.metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            this.exceptionCaused = true;
        }
        NodeList variantNodeList = (NodeList)xPath.compile(VARIANT).evaluate(this.document, XPathConstants.NODESET);
        String variantError = "Variant not well formed";
        this.checkForNull(variantNodeList, 2, variantError, infoList);
        for (int index = 0; index < variantNodeList.getLength(); ++index) {
            MarkerInfo info;
            comp = variantNodeList.item(index);
            this.checkForNull(comp, 2, variantError, infoList);
            namedNodeMap = comp.getAttributes();
            this.checkForNull(namedNodeMap, 2, variantError, infoList);
            String variantId = namedNodeMap.getNamedItem(VARIANT_ID).getNodeValue();
            this.checkForNull(variantId, 2, variantError, infoList);
            int cnameIndex = variantId.indexOf(CNAME) + CNAME.length();
            String cname = variantId.substring(cnameIndex);
            String variantCname = variantId.substring(cnameIndex, cname.indexOf("/") + cnameIndex);
            this.checkForNull(variantCname, 2, variantError, infoList);
            if (variantCname.contains(SEPARATOR) && !variantCname.equals(componentName)) {
                int variantLineNumber = Integer.parseInt((String)comp.getUserData(LINE_NUMBER_KEY_NAME));
                String msg = "cname entry in VariantId does not match ComponentName of ComponentMetadata";
                MarkerInfo info2 = new MarkerInfo(msg, variantLineNumber, this.metadataFile.getAbsolutePath(), 2);
                infoList.add(info2);
                this.exceptionCaused = true;
            }
            String variantVersion = AdapterMetadataBuildUtil.getVariantVersion(variantId);
            String componentVersion = VersionComparator.getVersionFromComponent(componentId);
            if (!VersionComparator.removeMicroVersion(variantVersion).equals(VersionComparator.removeMicroVersion(componentVersion))) {
                int variantLineNumber = Integer.parseInt((String)comp.getUserData(LINE_NUMBER_KEY_NAME));
                info = new MarkerInfo("Variant significant version [" + variantVersion + "] does not conform  to the component version [" + componentVersion + "]. They should be equal.", variantLineNumber, this.metadataFile.getAbsolutePath(), 2);
                infoList.add(info);
                this.exceptionCaused = true;
                continue;
            }
            if (VersionComparator.getMicroVersion(variantVersion) <= VersionComparator.getMicroVersion(componentVersion)) continue;
            int variantLineNumber = Integer.parseInt((String)comp.getUserData(LINE_NUMBER_KEY_NAME));
            info = new MarkerInfo("Variant micro version should be less or equal to component micro version", variantLineNumber, this.metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            this.exceptionCaused = true;
        }
        List<String> componentValues = this.buildComponentValues(vendorAdapter, componentNameFromId);
        this.compareMetadataFiles(manifestFile, componentValues, infoList, version);
        if (this.exceptionCaused) {
            throw new CheckException("CMD validation failed");
        }
    }

    private List<String> buildComponentValues(String vendorAdapter, String componentNameFromId) {
        ArrayList<String> componentValues = new ArrayList<String>();
        if (this.isNotNullOrEmpty(vendorAdapter)) {
            componentValues.add(vendorAdapter);
        }
        if (this.isNotNullOrEmpty(componentNameFromId)) {
            componentValues.add(componentNameFromId.contains(SEPARATOR) ? componentNameFromId.split(SEPARATOR)[1] : componentNameFromId);
        }
        return componentValues;
    }

    private String getVendorFromComponentId(String componentId) {
        if (componentId.contains(VENDOR)) {
            return componentId.substring(componentId.indexOf(VENDOR) + VENDOR.length(), componentId.indexOf(VERSION));
        }
        String componentNameFromId = componentId.substring(componentId.indexOf(CNAME) + CNAME.length(), componentId.indexOf(VERSION));
        if (componentNameFromId.contains(SEPARATOR)) {
            return componentNameFromId.split(SEPARATOR)[0];
        }
        return null;
    }

    private String getComponentNameFromId(String componentId) {
        if (componentId.contains(VENDOR)) {
            return componentId.substring(componentId.indexOf(CNAME) + CNAME.length(), componentId.indexOf("/vendor"));
        }
        return componentId.substring(componentId.indexOf(CNAME) + CNAME.length(), componentId.indexOf(VERSION));
    }

    private boolean isNotNullOrEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    private void compareMetadataFiles(String manifestFile, List<String> componentValues, List<MarkerInfo> infoList, String version) throws IOException {
        MarkerInfo info;
        String msg;
        MetadataProperties properties = new MetadataProperties();
        properties.readMetadataFile(manifestFile);
        String adapterVendor = properties.getAdapteVendor();
        String adapterVersion = properties.getAdapterVersion();
        String adapterId = properties.getAdapterId();
        if (!this.isConsistentId(componentValues, adapterVendor, adapterId)) {
            msg = "Adapter Id or Name or Vendor or Version in metadata.txt/config.adk file is not matching with metadata.xml";
            info = new MarkerInfo(msg, 2, this.metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            this.exceptionCaused = true;
        }
        if (!VersionComparator.isLessThanOrEqual(version, adapterVersion)) {
            msg = "Adapter version in metadata.txt/config.adk file is less than the version in " + this.metadataFile.getName();
            info = new MarkerInfo(msg, 2, this.metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            this.exceptionCaused = true;
        }
    }

    private boolean isConsistentId(List<String> componentValues, String adapterVendor, String adapterId) {
        if (componentValues == null) {
            return false;
        }
        if (componentValues.size() == 2) {
            return adapterVendor.equals(componentValues.get(0)) && adapterId.equals(componentValues.get(1));
        }
        if (componentValues.size() == 1) {
            return adapterId.equals(componentValues.get(0));
        }
        return true;
    }

    private void checkForNull(Object object, int lineNumber, String errorMessage, List<MarkerInfo> infoList) throws CheckException {
        if (object == null || object instanceof String && object.equals("")) {
            MarkerInfo info = new MarkerInfo(errorMessage, lineNumber, this.metadataFile.getAbsolutePath(), 2);
            infoList.add(info);
            throw new CheckException("metadata xml is not well formed");
        }
    }

    protected class ErrorHandler
    extends DefaultHandler {
        private final List<MarkerInfo> infoList;

        public ErrorHandler(List<MarkerInfo> infoList) {
            this.infoList = infoList;
        }

        @Override
        public void error(SAXParseException parseException) throws SAXException {
            this.printException(parseException);
        }

        @Override
        public void fatalError(SAXParseException parseException) {
            this.printException(parseException);
        }

        private void printException(SAXParseException exception) {
            ComponentMetadataValidator.this.exceptionCaused = true;
            MarkerInfo info = new MarkerInfo(exception.getMessage(), exception.getLineNumber(), ComponentMetadataValidator.this.metadataFile.getAbsolutePath(), 2);
            this.infoList.add(info);
        }
    }
}

