/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.checks.AdapterProjectChecks;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.AdapterMetadataBuildUtil;
import com.sap.cloud.adk.util.MarkerInfo;
import com.sap.it.asdk.md.generator.analysis.CamelComponentAnalyzer;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.camel.CamelEndpointMetadata;
import com.sap.it.asdk.md.generator.model.camel.ComponentType;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ComponentStructureValidator {
    private static final Logger LOG = LoggerFactory.getLogger(AdapterProjectChecks.class);
    public static final String COMPONENT_FOLDER = "component";
    public static final String TARGET_FOLDER = "target";
    private static final String CPI_SCHEDULER_REFERENCE_COMPONENT_ID = "cname::sap:Scheduler";
    private static final String REFERENCED_COMPONENTS_XPATH = "//ReferencedComponents/ReferencedComponent";
    private static final String REFERENCED_COMPONENT_ID_NODE_NAME = "ReferencedComponentId";
    private static final String ATTRIBUTE_METADATA_CONFIGURATION_NODE_NAME = "AttributeMetadataConfiguration";
    private static final String ATTRIBUTE_BEHAVIOUR_NODE_NAME = "AttributeBehavior";
    private static final String ATTRIBUTE_BEHAVIOUR_NODE_VALUE = "Scheduler_ScheduleOnDay,Scheduler_ScheduleToRecur";
    private static final String POLL_CONSUMER_SUPER_CLASS_NAME = "org.apache.camel.support.ScheduledPollConsumer";
    private boolean newComponentProject;

    public ComponentStructureValidator(boolean newComponentProject) {
        this.newComponentProject = newComponentProject;
    }

    public void validatePollingConsumerRequirements(File sourceProject, File metadataFile, List<MarkerInfo> markerList) throws IOException, CheckException, ParserConfigurationException, SAXException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        Document document = AdapterMetadataBuildUtil.getDocumentFromFile(metadataFile);
        try {
            NodeList nodeList = (NodeList)xPath.compile(REFERENCED_COMPONENTS_XPATH).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node referencedComponent = nodeList.item(i);
                String refCompId = this.getReferencedComponentId(referencedComponent);
                if (refCompId == null || !refCompId.contains(CPI_SCHEDULER_REFERENCE_COMPONENT_ID)) continue;
                if (!this.isOwnedBySender(referencedComponent.getParentNode())) {
                    String errorMessage = "Receiver variant cannot contain Scheduler referenced component";
                    MarkerInfo info = new MarkerInfo(errorMessage, 1, "", 2);
                    markerList.add(info);
                    LOG.error(errorMessage);
                    throw new CheckException(errorMessage);
                }
                this.validateReferenceComponentAttributeBehavior(referencedComponent, markerList);
                this.validatePollingConsumerContract(sourceProject, markerList);
            }
        }
        catch (XPathExpressionException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void validateReferenceComponentAttributeBehavior(Node referencedComponent, List<MarkerInfo> markerList) throws CheckException {
        if (referencedComponent.hasChildNodes() && referencedComponent.getChildNodes().getLength() > 1) {
            NodeList childNodeList = referencedComponent.getChildNodes();
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                Node childNode = childNodeList.item(i);
                if (childNode == null || !ATTRIBUTE_METADATA_CONFIGURATION_NODE_NAME.equals(childNode.getNodeName())) continue;
                NodeList mcChildNodeList = childNode.getChildNodes();
                for (int j = 0; j < mcChildNodeList.getLength(); ++j) {
                    Node mcChildNode = mcChildNodeList.item(j);
                    if (mcChildNode == null || !ATTRIBUTE_BEHAVIOUR_NODE_NAME.equals(mcChildNode.getNodeName()) || !ATTRIBUTE_BEHAVIOUR_NODE_VALUE.equals(mcChildNode.getFirstChild().getNodeValue())) continue;
                    markerList.add(new MarkerInfo("Scheduler component AttributeBehavior are correct", 1, "", 0));
                    return;
                }
                break;
            }
        } else {
            String errorMessage = "Scheduler ReferencedComponent does not contain AttributeBehavior attributes";
            MarkerInfo info = new MarkerInfo(errorMessage, 1, "", 2);
            markerList.add(info);
            LOG.error(errorMessage);
            throw new CheckException(errorMessage);
        }
        String errorMessage = "AttributeBehavior must be equal <Scheduler_ScheduleOnDay,Scheduler_ScheduleToRecur>";
        MarkerInfo info = new MarkerInfo(errorMessage, 1, "", 2);
        markerList.add(info);
        LOG.error(errorMessage);
        throw new CheckException(errorMessage);
    }

    private String getReferencedComponentId(Node referencedComponent) {
        String refCompId = null;
        if (referencedComponent.hasChildNodes() && referencedComponent.getChildNodes().getLength() > 1) {
            NodeList childNodeList = referencedComponent.getChildNodes();
            for (int i = 0; i < childNodeList.getLength(); ++i) {
                Node childNode = childNodeList.item(i);
                if (childNode == null || !REFERENCED_COMPONENT_ID_NODE_NAME.equals(childNode.getNodeName())) continue;
                refCompId = childNode.getFirstChild().getNodeValue();
                break;
            }
        } else {
            refCompId = referencedComponent.getFirstChild().getNodeValue();
        }
        return refCompId;
    }

    public void validatePollingConsumerContract(File sourceProject, List<MarkerInfo> markerList) throws IOException, CheckException {
        try {
            MarkerInfo info;
            boolean hasAppropriateSuperClass;
            block20: {
                hasAppropriateSuperClass = false;
                File componentFile = this.getComponentFile(sourceProject, markerList, this.newComponentProject);
                if (componentFile != null) {
                    CamelComponentAnalyzer cci = new CamelComponentAnalyzer();
                    try (FileInputStream fileStream = new FileInputStream(componentFile);){
                        Collection<CamelEndpointMetadata> cemdColl = cci.analyzeComponents(fileStream);
                        block13: for (CamelEndpointMetadata endpointMetadata : cemdColl) {
                            if (!this.isConsumerComponentType(endpointMetadata)) continue;
                            List<String> consumerClassesNames = endpointMetadata.getComponentInformation().getConsumerClasses();
                            for (String consumerClass : consumerClassesNames) {
                                ClassReference superClass = cci.getContext().getClassInfo(consumerClass).getSuperClass();
                                if (superClass == null || !superClass.isResolved() || !POLL_CONSUMER_SUPER_CLASS_NAME.equals(superClass.getResolved().getName())) continue;
                                hasAppropriateSuperClass = true;
                                continue block13;
                            }
                        }
                        markerList.add(new MarkerInfo("Timer&Lock validations successfully finished", -1, null, 0));
                        break block20;
                    }
                    catch (IOException ioe) {
                        markerList.add(new MarkerInfo("Timer&Lock validations failed due to unsuccessful component analysis", -1, null, 2));
                        throw ioe;
                    }
                }
                markerList.add(new MarkerInfo("Timer&Lock validations skipped due to absence of component JAR", -1, null, 0));
            }
            if (!hasAppropriateSuperClass) {
                String errorMessage = "Consumer class must extend ScheduledPollConsumer";
                info = new MarkerInfo(errorMessage, 1, "", 2);
                markerList.add(info);
                LOG.error(errorMessage);
                throw new CheckException(errorMessage);
            }
            String infoMessage = "Consumer class has correct contract (extends ScheduledPollConsumer)";
            info = new MarkerInfo(infoMessage, 1, "", 0);
            markerList.add(info);
        }
        catch (IOException e) {
            markerList.add(new MarkerInfo("Timer&Lock validations failed", -1, null, 2));
            throw e;
        }
    }

    private boolean isConsumerComponentType(CamelEndpointMetadata endpointMetadata) {
        ComponentType type = endpointMetadata.getComponentInformation().getType();
        return ComponentType.ConsumerProducer == type || ComponentType.ConsumerOnly == type;
    }

    private String getVariantId(Node variantNode) {
        return variantNode.getAttributes().getNamedItem("VariantId").getNodeValue();
    }

    private boolean isOwnedBySender(Node refComponentsNode) {
        Node variantNode = refComponentsNode.getParentNode();
        String variantId = this.getVariantId(variantNode);
        return AdapterMetadataBuildUtil.isSender(variantId);
    }

    private File getComponentFile(File projectBaseFolder, List<MarkerInfo> markerList, boolean newComponentProject) {
        Path componentFolderPath = Paths.get(projectBaseFolder.getAbsolutePath(), this.getComponentFolderPath(newComponentProject));
        markerList.add(new MarkerInfo("Lookup component JAR in : " + componentFolderPath.toAbsolutePath(), -1, null, 0));
        File compFolder = componentFolderPath.toFile();
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.jar");
        File[] fileList = compFolder.listFiles((FileFilter)fileFilter);
        if (fileList != null && fileList.length > 0) {
            File file = fileList[0];
            markerList.add(new MarkerInfo("Component JAR found : " + file.getAbsolutePath(), -1, null, 0));
            return file;
        }
        markerList.add(new MarkerInfo("Component JAR not found in: " + componentFolderPath.toAbsolutePath(), -1, null, 1));
        return null;
    }

    private String getComponentFolderPath(boolean newComponentProject) {
        return newComponentProject ? TARGET_FOLDER : COMPONENT_FOLDER;
    }
}

