/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.util.List;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ErrorHandler
extends DefaultHandler {
    boolean exceptionCaused;
    private File metadataFile;
    private List<MarkerInfo> infoList = null;

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile;
    }

    public boolean isExceptionCaused() {
        return this.exceptionCaused;
    }

    public void setExceptionCaused(boolean exceptionCaused) {
        this.exceptionCaused = exceptionCaused;
    }

    public ErrorHandler(List<MarkerInfo> infoList) {
        this.infoList = infoList;
    }

    @Override
    public void error(SAXParseException parseException) throws SAXException {
        this.printException(parseException);
    }

    @Override
    public void fatalError(SAXParseException parseException) throws SAXException {
        this.printException(parseException);
    }

    private void printException(SAXParseException exception) throws SAXException {
        if (!exception.getMessage().contains("$.cmd.attribute(")) {
            MarkerInfo info = new MarkerInfo(exception.getMessage(), exception.getLineNumber(), this.metadataFile.getAbsolutePath(), 2);
            this.infoList.add(info);
        }
        if (!this.infoList.isEmpty()) {
            this.exceptionCaused = true;
        }
    }
}

