/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.checks.ComponentMetadataAttributes;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.MarkerInfo;
import com.sap.cloud.adk.util.parser.CommandParser;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PatternValidator {
    public static final String EDIT_CONDITION_ATTRIBUTE = "createCondition";
    private static String cmdAttributeRegex = "\\$.cmd.attribute[^\\)]*\\)";
    private static Pattern pattern = Pattern.compile(cmdAttributeRegex);
    private static int lineNumber;
    private static File metadataFile;

    public static Set<String> checkAttributesWithWrongPatterns(NamedNodeMap attributeNodeMap, List<MarkerInfo> infoList, int lineNumber, String tagLocalName, File metadataFile, NodeList cmdAttributeReferenceNodes) throws CheckException {
        HashSet<String> attributesContainingWrongPattern = new HashSet<String>();
        PatternValidator.lineNumber = lineNumber;
        PatternValidator.metadataFile = metadataFile;
        for (int index = 0; index < attributeNodeMap.getLength(); ++index) {
            Node attributeNode = attributeNodeMap.item(index);
            if (PatternValidator.checkEditConditionPattern(attributeNode, cmdAttributeReferenceNodes, infoList)) continue;
            attributesContainingWrongPattern.add(attributeNode.getNodeName());
        }
        if (!attributesContainingWrongPattern.isEmpty()) {
            String msg = "Invalid " + ((Object)attributesContainingWrongPattern).toString() + " property value; Use $.cmd.attribute(test) format to define the property value.";
            MarkerInfo markerInfo = new MarkerInfo(msg, lineNumber, metadataFile.getAbsolutePath(), 2);
            infoList.add(markerInfo);
            throw new CheckException("Build failed as the validation of Blueprint Metadata failed");
        }
        return attributesContainingWrongPattern;
    }

    private static boolean checkEditConditionPattern(Node attributeNode, NodeList cmdAttributeReferenceNodes, List<MarkerInfo> infoList) {
        String attributeValue = attributeNode.getNodeValue();
        String attributeNodeName = attributeNode.getNodeName();
        if (EDIT_CONDITION_ATTRIBUTE.equals(attributeNodeName.trim())) {
            CommandParser commandParser = new CommandParser();
            try {
                commandParser.parse(attributeValue.trim());
                PatternValidator.checkEditConditionVariable(attributeNode, cmdAttributeReferenceNodes, infoList);
            }
            catch (Exception e) {
                return false;
            }
        } else if (attributeValue.trim().startsWith("$")) {
            if (PatternValidator.checkPatternForCMDAttributeReference(attributeNode.getNodeValue())) {
                PatternValidator.checkEditConditionVariable(attributeNode, cmdAttributeReferenceNodes, infoList);
            } else {
                return false;
            }
        }
        return true;
    }

    private static void checkEditConditionVariable(Node attributeNode, NodeList attributeReferenceNodes, List<MarkerInfo> infoList) {
        String attributeValue = attributeNode.getNodeValue();
        String attributeNodeName = attributeNode.getNodeName();
        if (EDIT_CONDITION_ATTRIBUTE.equals(attributeNodeName.trim()) || attributeValue.trim().startsWith("$")) {
            PatternValidator.checkReferencedAttributesExists(attributeReferenceNodes, attributeValue.trim(), infoList);
        }
    }

    private static List<String> getAllVariablesInCondition(String condition) {
        Matcher matcher = pattern.matcher(condition);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            String token = matcher.group();
            variables.add(PatternValidator.extractVariableNameFromCMD(token));
        }
        return variables;
    }

    private static String extractVariableNameFromCMD(String cmd) {
        if (cmd != null) {
            return cmd.split("\\(")[1].split("\\)")[0];
        }
        return null;
    }

    private static void checkReferencedAttributesExists(NodeList attributeReferenceNodes, String condition, List<MarkerInfo> infoList) {
        List<String> variables = PatternValidator.getAllVariablesInCondition(condition);
        List<String> cmdAttributes = PatternValidator.getAllCMDAttributes(attributeReferenceNodes);
        String msgVariables = "";
        for (String referencedVariable : variables) {
            if (cmdAttributes.contains(referencedVariable)) continue;
            msgVariables = msgVariables + referencedVariable + " ,";
        }
        if (!msgVariables.isEmpty()) {
            msgVariables = msgVariables.substring(0, msgVariables.length() - 1);
            String msg = msgVariables + " does not exist in the metadata. Remove " + msgVariables + ".";
            MarkerInfo markerInfo = new MarkerInfo(msg, lineNumber, metadataFile.getAbsolutePath(), 2);
            infoList.add(markerInfo);
        }
    }

    private static List<String> getAllCMDAttributes(NodeList attributeReferenceNodes) {
        ComponentMetadataAttributes cmdAttributes = new ComponentMetadataAttributes(attributeReferenceNodes);
        return cmdAttributes.getComponentMetadataAttributes();
    }

    private static boolean checkPatternForCMDAttributeReference(String nodeValue) {
        return nodeValue.matches("\\$.cmd.attribute\\(\\w+\\)");
    }
}

