/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.util.AdapterMetadataBuildUtil;
import java.util.ArrayList;
import java.util.List;

public class VersionComparator {
    public static final String VERSION = "version::";
    public static final String DEFAULT_VERSION = "1.0.0";

    public static String formatVersion(String version) {
        String[] versionSubparts = version.split("\\.");
        if (versionSubparts.length != 3) {
            while (version.split("\\.").length != 3) {
                version = version + ".0";
            }
        }
        return version;
    }

    public static boolean isLessThanOrEqual(String version1, String version) {
        String firstVersion = VersionComparator.formatVersion(version1);
        String secondVersion = VersionComparator.formatVersion(version);
        return VersionComparator.CompareVersion_LessOrEqual(firstVersion, secondVersion);
    }

    private static boolean CompareVersion_LessOrEqual(String version1, String version2) {
        int firstPartOfVer2;
        int firstPartOfVer1 = VersionComparator.getFirstPartOfVersionAsInteger(version1);
        if (firstPartOfVer1 > (firstPartOfVer2 = VersionComparator.getFirstPartOfVersionAsInteger(version2))) {
            return false;
        }
        if (firstPartOfVer1 < firstPartOfVer2) {
            return true;
        }
        boolean isVersionPartsPresent = false;
        if (version1.contains(".")) {
            version1 = VersionComparator.removeFirstPartOfVersion(version1);
            isVersionPartsPresent = true;
        }
        if (version2.contains(".")) {
            version2 = VersionComparator.removeFirstPartOfVersion(version2);
            isVersionPartsPresent = true;
        }
        if (isVersionPartsPresent) {
            return VersionComparator.CompareVersion_LessOrEqual(version1, version2);
        }
        return true;
    }

    private static String removeFirstPartOfVersion(String version1) {
        return version1.substring(version1.indexOf(46) + 1);
    }

    private static int getFirstPartOfVersionAsInteger(String version1) {
        return Integer.parseInt(VersionComparator.getFirstPartOfVersionAsString(version1));
    }

    private static String getFirstPartOfVersionAsString(String version1) {
        if (version1.contains(".")) {
            return version1.substring(0, version1.indexOf(46));
        }
        return version1;
    }

    public static String getVersionFromComponent(String componentId) {
        String[] componentParts = componentId.split("/");
        if (componentParts[componentParts.length - 1].contains(VERSION)) {
            return VersionComparator.formatVersion(componentParts[componentParts.length - 1].split(VERSION)[1]);
        }
        return DEFAULT_VERSION;
    }

    public static String removeMicroVersion(String version) {
        String[] versionSubparts = version.split("\\.");
        if (versionSubparts.length == 3) {
            version = versionSubparts[0] + "." + versionSubparts[1];
        }
        return version;
    }

    public static int getMicroVersion(String version) {
        String[] versionSubparts = version.split("\\.");
        if (versionSubparts.length == 3) {
            return Integer.parseInt(versionSubparts[2]);
        }
        return 0;
    }

    public static List<String> convertMicroToMinorVersionFromListOfComponentId(List<String> variantIds) {
        ArrayList<String> minorVersionVariantIds = new ArrayList<String>();
        for (String variantId : variantIds) {
            String olderVersion = VersionComparator.getVersionFromComponent(variantId);
            variantId = AdapterMetadataBuildUtil.getVariantWithVersion(variantId);
            variantId = variantId.replace(olderVersion, VersionComparator.removeMicroVersion(olderVersion));
            minorVersionVariantIds.add(variantId);
        }
        return minorVersionVariantIds;
    }
}

