/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.checks;

import com.sap.cloud.adk.checks.ErrorHandler;
import com.sap.cloud.adk.checks.ResourceResolver;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class XSDValidation {
    private static final String EXTENDED_BLUEPRINT = "/resources/ExtendedBlueprint.xsd";

    private XSDValidation() {
    }

    public static void checkBPMetadataAgainstSchema(File cmdFile, List<MarkerInfo> infoList) throws SAXException, IOException, CheckException {
        SchemaFactory validationFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        validationFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        validationFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        validationFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try (InputStream meatadataFile = XSDValidation.class.getResourceAsStream("/resources/ComponentMetadata.xsd");
             InputStream blueprintFile = XSDValidation.class.getResourceAsStream(EXTENDED_BLUEPRINT);){
            Source[] schemaSources = new StreamSource[]{new StreamSource(meatadataFile), new StreamSource(blueprintFile)};
            ResourceResolver resolver = new ResourceResolver();
            validationFactory.setResourceResolver(resolver);
            Schema schemaFile = validationFactory.newSchema(schemaSources);
            Validator xmlValidator = schemaFile.newValidator();
            ErrorHandler errHandler = new ErrorHandler(infoList);
            errHandler.setMetadataFile(cmdFile);
            xmlValidator.setErrorHandler(errHandler);
            xmlValidator.validate(new StreamSource(cmdFile));
            if (errHandler.isExceptionCaused()) {
                throw new CheckException("Build failed as the validation of Blueprint Metadata failed");
            }
        }
    }
}

