/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.generate.metadata;

import com.sap.cloud.adk.generate.exception.MetadataGenerateException;
import com.sap.cloud.adk.generate.metadata.MetadataGenerator;
import com.sap.cloud.adk.pluginutil.MarkerInfoHelper;
import com.sap.cloud.adk.util.MarkerInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-cmd", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ComponentMetadataGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", property="adapterProjectDirectory", required=true)
    private File adapterProjectDirectory;
    @Parameter(defaultValue="true", property="overWriteMetadata", required=true)
    private boolean overWriteMetadata;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Generate component metadata");
        if (this.adapterProjectDirectory.exists()) {
            try {
                this.performGenerateCmd(log);
            }
            catch (Exception e) {
                log.error((CharSequence)("Component metadata generate failed due to: " + e.getMessage()), (Throwable)e);
                throw new MojoExecutionException("Component metadata generate failed");
            }
        } else {
            log.error((CharSequence)"Could not find the project directory");
            throw new MojoExecutionException("Component metadata generate failed: Could ot find the project directory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performGenerateCmd(Log log) throws MetadataGenerateException, IOException {
        ArrayList<MarkerInfo> markerList = new ArrayList<MarkerInfo>();
        try {
            MetadataGenerator mdGenerator = new MetadataGenerator(markerList);
            mdGenerator.generateMetadata(this.adapterProjectDirectory, MetadataGenerator.MetadataType.CMD, this.overWriteMetadata);
        }
        finally {
            MarkerInfoHelper.writeToLog(log, markerList);
        }
    }

    public void setProjectDirectory(File adapterProjectDirectory) {
        this.adapterProjectDirectory = adapterProjectDirectory;
    }

    public void setOverWriteMetadata(boolean overWriteMetadata) {
        this.overWriteMetadata = overWriteMetadata;
    }
}

