/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.generate.metadata;

import com.sap.cloud.adk.generate.exception.MetadataGenerateException;
import com.sap.cloud.adk.generate.metadata.MetadataProperties;
import com.sap.cloud.adk.pluginutil.AdapterProjectUtil;
import com.sap.cloud.adk.util.MarkerInfo;
import com.sap.it.asdk.cmd.parser.BlueprintMetadataGenerator;
import com.sap.it.asdk.cmd.parser.ComponentMetaDataCompiler;
import com.sap.it.asdk.cmd.parser.ComponentMetaDataParser;
import com.sap.it.asdk.cmd.parser.generated.ComponentMetadata;
import com.sap.it.asdk.md.generator.analysis.CamelComponentAnalyzer;
import com.sap.it.asdk.md.generator.model.camel.CamelEndpointMetadata;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;

public class MetadataGenerator {
    private List<MarkerInfo> markerList;
    private MetadataProperties properties;

    public MetadataGenerator(List<MarkerInfo> markerList) {
        this.markerList = markerList;
    }

    public void generateMetadata(File projectBaseFolder, MetadataType metadataType, boolean overWriteMetadata) throws MetadataGenerateException, IOException {
        this.properties = AdapterProjectUtil.populateMetadataProperties(projectBaseFolder);
        AdapterProjectUtil.createCMDFolder(projectBaseFolder, this.properties.isReuseProject());
        Path cmdFilePath = Paths.get(projectBaseFolder.getAbsolutePath(), AdapterProjectUtil.getCMDFolderPath(this.properties.isReuseProject()), metadataType.getFileName());
        this.markerList.add(new MarkerInfo("Path to generated " + metadataType.name() + " metadata: " + cmdFilePath.toAbsolutePath(), -1, null, 0));
        if (Files.notExists(cmdFilePath, new LinkOption[0]) || overWriteMetadata) {
            try {
                File componentFile = this.getComponentFile(projectBaseFolder);
                if (componentFile != null) {
                    this.generateMetadataFromComponent(componentFile, projectBaseFolder, metadataType);
                }
                this.markerList.add(new MarkerInfo("Component JAR is absent", -1, null, 2));
            }
            catch (IOException e) {
                this.markerList.add(new MarkerInfo("Metadata generation failed", -1, null, 2));
                throw e;
            }
        } else {
            this.markerList.add(new MarkerInfo("Metadata " + metadataType.name() + " already exists", -1, null, 1));
        }
    }

    private void generateMetadataFromComponent(File componentFile, File projectBaseFolder, MetadataType metadataType) throws MetadataGenerateException, IOException {
        if (this.validateMetadataProperties()) {
            Path metadataFolderPath = Paths.get(projectBaseFolder.getAbsolutePath(), AdapterProjectUtil.getCMDFolderPath(this.properties.isReuseProject()));
            if (metadataType == MetadataType.CMD) {
                this.generateCMD(componentFile, metadataFolderPath);
            } else if (metadataType == MetadataType.BMD) {
                this.generateBMD(componentFile, metadataFolderPath);
            }
        } else {
            this.markerList.add(new MarkerInfo("Incomplete metadata", -1, null, 2));
            throw new MetadataGenerateException("Incomplete metadata");
        }
    }

    private void generateCMD(File file, Path metadataFolderPath) throws IOException {
        ComponentMetaDataCompiler cmdcc = ComponentMetaDataCompiler.create();
        CamelComponentAnalyzer cci = new CamelComponentAnalyzer();
        try (FileInputStream fileStream = new FileInputStream(file);){
            Collection<CamelEndpointMetadata> cemdColl = cci.analyzeComponents(fileStream);
            ComponentMetadata compilation = cmdcc.compile(this.properties.getAdapterID(), this.properties.getAdapterName(), this.properties.getAdapterVersion(), this.properties.getAdapteVendor(), cemdColl);
            Path metadataFilePath = metadataFolderPath.resolve("metadata.xml");
            ComponentMetaDataParser.exportModel((Object)compilation, metadataFilePath.toFile());
            this.markerList.add(new MarkerInfo("Component metadata generated successfully", -1, null, 0));
        }
        catch (IOException ioe) {
            this.markerList.add(new MarkerInfo("Component metadata generation failed", -1, null, 2));
            throw ioe;
        }
    }

    private void generateBMD(File file, Path metadataFolderPath) throws IOException {
        BlueprintMetadataGenerator bpGen = new BlueprintMetadataGenerator();
        CamelComponentAnalyzer cci = new CamelComponentAnalyzer();
        try (FileInputStream fileStream = new FileInputStream(file);){
            Collection<CamelEndpointMetadata> cemdColl = cci.analyzeComponents(fileStream);
            ComponentMetadata compilation = bpGen.generateBlueprint(this.properties.getAdapterID(), this.properties.getAdapterName(), this.properties.getAdapterVersion(), this.properties.getAdapteVendor(), cemdColl);
            Path metadataFilePath = metadataFolderPath.resolve("bpMetadata.xml");
            ComponentMetaDataParser.exportModel((Object)compilation, metadataFilePath.toFile());
            this.markerList.add(new MarkerInfo("Blueprint metadata generated successfully", -1, null, 0));
        }
        catch (IOException ioe) {
            this.markerList.add(new MarkerInfo("Blueprint metadata generation failed", -1, null, 2));
            throw ioe;
        }
    }

    private File getComponentFile(File projectBaseFolder) {
        Path componentFolderPath = Paths.get(projectBaseFolder.getAbsolutePath(), AdapterProjectUtil.getComponentFolderPath(this.properties.isReuseProject()));
        this.markerList.add(new MarkerInfo("Lookup component JAR in : " + componentFolderPath.toAbsolutePath(), -1, null, 0));
        File compFolder = componentFolderPath.toFile();
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.jar");
        File[] fileList = compFolder.listFiles((FileFilter)fileFilter);
        if (fileList != null && fileList.length > 0) {
            File file = fileList[0];
            this.markerList.add(new MarkerInfo("Component JAR found : " + file.getAbsolutePath(), -1, null, 0));
            return file;
        }
        this.markerList.add(new MarkerInfo("Component JAR not found in: " + componentFolderPath.toAbsolutePath(), -1, null, 1));
        return null;
    }

    private boolean validateMetadataProperties() {
        if (this.properties == null) {
            this.markerList.add(new MarkerInfo("Undefined metadata", -1, null, 2));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.properties.getAdapterID())) {
            this.markerList.add(new MarkerInfo("Incorrect metadata: AdapterID is empty", -1, null, 2));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.properties.getAdapterName())) {
            this.markerList.add(new MarkerInfo("Incorrect metadata: AdapterName is empty", -1, null, 2));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.properties.getAdapterVersion())) {
            this.markerList.add(new MarkerInfo("Incorrect metadata: Version is empty", -1, null, 2));
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.properties.getAdapteVendor())) {
            this.markerList.add(new MarkerInfo("Incorrect metadata: AdapterVendor is empty", -1, null, 2));
            return false;
        }
        return true;
    }

    public static enum MetadataType {
        CMD("metadata.xml"),
        BMD("bpMetadata.xml");

        String fileName;

        private MetadataType(String metadataFileName) {
            this.fileName = metadataFileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

