/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.generate.metadata;

import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;

public class MetadataProperties {
    private static final String ADAPTER_NAME = "Adapter-Name";
    private static final String ADAPTER_VERSION = "Adapter-Version";
    private static final String ADAPTER_VENDOR = "Adapter-Vendor";
    private static final String ADAPTER_ID = "Adapter-ID";
    private static final String REUSE_COMPONENT = "Reuse-Component";
    private String adapterVendor;
    private String version;
    private String adapterName;
    private String adapterId;
    private boolean isReuseProject;

    public void readMetadataFile(Path metadataFilePath) throws IOException {
        if (Files.notExists(metadataFilePath, new LinkOption[0])) {
            throw new IOException("Metadata file does not exists");
        }
        Properties metadataProps = new Properties();
        try (FileChannel channel = FileChannel.open(metadataFilePath, StandardOpenOption.READ);){
            metadataProps.load(Channels.newInputStream(channel));
            this.version = metadataProps.getProperty(ADAPTER_VERSION);
            this.adapterName = metadataProps.getProperty(ADAPTER_NAME);
            this.adapterVendor = metadataProps.getProperty(ADAPTER_VENDOR);
            this.adapterId = metadataProps.getProperty(ADAPTER_ID);
            this.isReuseProject = Boolean.parseBoolean(metadataProps.getProperty(REUSE_COMPONENT, "true"));
        }
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getAdapteVendor() {
        return this.adapterVendor;
    }

    public String getAdapterVersion() {
        return this.version;
    }

    public String getAdapterID() {
        return this.adapterId;
    }

    public boolean isReuseProject() {
        return this.isReuseProject;
    }
}

