/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.pluginutil;

import com.sap.cloud.adk.generate.metadata.MetadataProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class AdapterProjectUtil {
    public static final String CONFIG_ADK = "config.adk";
    public static final String METADATA_XML = "metadata.xml";
    public static final String BPMETADATA_XML = "bpMetadata.xml";
    public static final String REUSE_PROJECT_METADATA_FOLDER = "metadata";
    public static final String METADATA_FOLDER = "src/main/resources/metadata";
    public static final String COMPONENT_FOLDER = "component";
    public static final String TARGET_FOLDER = "target";

    private AdapterProjectUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getCMDFolderPath(boolean isReuseProject) {
        return isReuseProject ? REUSE_PROJECT_METADATA_FOLDER : METADATA_FOLDER;
    }

    public static String getComponentFolderPath(boolean isReuseProject) {
        return isReuseProject ? COMPONENT_FOLDER : TARGET_FOLDER;
    }

    public static void createCMDFolder(File projectBaseDir, boolean isReuseProject) throws IOException {
        Path path = Paths.get(projectBaseDir.getAbsolutePath(), AdapterProjectUtil.getCMDFolderPath(isReuseProject));
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
    }

    public static MetadataProperties populateMetadataProperties(File projectBaseFolder) throws IOException {
        Path manifestPath = Paths.get(projectBaseFolder.getAbsolutePath(), CONFIG_ADK);
        MetadataProperties properties = new MetadataProperties();
        properties.readMetadataFile(manifestPath);
        return properties;
    }
}

