/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.util;

import com.sap.cloud.adk.checks.VersionComparator;
import com.sap.cloud.adk.exception.CheckException;
import com.sap.cloud.adk.util.BuildProviderUtil;
import com.sap.cloud.adk.util.FileUtil;
import com.sap.cloud.adk.util.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AdapterMetadataBuildUtil {
    private static final String PATH_SEPARATOR = "/";
    private static final Logger log = LoggerFactory.getLogger(AdapterMetadataBuildUtil.class);
    private static final String XPATH_EXPRESSION = "/ComponentMetadata/Variant";
    private static final String METADATA_FOLDER_LOCATION = File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources" + File.separatorChar + "metadata";
    private static final String REFERENCED_COMPONENTS_XPATH = "//ReferencedComponents/ReferencedComponent";
    private static final String COMPONENT_FOLDER_LOCATION = File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources" + File.separatorChar + "META-INF" + File.separatorChar + "services" + File.separatorChar + "org" + File.separatorChar + "apache" + File.separatorChar + "camel" + File.separatorChar + "component";

    private static String getMetadataDirectoryPath(File sourceProject) throws CheckException {
        Properties manifestProperties = BuildProviderUtil.getManifestProperties(sourceProject);
        String directoryPath = BuildProviderUtil.isNewComponentProject(manifestProperties) ? AdapterMetadataBuildUtil.getCMDDirectoryPathForProject(sourceProject) : AdapterMetadataBuildUtil.getCMDDirectoryPathForReuseComponentProject(sourceProject);
        if (directoryPath == null) {
            throw new CheckException("Invalid content. please ensure that the metadata folder exists");
        }
        return directoryPath;
    }

    public static List<String> getAllCMDFilesInProject(File sourceProject) throws CheckException {
        String directoryPath = AdapterMetadataBuildUtil.getMetadataDirectoryPath(sourceProject);
        File[] listOfFiles = new File(directoryPath).listFiles();
        if (listOfFiles == null) {
            throw new CheckException("Invalid content. Please check that the metadata folder contains the metadata.xml file.");
        }
        ArrayList<String> listOfFilePaths = new ArrayList<String>();
        for (File listOfFile : listOfFiles) {
            if (!listOfFile.isFile() || listOfFile.getName().toLowerCase().contains("bpmetadata")) continue;
            listOfFilePaths.add(listOfFile.getAbsolutePath());
        }
        return listOfFilePaths;
    }

    public static String getComponentFilePath(File sourceProject) {
        return sourceProject.getAbsolutePath() + COMPONENT_FOLDER_LOCATION;
    }

    public static List<String> getCMDAndBMDFilesInProject(File sourceProject) throws CheckException {
        String directoryPath = AdapterMetadataBuildUtil.getMetadataDirectoryPath(sourceProject);
        File[] listOfFiles = new File(directoryPath).listFiles();
        if (listOfFiles == null) {
            throw new CheckException("Invalid content. Please check that the metadata folder contains the metadata.xml file.");
        }
        ArrayList<String> listOfFilePaths = new ArrayList<String>();
        for (File listOfFile : listOfFiles) {
            if (!listOfFile.isFile()) continue;
            listOfFilePaths.add(listOfFile.getAbsolutePath());
        }
        return listOfFilePaths;
    }

    public static String getCMDDirectoryPathForProject(File sourceProject) {
        String basePath = sourceProject.getAbsolutePath();
        return AdapterMetadataBuildUtil.getMetadataFolderPathForProject(basePath);
    }

    @Deprecated
    public static String getCMDDirectoryPathForMaven(File sourceProject) {
        return AdapterMetadataBuildUtil.getCMDDirectoryPathForProject(sourceProject);
    }

    public static String getCMDDirectoryPathForReuseComponentProject(File sourceProject) {
        String basePath = sourceProject.getAbsolutePath();
        return AdapterMetadataBuildUtil.getMetadataFolderPathForReuseComponentProject(basePath);
    }

    @Deprecated
    public static String getCMDDirectoryPathForNonMaven(File sourceProject) {
        return AdapterMetadataBuildUtil.getCMDDirectoryPathForReuseComponentProject(sourceProject);
    }

    public static Document getDocumentFromFile(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
        XMLParser xmlParser = new XMLParser();
        return xmlParser.parseWithLineNumbers(metadataFile);
    }

    private static String getMetadataFolderPathForReuseComponentProject(String basePath) {
        String localBuildPath = AdapterMetadataBuildUtil.getLocalBuildPathForMetadataFolderReuseComponentProject(basePath);
        if (new File(localBuildPath).exists()) {
            return localBuildPath;
        }
        if (new File(AdapterMetadataBuildUtil.getClusterBuildPathForMetadataFolderReuseComponentProject(basePath)).exists()) {
            return AdapterMetadataBuildUtil.getClusterBuildPathForMetadataFolderReuseComponentProject(basePath);
        }
        return null;
    }

    private static String getMetadataFolderPathForProject(String basePath) {
        String localBuildPath = AdapterMetadataBuildUtil.getLocalBuildPathForMetadataFolder(basePath);
        if (new File(localBuildPath).exists()) {
            return localBuildPath;
        }
        if (new File(AdapterMetadataBuildUtil.getClusterBuildPathForMetadataFolder(basePath)).exists()) {
            return AdapterMetadataBuildUtil.getClusterBuildPathForMetadataFolder(basePath);
        }
        return null;
    }

    public static String getMetadataLocationFromPath(String path) {
        String[] cmdPathParts = path.split(Pattern.quote(File.separator));
        if (cmdPathParts.length > 2) {
            return cmdPathParts[cmdPathParts.length - 2] + PATH_SEPARATOR + cmdPathParts[cmdPathParts.length - 1];
        }
        return path;
    }

    public static Document bytesToXml(ByteArrayInputStream inputCMD) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try {
            String xmlStr = new String(FileUtil.getByteArray(inputCMD), StandardCharsets.UTF_8);
            return builder.parse(new InputSource(new StringReader(xmlStr)));
        }
        catch (Exception e) {
            log.debug("ERROR: CMD Does not have a variant Id.");
            return null;
        }
    }

    public static ByteArrayInputStream getMetadataInputStreamFromPath(String cmdPath) throws IOException {
        Path path = Paths.get(cmdPath, new String[0]);
        return new ByteArrayInputStream(Files.readAllBytes(path));
    }

    public static List<String> getVariantIds(Document doc) {
        ArrayList<String> variantIds = new ArrayList<String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(XPATH_EXPRESSION).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node variantNode = nodeList.item(i);
                String variantId = variantNode.getAttributes().getNamedItem("VariantId").getNodeValue();
                variantIds.add(variantId);
            }
        }
        catch (XPathExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return variantIds;
    }

    public static String getMetadataLocationForProvideCapability(String cmdPath) {
        return AdapterMetadataBuildUtil.getMetadataLocationFromPath(cmdPath);
    }

    public static String getLatestVariant(List<String> variantIds, boolean isSender) {
        ArrayList<String> filteredVariantsDirectionSpecific = new ArrayList<String>();
        for (String variant : variantIds) {
            if (isSender != variant.toLowerCase().contains("direction::sender")) continue;
            filteredVariantsDirectionSpecific.add(variant);
        }
        return AdapterMetadataBuildUtil.getLatestVariant(filteredVariantsDirectionSpecific);
    }

    public static boolean isSender(String variantId) {
        return variantId.toLowerCase().contains("direction::sender");
    }

    public static String getLatestVariant(List<String> variantIds) {
        String latestVariant = variantIds.get(0);
        for (String variant : variantIds) {
            if (!VersionComparator.isLessThanOrEqual(VersionComparator.getVersionFromComponent(latestVariant), VersionComparator.getVersionFromComponent(variant))) continue;
            latestVariant = variant;
        }
        return latestVariant;
    }

    private static String getClusterBuildPathForMetadataFolderReuseComponentProject(String basePath) {
        return AdapterMetadataBuildUtil.getMetadataFolderPathReuseComponentProject(new File(basePath).getParent());
    }

    private static String getLocalBuildPathForMetadataFolderReuseComponentProject(String basePath) {
        return AdapterMetadataBuildUtil.getMetadataFolderPathReuseComponentProject(basePath);
    }

    private static String getMetadataFolderPathReuseComponentProject(String basePath) {
        return basePath + File.separatorChar + "metadata";
    }

    private static String getClusterBuildPathForMetadataFolder(String basePath) {
        return AdapterMetadataBuildUtil.getMetadataFolderPath(new File(basePath).getParent());
    }

    private static String getLocalBuildPathForMetadataFolder(String basePath) {
        return AdapterMetadataBuildUtil.getMetadataFolderPath(basePath);
    }

    private static String getMetadataFolderPath(String basePath) {
        return basePath + METADATA_FOLDER_LOCATION;
    }

    public static String getVarinatIdWithoutVersion(String variantId) {
        if (variantId.contains("version::")) {
            return variantId.substring(0, variantId.indexOf("version::") - 1);
        }
        return variantId;
    }

    public static String getVariantWithVersion(String variant) {
        if (!variant.contains("version::")) {
            String version = "version::" + VersionComparator.getVersionFromComponent(variant);
            return variant + PATH_SEPARATOR + version;
        }
        return variant;
    }

    public static String getVariantVersion(String variantId) {
        return VersionComparator.getVersionFromComponent(AdapterMetadataBuildUtil.getVariantWithVersion(variantId));
    }

    public static List<String> getVariantsInCMDsInProject(String sourcePath) throws CheckException, ParserConfigurationException, IOException {
        ArrayList<String> variantIds = new ArrayList<String>();
        List<String> allCMDPaths = AdapterMetadataBuildUtil.getAllCMDFilesInProject(new File(sourcePath));
        for (String cmdPath : allCMDPaths) {
            variantIds.addAll(AdapterMetadataBuildUtil.getVariantIds(AdapterMetadataBuildUtil.bytesToXml(AdapterMetadataBuildUtil.getMetadataInputStreamFromPath(cmdPath))));
        }
        return variantIds;
    }

    public static List<String> getReferencedComponents(File metadataFile) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> referencedComponents = new ArrayList<String>();
        XPath xPath = XPathFactory.newInstance().newXPath();
        Document document = AdapterMetadataBuildUtil.getDocumentFromFile(metadataFile);
        try {
            NodeList nodeList = (NodeList)xPath.compile(REFERENCED_COMPONENTS_XPATH).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node referencedComponent = nodeList.item(i);
                String referenceComponentValue = referencedComponent.getTextContent();
                referencedComponents.add(referenceComponentValue);
            }
        }
        catch (XPathExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return referencedComponents;
    }
}

