/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.util;

import com.sap.cloud.adk.build.BuildProvider;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildProviderUtil {
    public static final String ADAPTER_NAME1 = "SAP-AdapterName";
    public static final String BUNDLE_NAME = "Bundle-Name";
    public static final String BUNDLE_VENDOR = "Bundle-Vendor";
    public static final String BUNDLE_VERSION = "Bundle-Version";
    public static final String BUNDLE_ID = "Bundle-SymbolicName";
    public static final String SAP_NODE_TYPE = "SAP-NodeType";
    public static final String SAP_BUNDLE_TYPE = "SAP-BundleType";
    public static final String INTEGRATION_ADAPTER = "IntegrationAdapter";
    private static final String MANIFEST_FILE_NAME = "MANIFEST.MF";
    private static final String BPMN = ".bpmn";
    private static final String IFLW = ".iflw";
    private static final String ADAPTER_NAME = "Adapter-Name";
    private static final String ADAPTER_ID = "Adapter-Id";
    private static final String ADAPTER_VENDOR = "Adapter-Vendor";
    private static final String ADAPTER_VERSION = "Adapter-Version";
    private static final String ADAPTER_REUSE_COMPONENT = "Reuse-Component";
    private static final Logger log = LoggerFactory.getLogger(BuildProviderUtil.class);

    private static boolean isFileToBeCreated(File file) {
        String name = file.getName();
        return !"src".equals(name) && !"main".equals(name) && !"resources".equals(name) && !"target".equals(name);
    }

    private static boolean isTargetFolder(File file) {
        return file.isDirectory() && "target".equals(file.getName());
    }

    private static void populateContentsOfTarget(File targetFolder, File targetLocation) throws IOException {
        File[] files = targetFolder.listFiles();
        if (files == null) {
            throw new IOException("Empty folder: " + targetFolder.getName());
        }
        for (File file : files) {
            if (file.getName().endsWith(".jar")) {
                String componentPath = targetLocation.getAbsolutePath() + File.separatorChar + "component" + File.separatorChar + file.getName();
                BuildProviderUtil.copyFile(file, new File(componentPath));
                continue;
            }
            if (!file.getName().equals("libs")) continue;
            File[] listFiles = file.listFiles();
            if (listFiles == null) {
                throw new IOException("Empty libs folder");
            }
            for (File libFile : listFiles) {
                String libPath = targetLocation.getAbsolutePath() + File.separatorChar + "libs" + File.separatorChar + libFile.getName();
                BuildProviderUtil.copyFile(libFile, new File(libPath));
            }
        }
    }

    public static void populateOtherContent(File source, File target) throws IOException {
        File[] files = source.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isFile() ? !(f.getName().endsWith(BuildProviderUtil.BPMN) || f.getName().endsWith(BuildProviderUtil.IFLW) || f.getName().equalsIgnoreCase("parameters.prop") || f.getName().equalsIgnoreCase("parameters.propdef") || f.getName().equals(".project") || f.getName().equalsIgnoreCase(BuildProviderUtil.MANIFEST_FILE_NAME)) : !f.getName().startsWith("testing") && !f.getName().startsWith(BuildProviderUtil.BPMN) && !f.getName().startsWith(BuildProviderUtil.IFLW) && !f.getName().equals("build");
            }
        });
        if (files != null) {
            for (File file : files) {
                String filePath = target.getAbsolutePath();
                if (BuildProviderUtil.isFileToBeCreated(file)) {
                    filePath = filePath + File.separatorChar + file.getName();
                } else if (BuildProviderUtil.isTargetFolder(file)) {
                    File componentFile = new File(filePath);
                    BuildProviderUtil.populateContentsOfTarget(file, componentFile);
                    continue;
                }
                File targetFile = new File(filePath);
                if (file.isDirectory()) {
                    BuildProviderUtil.populateOtherContent(file, targetFile);
                    continue;
                }
                BuildProviderUtil.copyFile(file, targetFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        boolean newFile;
        boolean mkdirs = targetFile.getParentFile().mkdirs();
        if (mkdirs) {
            log.debug("Directories created for: {}", (Object)targetFile.getParentFile());
        }
        if (newFile = targetFile.createNewFile()) {
            log.debug("Target file created {}", (Object)targetFile.getName());
        }
        AbstractInterruptibleChannel isChannel = null;
        AbstractInterruptibleChannel osChannel = null;
        try (FileInputStream fileInputStream = new FileInputStream(sourceFile);
             FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
            isChannel = fileInputStream.getChannel();
            osChannel = fileOutputStream.getChannel();
            ((FileChannel)osChannel).transferFrom((ReadableByteChannel)((Object)isChannel), 0L, ((FileChannel)isChannel).size());
        }
        finally {
            if (isChannel != null) {
                try {
                    isChannel.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (osChannel != null) {
                try {
                    osChannel.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void addFile(String precursor, File source, JarOutputStream target) throws IOException {
        if (source.isDirectory()) {
            File[] files;
            String name = BuildProviderUtil.getRelativePath(precursor, source.getPath()).replace("\\", "/");
            if (!name.isEmpty()) {
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                JarEntry entry = new JarEntry(name);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                target.closeEntry();
            }
            if ((files = source.listFiles()) == null) {
                throw new IOException("Empty folder: " + source.getName());
            }
            for (File nestedFile : files) {
                BuildProviderUtil.addFile(precursor, nestedFile, target);
            }
            return;
        }
        JarEntry entry = new JarEntry(BuildProviderUtil.getRelativePath(precursor, source.getPath()).replace("\\", "/"));
        entry.setTime(source.lastModified());
        target.putNextEntry(entry);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer)) != -1) {
                target.write(buffer, 0, count);
            }
            target.closeEntry();
        }
    }

    private static String getRelativePath(String precursor, String actual) {
        return actual.substring(precursor.length() + 1);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            String[] list = file.list();
            if (list != null) {
                if (list.length == 0) {
                    Files.delete(file.toPath());
                } else {
                    BuildProviderUtil.deleteRecursively(file, list);
                }
            }
        } else {
            Files.delete(file.toPath());
        }
    }

    private static void deleteRecursively(File file, String[] list) throws IOException {
        for (String temp : list) {
            File fileDelete = new File(file, temp);
            BuildProviderUtil.delete(fileDelete);
        }
        list = file.list();
        if (list != null && list.length == 0) {
            Files.delete(file.toPath());
        }
    }

    public static Properties getManifestProperties(String srcManifestPath) {
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(srcManifestPath);){
            properties.load(stream);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return properties;
    }

    public static boolean isNewComponentProject(Properties manifestProperties) {
        for (Map.Entry<Object, Object> propEntry : manifestProperties.entrySet()) {
            String key = (String)propEntry.getKey();
            String value = (String)propEntry.getValue();
            if (!ADAPTER_REUSE_COMPONENT.equals(key)) continue;
            return !"true".equalsIgnoreCase(value);
        }
        return BuildProviderUtil.isMavenEnabled(manifestProperties);
    }

    public static boolean isReuseComponentProject(Properties manifestProperties) {
        return !BuildProviderUtil.isNewComponentProject(manifestProperties);
    }

    @Deprecated
    public static boolean isMavenEnabled(Properties manifestProperties) {
        for (Map.Entry<Object, Object> propEntry : manifestProperties.entrySet()) {
            String key = (String)propEntry.getKey();
            String value = (String)propEntry.getValue();
            if (!"Enable-Maven".equals(key) || !"true".equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInternal(Properties manifestProperties) {
        for (Map.Entry<Object, Object> propEntry : manifestProperties.entrySet()) {
            String key = (String)propEntry.getKey();
            String value = (String)propEntry.getValue();
            if (!"isInternal".equals(key) || !"true".equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    public static Properties getManifestProperties(File sourceProject) {
        String srcManifest = BuildProvider.getConfigFilePath(sourceProject);
        return BuildProviderUtil.getManifestProperties(srcManifest);
    }

    public static void populateManifest(String srcManifest, File tempFile) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("Manifest-Version: 1.0\n");
        try (FileInputStream stream = new FileInputStream(srcManifest);){
            Properties prop = new Properties();
            prop.load(stream);
            BuildProviderUtil.getAdapterName(builder, prop);
            builder.append("SAP-NodeType: IFLMAP\n");
            builder.append("SAP-BundleType: IntegrationAdapter\n");
        }
        BuildProviderUtil.writeStringToFile(tempFile.getPath(), builder.toString());
    }

    private static void getAdapterName(StringBuilder builder, Properties prop) {
        for (Map.Entry<Object, Object> propEntry : prop.entrySet()) {
            String key = (String)propEntry.getKey();
            String value = (String)propEntry.getValue();
            if (ADAPTER_ID.equalsIgnoreCase(key)) {
                builder.append("Bundle-SymbolicName: ").append(value).append("\n");
            }
            if (ADAPTER_NAME.equalsIgnoreCase(key)) {
                builder.append("Bundle-Name: ").append(value).append("\n");
                builder.append("SAP-AdapterName: ").append(value).append("\n");
            }
            if (ADAPTER_VENDOR.equalsIgnoreCase(key)) {
                builder.append("Bundle-Vendor: ").append(value).append("\n");
            }
            if (!ADAPTER_VERSION.equalsIgnoreCase(key)) continue;
            builder.append("Bundle-Version: ").append(value).append("\n");
        }
    }

    private static void writeStringToFile(String fileName, String content) {
        if (fileName == null || content == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("File name or content is invalid");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(fileName);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);
             BufferedWriter f = new BufferedWriter(outputStreamWriter);){
            f.write(content);
        }
        catch (IOException e) {
            log.error("Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

