/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class MetadataProperties {
    private static final String ADAPTERNAME_PROPERTY = "Adapter-Name";
    private static final String ADAPTERVERSION = "Adapter-Version";
    private static final String ADAPTERVENDOR_PROPERTY = "Adapter-Vendor";
    private static final String ADAPTERID_PROPERTY = "Adapter-ID";
    private String adapterVendor;
    private String version;
    private String adapterName;
    private String adapterId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMetadataFile(String path) throws IOException {
        File metadataFile = new File(path);
        if (!metadataFile.exists()) {
            throw new IOException("Metadata file does not exist");
        }
        Properties metadataProps = new Properties();
        FileInputStream instream = null;
        instream = new FileInputStream(metadataFile);
        try {
            if (instream != null) {
                metadataProps.load(instream);
                this.version = metadataProps.getProperty(ADAPTERVERSION);
                this.adapterName = metadataProps.getProperty(ADAPTERNAME_PROPERTY);
                this.adapterVendor = metadataProps.getProperty(ADAPTERVENDOR_PROPERTY);
                this.adapterId = metadataProps.getProperty(ADAPTERID_PROPERTY);
            }
        }
        finally {
            if (instream != null) {
                ((InputStream)instream).close();
            }
        }
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getAdapteVendor() {
        return this.adapterVendor;
    }

    public String getAdapterVersion() {
        return this.version;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public String buildMetadataContent(String adapterId, String adapterName, String adapterVersion, String adapterVendor) {
        Properties prop = new Properties();
        prop.put(ADAPTERNAME_PROPERTY, adapterName);
        prop.put(ADAPTERID_PROPERTY, adapterId);
        prop.put(ADAPTERVENDOR_PROPERTY, adapterVendor);
        prop.put(ADAPTERVERSION, !adapterVersion.isEmpty() ? adapterVersion : "1.0.0");
        String propString = this.getPropertyAsString(prop);
        return propString;
    }

    private String getPropertyAsString(Properties prop) {
        StringWriter writer = new StringWriter();
        prop.list(new PrintWriter(writer));
        return writer.getBuffer().toString();
    }
}

