/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final Logger log = LoggerFactory.getLogger(XMLParser.class);

    public List<Integer> getLineNumber(Document document, String referenceNode) {
        ArrayList<Integer> lineNumberList = new ArrayList<Integer>();
        if (document != null) {
            try {
                NodeList nodeList = document.getElementsByTagName("ReferenceName");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node discoveredNode = nodeList.item(i);
                    String nodeValue = discoveredNode.getFirstChild().getNodeValue();
                    if (!nodeValue.equals(referenceNode)) continue;
                    lineNumberList.add(Integer.parseInt((String)discoveredNode.getUserData("lineNumber")));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return lineNumberList;
    }

    public List<Integer> getLineNumberOfRequiredProperties(Document document, String referenceNode) {
        ArrayList<Integer> lineNumberList = new ArrayList<Integer>();
        if (document != null) {
            try {
                NodeList nodeList = document.getElementsByTagName("Value");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node discoveredNode = nodeList.item(i);
                    String nodeValue = discoveredNode.getFirstChild().getNodeValue();
                    if (!nodeValue.equals(referenceNode)) continue;
                    lineNumberList.add(Integer.parseInt((String)discoveredNode.getUserData("lineNumber")));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return lineNumberList;
    }

    public Document parseWithLineNumbers(File cmdFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = this.getFactory();
        XMLHandler handler = new XMLHandler();
        Document doc = this.getDocument(handler);
        SAXParser parser = factory.newSAXParser();
        parser.parse(cmdFile, (DefaultHandler)handler);
        return doc;
    }

    public Document parseWithLineNumbers(InputStream bmdContent) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = this.getFactory();
        XMLHandler handler = new XMLHandler();
        Document doc = this.getDocument(handler);
        SAXParser parser = factory.newSAXParser();
        parser.parse(bmdContent, (DefaultHandler)handler);
        return doc;
    }

    private SAXParserFactory getFactory() throws SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }

    private Document getDocument(XMLHandler handler) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Stack<Element> elementStack = new Stack<Element>();
        StringBuilder textBuffer = new StringBuilder();
        handler.setDocument(doc);
        handler.setElementStack(elementStack);
        handler.setTextBuffer(textBuffer);
        return doc;
    }

    protected class XMLHandler
    extends DefaultHandler {
        private static final String LINE_NUMBER_KEY_NAME = "lineNumber";
        private Locator locator;
        private StringBuilder textBuffer;
        private Stack<Element> elementStack;
        private Document doc;

        protected XMLHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addTextIfNeeded();
            Element el = this.doc.createElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                el.setAttribute(attributes.getQName(i), attributes.getValue(i));
            }
            el.setUserData(LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
            this.elementStack.push(el);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.addTextIfNeeded();
            Element closedEl = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.doc.appendChild(closedEl);
            } else {
                Element parentEl = this.elementStack.peek();
                parentEl.appendChild(closedEl);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuffer.append(ch, start, length);
        }

        private void addTextIfNeeded() {
            if (this.textBuffer.length() > 0) {
                Element el = this.elementStack.peek();
                Text textNode = this.doc.createTextNode(this.textBuffer.toString());
                el.appendChild(textNode);
                this.textBuffer.delete(0, this.textBuffer.length());
            }
        }

        public void setTextBuffer(StringBuilder textBuffer) {
            this.textBuffer = textBuffer;
        }

        public void setElementStack(Stack<Element> elementStack) {
            this.elementStack = elementStack;
        }

        public void setDocument(Document document) {
            this.doc = document;
        }
    }
}

