/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.adk.util.parser;

import com.sap.cloud.adk.util.parser.AndNode;
import com.sap.cloud.adk.util.parser.ExpressionParsingException;
import com.sap.cloud.adk.util.parser.KeyValue;
import com.sap.cloud.adk.util.parser.Node;
import com.sap.cloud.adk.util.parser.OrNode;
import com.sap.cloud.adk.util.parser.ValueNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandParser {
    private static String regex = "\\$.cmd.attribute[^']*'[^']*'";
    private Pattern pattern = Pattern.compile(regex);
    private static String leftOverRegex = "[a-z.]+";
    private static char variableMarker = (char)35;
    private static Set<String> allowedOperators = new HashSet<String>(Arrays.asList("="));
    private Map<String, KeyValue> symbolTable = new HashMap<String, KeyValue>();

    public Node parse(String conditionString) {
        String sanitizedString = this.sanitizeInputString(conditionString);
        return this.buildExpressionTree(sanitizedString);
    }

    private Node buildExpressionTree(String sanitizedString) {
        ArrayList<String> operator = new ArrayList<String>();
        ArrayList<Node> operand = new ArrayList<Node>();
        StringTokenizer stringTokenizer = new StringTokenizer(sanitizedString, " +*()", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.trim().isEmpty()) continue;
            if (token.charAt(0) == variableMarker) {
                this.handleVariable(operand, token);
                continue;
            }
            if ("(".equals(token)) {
                operator.add(token);
                continue;
            }
            if (")".equals(token)) {
                this.handleCloseParenthesis(operator, operand);
                continue;
            }
            this.handleOperand(operator, operand, token);
        }
        while (!operator.isEmpty()) {
            String op = (String)operator.remove(operator.size() - 1);
            this.applyOperator(operand, op);
        }
        if (operand.size() != 1) {
            throw new ExpressionParsingException("Syntax error in expression");
        }
        return (Node)operand.get(0);
    }

    private void handleOperand(List<String> operator, List<Node> operand, String token) {
        if (operator.isEmpty()) {
            operator.add(token);
        } else {
            String op = operator.get(operator.size() - 1);
            if ("(".equals(op)) {
                operator.add(token);
            } else {
                this.applyOperator(operand, op);
            }
        }
    }

    private void applyOperator(List<Node> operand, String operator) {
        if (operand.size() < 2) {
            throw new ExpressionParsingException("Syntax error in expression");
        }
        Node n1 = operand.remove(operand.size() - 1);
        Node n2 = operand.remove(operand.size() - 1);
        if ("+".equals(operator)) {
            OrNode node = new OrNode(n1, n2);
            operand.add(node);
        } else if ("*".equals(operator)) {
            AndNode node = new AndNode(n1, n2);
            operand.add(node);
        } else {
            throw new ExpressionParsingException("Syntax error in expression");
        }
    }

    private void handleVariable(List<Node> operand, String token) {
        KeyValue keyValue = this.symbolTable.get(token);
        ValueNode node = new ValueNode(keyValue.getKey(), keyValue.getValue());
        operand.add(node);
    }

    private void handleCloseParenthesis(List<String> operator, List<Node> operand) {
        String op = null;
        if (operator.isEmpty()) {
            throw new ExpressionParsingException("Exception in parsing input. Mismatched ')'");
        }
        while (!(op = operator.remove(operator.size() - 1)).equals("(")) {
            this.applyOperator(operand, op);
            if (!operator.isEmpty()) continue;
            throw new ExpressionParsingException("Exception in parsing input. Mismatched ')'");
        }
    }

    private String sanitizeInputString(String input) {
        Matcher matcher = this.pattern.matcher(input);
        int symbolId = 0;
        while (matcher.find()) {
            String token = matcher.group();
            KeyValue keyValue = KeyValue.fromCmdAttributeString(token);
            if (!allowedOperators.contains(keyValue.getOperator())) {
                throw new ExpressionParsingException("Unexpected operator: " + keyValue.getOperator());
            }
            String symbol = String.valueOf(variableMarker) + symbolId++;
            input = input.replace(token, symbol);
            this.symbolTable.put(symbol, keyValue);
        }
        input = input.toLowerCase();
        input = input.replace("and", "*");
        input = input.replace("or", "+");
        Pattern leftoverPattern = Pattern.compile(leftOverRegex);
        Matcher leftoverMatcher = leftoverPattern.matcher(input);
        if (leftoverMatcher.find()) {
            throw new ExpressionParsingException("Invalid characters " + leftoverMatcher.group());
        }
        return input;
    }
}

