/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.cmd.parser;

import com.sap.it.asdk.cmd.parser.generated.ComponentMetadata;
import com.sap.it.asdk.cmd.parser.model.BlueprintMetadataModel;
import com.sap.it.asdk.md.generator.model.camel.CamelEndpointMetadata;
import com.sap.it.asdk.md.generator.model.camel.ComponentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BlueprintMetadataGenerator {
    static final String POST_URI = "://foo?adress=&amp;user=&amp;pwd=&amp;";
    static final String VARIANT_TYPE_SENDER = "Sender";
    static final String VARIANT_TYPE_RECEIVER = "Receiver";
    static final String CAMEL_CONTEXT_ID = "SampleIFlow";

    public ComponentMetadata generateBlueprint(String cName, String componentName, String componentVersion, String adapterVendor, Collection<CamelEndpointMetadata> cemds) {
        if (null == cName || "".equals(cName)) {
            throw new IllegalArgumentException("Component Id must not be null.");
        }
        if (null == cemds || cemds.size() == 0) {
            throw new IllegalArgumentException("Endpoint Meta-Data must not be null.");
        }
        return this._compile(cName, componentName, componentVersion, adapterVendor, cemds);
    }

    private ComponentMetadata _compile(String cName, String componentName, String componentVersion, String adapterVendor, Collection<CamelEndpointMetadata> cemds) {
        ComponentMetadata cmd = this.createComponentMetadata(cName, componentName, componentVersion, adapterVendor);
        for (CamelEndpointMetadata cemd : cemds) {
            ComponentType type = cemd.getComponentInformation().getType();
            if (ComponentType.ConsumerProducer.equals((Object)type) || ComponentType.ConsumerOnly.equals((Object)type)) {
                this.createSenderVariant(cmd, cemd, cName, adapterVendor);
            }
            if (!ComponentType.ConsumerProducer.equals((Object)type) && !ComponentType.ProducerOnly.equals((Object)type)) continue;
            this.createReceiverVariant(cmd, cemd, cName, adapterVendor);
        }
        return cmd;
    }

    private ComponentMetadata createComponentMetadata(String cName, String componentName, String componentVersion, String adapterVendor) {
        if (adapterVendor == null || "".equals(adapterVendor)) {
            adapterVendor = "sap";
        }
        ComponentMetadata cmd = new ComponentMetadata();
        cmd.setComponentId("ctype::Extension/cname::" + cName + "_BP/vendor::" + adapterVendor + "/version::" + componentVersion);
        cmd.setComponentName(adapterVendor + ":" + cName);
        cmd.setComponentDisplayName(componentName);
        cmd.setUIElementType("Extension");
        return cmd;
    }

    private void createReceiverVariant(ComponentMetadata cmd, CamelEndpointMetadata cemd, String cName, String adapterVendor) {
        ComponentMetadata.Variant receiverVariant = new ComponentMetadata.Variant();
        cmd.getVariants().add(receiverVariant);
        String cname = adapterVendor != null && !adapterVendor.isEmpty() ? cName + "_BP/vendor::" + adapterVendor : cName;
        receiverVariant.setVariantId("ctype::ExtensionVariant/cname::" + cname + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Receiver");
        receiverVariant.setVariantName(cemd.getComponentName() + " Receiver");
        receiverVariant.setTransformationTags(this.createEmptyBlueprintMetadata(VARIANT_TYPE_RECEIVER, cemd.getTransportProtocol()));
    }

    private void createSenderVariant(ComponentMetadata cmd, CamelEndpointMetadata cemd, String cName, String adapterVendor) {
        ComponentMetadata.Variant senderVariant = new ComponentMetadata.Variant();
        cmd.getVariants().add(senderVariant);
        String cname = adapterVendor != null && !adapterVendor.isEmpty() ? cName + "_BP/vendor::" + adapterVendor : cName;
        senderVariant.setVariantId("ctype::ExtensionVariant/cname::" + cname + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Sender");
        senderVariant.setVariantName(cemd.getComponentName() + " Sender");
        senderVariant.setTransformationTags(this.createEmptyBlueprintMetadata(VARIANT_TYPE_SENDER, cemd.getTransportProtocol()));
    }

    private BlueprintMetadataModel createEmptyBlueprintMetadata(String variantType, String transportProtocol) {
        BlueprintMetadataModel.Blueprint.CamelContext.Route.From camelFrom = new BlueprintMetadataModel.Blueprint.CamelContext.Route.From();
        BlueprintMetadataModel.Blueprint.CamelContext.Route.To camelTo = new BlueprintMetadataModel.Blueprint.CamelContext.Route.To();
        camelFrom.setUri(transportProtocol + POST_URI);
        camelTo.setUri(transportProtocol + POST_URI);
        BlueprintMetadataModel.Blueprint.CamelContext camelContext = new BlueprintMetadataModel.Blueprint.CamelContext();
        camelContext.setStreamCache("true");
        BlueprintMetadataModel.Blueprint.CamelContext.Route route = new BlueprintMetadataModel.Blueprint.CamelContext.Route();
        if (VARIANT_TYPE_SENDER.equals(variantType)) {
            route.setFrom(camelFrom);
        } else {
            route.setTo(camelTo);
        }
        camelContext.setRoute(route);
        BlueprintMetadataModel.Blueprint bp = new BlueprintMetadataModel.Blueprint();
        bp.setCamel("http://camel.apache.org/schema/blueprint");
        bp.setCxf("http://camel.apache.org/schema/blueprint/cxf");
        bp.setCxfcore("http://cxf.apache.org/blueprint/core");
        bp.setHttpConf("http://cxf.apache.org/transports/http/configuration");
        bp.setOsgibp("http://www.osgi.org/xmlns/blueprint/v1.0.0");
        bp.setSec("http://cxf.apache.org/configuration/security");
        ArrayList<BlueprintMetadataModel.Blueprint.Reference> references = new ArrayList<BlueprintMetadataModel.Blueprint.Reference>();
        BlueprintMetadataModel.Blueprint.Reference reference = TagsConstructor.constructReference("customClassResolver", "org.apache.camel.spi.ClassResolver");
        references.add(reference);
        reference = TagsConstructor.constructReference("MessageProcessingLogSink", "com.sap.it.op.agent.api.MessageProcessingLogSink");
        references.add(reference);
        reference = TagsConstructor.constructReference("IntegrationOperationsErrorEventPublisher", "com.sap.it.op.ed.IntegrationOperationsErrorEventPublisher");
        references.add(reference);
        reference = TagsConstructor.constructReference("authenticationHeaderProvider", "com.sap.it.nm.security.AuthenticationHeaderProvider");
        references.add(reference);
        reference = TagsConstructor.constructReference("secureStore", "com.sap.it.nm.security.SecureStore");
        references.add(reference);
        bp.setReference(references);
        ArrayList<BlueprintMetadataModel.Blueprint.Bean> beans = new ArrayList<BlueprintMetadataModel.Blueprint.Bean>();
        ArrayList<BlueprintMetadataModel.Blueprint.Bean.Property> properties = new ArrayList<BlueprintMetadataModel.Blueprint.Bean.Property>();
        BlueprintMetadataModel.Blueprint.Bean.Property.Ref ref = TagsConstructor.constructRef("itOpAgentMplConfiguration");
        BlueprintMetadataModel.Blueprint.Bean.Property property = TagsConstructor.constructProperty("mplConfiguration", null, ref, null);
        properties.add(property);
        BlueprintMetadataModel.Blueprint.Bean bean = TagsConstructor.constructBean("itOpAgentMplInterceptor", "com.sap.it.op.agent.collector.camel.MplInterceptor", properties);
        beans.add(bean);
        bean = TagsConstructor.constructBean("userdefinedNamespaces", "java.util.HashMap", null);
        beans.add(bean);
        properties = new ArrayList();
        property = TagsConstructor.constructProperty("persistOnlyOnIntermediateError", "false", null, null);
        properties.add(property);
        property = TagsConstructor.constructProperty("mplActive", "true", null, null);
        properties.add(property);
        bean = TagsConstructor.constructBean("itOpAgentMplConfiguration", "com.sap.it.op.agent.mpl.MplConfiguration", properties);
        beans.add(bean);
        properties = new ArrayList();
        property = TagsConstructor.constructProperty("secureParameterStorage", null, null, "secureStore");
        properties.add(property);
        bean = TagsConstructor.constructBean("secureParameterAccessFactory", "com.sap.esb.secure.parameter.impl.SecureParameterAccessFactoryImpl", properties);
        beans.add(bean);
        properties = new ArrayList();
        ref = TagsConstructor.constructRef("MessageProcessingLogSink");
        property = TagsConstructor.constructProperty("messageProcessingLogSink", null, ref, null);
        properties.add(property);
        ref = TagsConstructor.constructRef("itOpAgentMplConfiguration");
        property = TagsConstructor.constructProperty("mplConfiguration", null, ref, null);
        properties.add(property);
        bean = TagsConstructor.constructBean("itOpAgentMplEventNotifier", "com.sap.it.op.agent.collector.camel.MplEventNotifier", properties);
        beans.add(bean);
        bp.setBean(beans);
        bp.setCamelContext(camelContext);
        BlueprintMetadataModel bpMetadataModel = new BlueprintMetadataModel();
        bpMetadataModel.setBlueprint(bp);
        return bpMetadataModel;
    }

    public static class TagsConstructor {
        public static BlueprintMetadataModel.Blueprint.Bean constructBean(String id, String className, List<BlueprintMetadataModel.Blueprint.Bean.Property> properties) {
            BlueprintMetadataModel.Blueprint.Bean bean = new BlueprintMetadataModel.Blueprint.Bean();
            bean.setId(id);
            bean.setClass(className);
            if (properties != null && !properties.isEmpty()) {
                bean.setProperty(properties);
            }
            return bean;
        }

        public static BlueprintMetadataModel.Blueprint.Bean.Property constructProperty(String name, String value, BlueprintMetadataModel.Blueprint.Bean.Property.Ref ref, String refAttribute) {
            BlueprintMetadataModel.Blueprint.Bean.Property property = new BlueprintMetadataModel.Blueprint.Bean.Property();
            property.setName(name);
            if (value != null) {
                property.setValue(value);
            }
            if (ref != null) {
                property.setRef(ref);
            }
            if (refAttribute != null) {
                property.setRefAttribute(refAttribute);
            }
            return property;
        }

        public static BlueprintMetadataModel.Blueprint.Bean.Property.Ref constructRef(String componentId) {
            BlueprintMetadataModel.Blueprint.Bean.Property.Ref ref = new BlueprintMetadataModel.Blueprint.Bean.Property.Ref();
            ref.setComponentId(componentId);
            return ref;
        }

        public static BlueprintMetadataModel.Blueprint.Reference constructReference(String id, String interfaceValue) {
            BlueprintMetadataModel.Blueprint.Reference reference = new BlueprintMetadataModel.Blueprint.Reference();
            reference.setId(id);
            reference.setInterface(interfaceValue);
            return reference;
        }
    }
}

