/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.cmd.parser;

import com.sap.it.asdk.cmd.parser.generated.ComponentMetadata;
import com.sap.it.asdk.cmd.parser.generated.ObjectFactory;
import com.sap.it.asdk.md.generator.analysis.utils.NameUtils;
import com.sap.it.asdk.md.generator.model.camel.CamelEndpointMetadata;
import com.sap.it.asdk.md.generator.model.camel.CamelParameter;
import com.sap.it.asdk.md.generator.model.camel.ComponentType;
import com.sap.it.asdk.md.generator.model.camel.EditConditionExpression;
import com.sap.it.asdk.md.generator.model.camel.MatchEditExpression;
import com.sap.it.asdk.md.generator.model.camel.NotEditExpression;
import com.sap.it.asdk.md.generator.model.camel.ParameterGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class ComponentMetaDataCompiler {
    private static final String ATTACHMENT_PRESERVE = "Preserve";
    private static final String CONNECTION = "Connection";

    private ComponentMetaDataCompiler() {
    }

    public static ComponentMetaDataCompiler create() {
        return new ComponentMetaDataCompiler();
    }

    public ComponentMetadata compile(String cName, String componentName, String componentVersion, Collection<CamelEndpointMetadata> cemds) {
        return this.compile(cName, componentName, componentVersion, null, cemds);
    }

    public ComponentMetadata compile(String cName, String componentName, String componentVersion, String adapterVendor, Collection<CamelEndpointMetadata> cemds) {
        if (null == cName || "".equals(cName)) {
            throw new IllegalArgumentException("Component Id must not be null.");
        }
        if (null == cemds || cemds.size() == 0) {
            throw new IllegalArgumentException("Endpoint Meta-Data must not be null.");
        }
        return this._compile(cName, componentName, componentVersion, adapterVendor, cemds);
    }

    private ComponentMetadata _compile(String cName, String componentName, String componentVersion, String adapterVendor, Collection<CamelEndpointMetadata> cemds) {
        ComponentMetadata cmd = this.createComponentMetadata(cName, componentName, componentVersion, adapterVendor);
        for (CamelEndpointMetadata cemd : cemds) {
            ComponentType type = cemd.getComponentInformation().getType();
            if (ComponentType.ConsumerProducer.equals((Object)type) || ComponentType.ConsumerOnly.equals((Object)type)) {
                this.createSenderVariant(cmd, cemd, cName, adapterVendor);
            }
            if (ComponentType.ConsumerProducer.equals((Object)type) || ComponentType.ProducerOnly.equals((Object)type)) {
                this.createReceiverVariant(cmd, cemd, cName, adapterVendor);
            }
            cmd.getAttributeMetadatasAndAttributeTableMetadatas().addAll(this.createAttributeMetaData(cemd));
        }
        return cmd;
    }

    private ComponentMetadata createComponentMetadata(String cName, String componentName, String componentVersion, String adapterVendor) {
        if (adapterVendor == null || "".equals(adapterVendor)) {
            adapterVendor = "sap";
        }
        ComponentMetadata cmd = new ComponentMetadata();
        cmd.setComponentId("ctype::Adapter/cname::" + cName + "/vendor::" + adapterVendor + "/version::" + componentVersion);
        cmd.setComponentName(cName);
        cmd.setIsExtension(false);
        cmd.setIsFinal(true);
        cmd.setIsPreserves(true);
        cmd.setIsDefaultGenerator(true);
        cmd.setComponentDisplayName(componentName);
        cmd.setUIElementType("Adapter");
        return cmd;
    }

    private void createReceiverVariant(ComponentMetadata cmd, CamelEndpointMetadata cemd, String cName, String adapterVendor) {
        ComponentMetadata.Variant receiverVariant = new ComponentMetadata.Variant();
        cmd.getVariants().add(receiverVariant);
        receiverVariant.setMetadataVersion("2.0");
        receiverVariant.setRuntimeComponentBaseUri(this.getSchemeCompatible(cemd));
        if (adapterVendor != null && !adapterVendor.isEmpty()) {
            receiverVariant.setVariantId("ctype::AdapterVariant/cname::" + cName + "/vendor::" + adapterVendor + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Receiver");
        } else {
            receiverVariant.setVariantId("ctype::AdapterVariant/cname::" + cName + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Receiver");
        }
        receiverVariant.setVariantName(cemd.getComponentName() + " Receiver");
        receiverVariant.setInputContent(this.createInputContent("Any"));
        receiverVariant.setOutputContent(this.createOutputContent("Any"));
        ComponentMetadata.Variant.OutputContent.Content content = receiverVariant.getOutputContent().getContents().get(0);
        this.addReceiverInputContentType(cemd, receiverVariant);
        this.changeReceiverOutContentType(cemd, receiverVariant, content);
        receiverVariant.setAttachmentBehavior(ATTACHMENT_PRESERVE);
        receiverVariant.setIsRequestResponse(true);
        ComponentMetadata.Variant.Tab tab = this.createTab();
        receiverVariant.getTabs().add(tab);
        this.createAttributeGroups(tab, cemd, false);
    }

    private void changeReceiverOutContentType(CamelEndpointMetadata cemd, ComponentMetadata.Variant receiverVariant, ComponentMetadata.Variant.OutputContent.Content content) {
        String value = cemd.getReceiverVariantOutputChange();
        if (value != null && !value.isEmpty()) {
            Object schema = this.getExistingContentSchemaOrEmpty(content);
            ComponentMetadata.Variant.OutputContent.Content newContent = new ComponentMetadata.Variant.OutputContent.Content();
            newContent.setContentType(value);
            newContent.setSchema(schema);
            receiverVariant.getOutputContent().getContents().add(newContent);
        }
    }

    private String getSchemeCompatible(CamelEndpointMetadata cemd) {
        String scheme = cemd.getScheme();
        if (scheme == null) {
            scheme = cemd.getTransportProtocol();
        }
        return scheme;
    }

    private void createSenderVariant(ComponentMetadata cmd, CamelEndpointMetadata cemd, String cName, String adapterVendor) {
        ComponentMetadata.Variant senderVariant = new ComponentMetadata.Variant();
        cmd.getVariants().add(senderVariant);
        senderVariant.setMetadataVersion("2.0");
        senderVariant.setRuntimeComponentBaseUri(this.getSchemeCompatible(cemd));
        if (adapterVendor != null) {
            senderVariant.setVariantId("ctype::AdapterVariant/cname::" + cName + "/vendor::" + adapterVendor + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Sender");
        } else {
            senderVariant.setVariantId("ctype::AdapterVariant/cname::" + cName + "/tp::" + cemd.getTransportProtocol() + "/mp::" + cemd.getMessageProtocol() + "/direction::Sender");
        }
        senderVariant.setVariantName(cemd.getComponentName() + " Sender");
        senderVariant.setInputContent(this.createInputContent("Any"));
        senderVariant.setOutputContent(this.createOutputContent("Any"));
        senderVariant.setAttachmentBehavior(ATTACHMENT_PRESERVE);
        ComponentMetadata.Variant.Tab tab = this.createTab();
        senderVariant.getTabs().add(tab);
        this.createAttributeGroups(tab, cemd, true);
    }

    private void addReceiverInputContentType(CamelEndpointMetadata cemd, ComponentMetadata.Variant senderVariant) {
        ComponentMetadata.Variant.InputContent.Content content = senderVariant.getInputContent().getContents().get(0);
        Object schema = this.getExistingSchemaOrEmpty(content);
        for (String value : cemd.getReceiverVariantInputAdd()) {
            ComponentMetadata.Variant.InputContent.Content newContent = new ComponentMetadata.Variant.InputContent.Content();
            newContent.setContentType(value);
            newContent.setSchema(schema);
            senderVariant.getInputContent().getContents().add(newContent);
        }
    }

    private Object getExistingContentSchemaOrEmpty(ComponentMetadata.Variant.OutputContent.Content content) {
        Object schema = "";
        if (content != null) {
            schema = content.getSchema();
        }
        return schema;
    }

    private Object getExistingSchemaOrEmpty(ComponentMetadata.Variant.InputContent.Content content) {
        Object schema = "";
        if (content != null) {
            schema = content.getSchema();
        }
        return schema;
    }

    private void createAttributeGroups(ComponentMetadata.Variant.Tab tab, CamelEndpointMetadata cemd, boolean isSender) {
        List<ParameterGroup> parameterGroups = cemd.getParameterGroups();
        for (ParameterGroup parameterGroup : parameterGroups) {
            if (parameterGroup.isInboundOnlyGroup()) {
                if (!isSender) continue;
                tab.getAttributeReferencesAndAttributeGroups().add(this.createAttributeGroup(parameterGroup));
                continue;
            }
            if (parameterGroup.isOutboundOnlyGroup()) {
                if (isSender) continue;
                tab.getAttributeReferencesAndAttributeGroups().add(this.createAttributeGroup(parameterGroup));
                continue;
            }
            tab.getAttributeReferencesAndAttributeGroups().add(this.createAttributeGroup(parameterGroup));
        }
    }

    private ComponentMetadata.Variant.Tab createTab() {
        ComponentMetadata.Variant.Tab tab = new ComponentMetadata.Variant.Tab();
        tab.setId("connection");
        tab.setGuiLabels(this.createGuiLabels(CONNECTION, ""));
        return tab;
    }

    private ComponentMetadata.Variant.InputContent.Content createContent(String contentType) {
        ComponentMetadata.Variant.InputContent.Content content = new ComponentMetadata.Variant.InputContent.Content();
        content.setSchema("");
        content.setContentType(contentType);
        return content;
    }

    private ComponentMetadata.Variant.OutputContent.Content createOutputContentContent(String contentType) {
        ComponentMetadata.Variant.OutputContent.Content content = new ComponentMetadata.Variant.OutputContent.Content();
        content.setSchema("");
        content.setContentType(contentType);
        return content;
    }

    protected ComponentMetadata.Variant.InputContent createInputContent(String ... contentTypes) {
        ComponentMetadata.Variant.InputContent inputContent = new ComponentMetadata.Variant.InputContent();
        inputContent.setScope("outsidepool");
        inputContent.setCardinality("1");
        inputContent.setIsStreaming("false");
        inputContent.setMessageCardinality("1");
        for (String types : contentTypes) {
            inputContent.getContents().add(this.createContent(types));
        }
        return inputContent;
    }

    private ComponentMetadata.Variant.OutputContent createOutputContent(String contentType) {
        ComponentMetadata.Variant.OutputContent outputContent = new ComponentMetadata.Variant.OutputContent();
        outputContent.setScope("outsidepool");
        outputContent.setCardinality("1");
        outputContent.setIsStreaming("false");
        outputContent.setMessageCardinality("1");
        outputContent.getContents().add(this.createOutputContentContent(contentType));
        return outputContent;
    }

    private List<ComponentMetadata.AttributeMetadata> createAttributeMetaData(CamelEndpointMetadata cemd) {
        ArrayList<ComponentMetadata.AttributeMetadata> amds = new ArrayList<ComponentMetadata.AttributeMetadata>();
        for (ParameterGroup camelParameters : cemd.getParameterGroups()) {
            for (CamelParameter camelParameter : camelParameters.getParameters()) {
                String name = camelParameter.getName();
                ComponentMetadata.AttributeMetadata attributeMetadata = new ComponentMetadata.AttributeMetadata();
                amds.add(attributeMetadata);
                attributeMetadata.setName(name);
                if (!camelParameter.isRequired()) {
                    attributeMetadata.setUsage(new ObjectFactory().createComponentMetadataAttributeMetadataUsage("false"));
                } else {
                    attributeMetadata.setUsage(new ObjectFactory().createComponentMetadataAttributeMetadataUsage("true"));
                }
                attributeMetadata.setDefault(this.checkNull(camelParameter));
                attributeMetadata.setDataType(camelParameter.getType().getXsdType());
                if (camelParameter.isConfidential()) {
                    attributeMetadata.setAttributeBehavior("SecureAlias");
                }
                attributeMetadata.setLength("");
                attributeMetadata.setGuiLabels(this.createGuiLabels(camelParameter.getLabel(), cemd.getVersion(), false));
                attributeMetadata.setIsparameterized("true");
                this.addEnumsAsFixedValues(camelParameter, attributeMetadata);
            }
        }
        return amds;
    }

    private void addEnumsAsFixedValues(CamelParameter camelParameter, ComponentMetadata.AttributeMetadata attributeMetadata) {
        List<String> enumValues = camelParameter.getEnumValues();
        if (null == enumValues) {
            return;
        }
        if (enumValues.size() > 0) {
            attributeMetadata.setIsparameterized(String.valueOf(false));
            ComponentMetadata.AttributeMetadata.FixedValues fixedValues = new ComponentMetadata.AttributeMetadata.FixedValues();
            attributeMetadata.getFixedValues().add(fixedValues);
            for (int i = 0; i < enumValues.size(); ++i) {
                String enumValue = enumValues.get(i);
                ComponentMetadata.AttributeMetadata.FixedValues.FixedValue fixedValue = new ComponentMetadata.AttributeMetadata.FixedValues.FixedValue();
                fixedValues.getFixedValues().add(fixedValue);
                fixedValue.setValue(enumValue);
                if (camelParameter.getEnumLabels().size() > 0) {
                    fixedValue.setGuiLabels(this.createGuiLabels(camelParameter.getEnumLabels().get(i), "", false));
                    continue;
                }
                fixedValue.setGuiLabels(this.createGuiLabels(enumValue, ""));
            }
        }
    }

    private String checkNull(CamelParameter camelParameter) {
        return camelParameter.getDefaultValue() == null ? "" : camelParameter.getDefaultValue().toString();
    }

    private ComponentMetadata.AttributeTableMetadata.GuiLabels createGuiLabels(String name, String version) {
        return this.createGuiLabels(name, version, true);
    }

    private ComponentMetadata.AttributeTableMetadata.GuiLabels createGuiLabels(String name, String version, boolean humanize) {
        ComponentMetadata.AttributeTableMetadata.GuiLabels guiLabels = new ComponentMetadata.AttributeTableMetadata.GuiLabels();
        guiLabels.setGuid(UUID.randomUUID().toString());
        ComponentMetadata.AttributeTableMetadata.GuiLabels.Label labelEN = new ComponentMetadata.AttributeTableMetadata.GuiLabels.Label();
        labelEN.setLanguage("EN");
        labelEN.setValue(humanize ? NameUtils.humanReadable(name) : name);
        guiLabels.getLabels().add(labelEN);
        ComponentMetadata.AttributeTableMetadata.GuiLabels.Label labelDE = new ComponentMetadata.AttributeTableMetadata.GuiLabels.Label();
        labelDE.setLanguage("DE");
        labelDE.setValue(humanize ? NameUtils.humanReadable(name) : name);
        guiLabels.getLabels().add(labelDE);
        return guiLabels;
    }

    private ComponentMetadata.Variant.Tab.AttributeGroup createAttributeGroup(ParameterGroup parameterGroup) {
        ComponentMetadata.Variant.Tab.AttributeGroup attributeGroup = new ComponentMetadata.Variant.Tab.AttributeGroup();
        attributeGroup.setId(parameterGroup.getId());
        attributeGroup.setName(parameterGroup.getName());
        attributeGroup.getAttributeReferences().addAll(this.createAttributeReferences(parameterGroup));
        attributeGroup.setGuiLabels(this.createGuiLabels(parameterGroup.getName(), "", false));
        return attributeGroup;
    }

    private List<ComponentMetadata.Variant.Tab.AttributeGroup.AttributeReference> createAttributeReferences(ParameterGroup parameterGroup) {
        ArrayList<ComponentMetadata.Variant.Tab.AttributeGroup.AttributeReference> ars = new ArrayList<ComponentMetadata.Variant.Tab.AttributeGroup.AttributeReference>();
        for (CamelParameter parameter : parameterGroup.getParameters()) {
            ComponentMetadata.AttributeMetadata.FixedValues.EditCondition editCondition;
            EditConditionExpression matchEditExpression;
            String name = parameter.getName();
            String description = parameter.getDescription();
            ComponentMetadata.Variant.Tab.AttributeGroup.AttributeReference attributeReference = new ComponentMetadata.Variant.Tab.AttributeGroup.AttributeReference();
            ars.add(attributeReference);
            attributeReference.setReferenceName(name);
            attributeReference.setDescription(description);
            EditConditionExpression editConditionExpression = parameter.getEditCondition();
            if (editConditionExpression == null) continue;
            if (editConditionExpression instanceof MatchEditExpression) {
                matchEditExpression = (MatchEditExpression)editConditionExpression;
                editCondition = new ComponentMetadata.AttributeMetadata.FixedValues.EditCondition();
                editCondition.setAttributeName(((MatchEditExpression)matchEditExpression).getId());
                editCondition.setAttributeValue(((MatchEditExpression)matchEditExpression).getValue());
                attributeReference.getAndConditionsAndOrConditionsAndNotConditions().add(editCondition);
                continue;
            }
            if (!(editConditionExpression instanceof NotEditExpression)) continue;
            matchEditExpression = (NotEditExpression)editConditionExpression;
            editCondition = new ComponentMetadata.AttributeMetadata.FixedValues.EditCondition();
            editCondition.setAttributeName(((NotEditExpression)matchEditExpression).getId());
            editCondition.setAttributeValue(((NotEditExpression)matchEditExpression).getValue());
            ComponentMetadata.AttributeMetadata.FixedValues.NotCondition notCondition = new ComponentMetadata.AttributeMetadata.FixedValues.NotCondition();
            notCondition.setEditCondition(editCondition);
            attributeReference.getAndConditionsAndOrConditionsAndNotConditions().add(notCondition);
        }
        return ars;
    }
}

