/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.cmd.parser;

import com.sap.it.asdk.cmd.parser.generated.ComponentMetadata;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ComponentMetaDataParser {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ComponentMetaDataParser.class);
    private static final String MODEL_SPEC = "com.sap.it.asdk.cmd.parser.generated";
    private static Object lock = new Object();
    private static JAXBContext jc;
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;

    private static void initialize() throws JAXBException, SAXException, IOException {
        if (jc == null) {
            jc = JAXBContext.newInstance((String)MODEL_SPEC, (ClassLoader)ComponentMetaDataParser.class.getClassLoader());
            unmarshaller = jc.createUnmarshaller();
            marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentMetadata importModel(File adapterImportFile) {
        if (null == adapterImportFile) {
            throw new IllegalArgumentException("File must not be null.");
        }
        try {
            Object object = lock;
            synchronized (object) {
                ComponentMetaDataParser.initialize();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                dbf.setExpandEntityReferences(false);
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(adapterImportFile);
                return (ComponentMetadata)unmarshaller.unmarshal((Node)document);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                ComponentMetaDataParser.handleException((Exception)e.getCause());
            } else {
                ComponentMetaDataParser.handleException(e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportModel(ComponentMetadata modelRoot, OutputStream stream) {
        if (null == stream) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        try {
            Object object = lock;
            synchronized (object) {
                ComponentMetaDataParser.initialize();
                if (marshaller == null) {
                    ComponentMetaDataParser.handleException((Exception)((Object)new JAXBException("Marshaller not available.")));
                }
                marshaller.marshal((Object)modelRoot, stream);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                ComponentMetaDataParser.handleException((Exception)e.getCause());
            }
            ComponentMetaDataParser.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportModel(Object modelRoot, File exportFile) {
        if (null == exportFile) {
            throw new IllegalArgumentException("File must not be null.");
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(exportFile));){
            if (exportFile.getParentFile() != null && !exportFile.getParentFile().canWrite()) {
                new File(exportFile.getParent()).mkdir();
            }
            Object object = lock;
            synchronized (object) {
                ComponentMetaDataParser.initialize();
                if (marshaller == null) {
                    ComponentMetaDataParser.handleException((Exception)((Object)new JAXBException("Marshaller not available.")));
                }
                marshaller.marshal(modelRoot, (Writer)out);
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                ComponentMetaDataParser.handleException((Exception)e.getCause());
            }
            ComponentMetaDataParser.handleException(e);
        }
    }

    private static void handleException(Exception e) {
        String errorMsg = "Component Meta-Data could not be processed.";
        LOGGER.error("Component Meta-Data could not be processed.", (Throwable)e);
        throw new IllegalStateException("Component Meta-Data could not be processed.", e);
    }
}

