/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.analysis;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzer;
import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.model.BundleInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class BundleAnalyzer {
    private final ClassAnalyzerContext context;
    private final ClassAnalyzer classAnalyzer;

    public BundleAnalyzer() {
        this.context = new ClassAnalyzerContext();
        this.classAnalyzer = new ClassAnalyzer(this.context);
    }

    public BundleAnalyzer(ClassAnalyzerContext context) {
        this.context = context;
        this.classAnalyzer = new ClassAnalyzer(context);
    }

    public BundleInfo analyzeBundle(InputStream is) {
        try {
            JarInputStream stream = new JarInputStream(is);
            BundleInfo bundleInfo = new BundleInfo();
            Attributes manifest = stream.getManifest().getMainAttributes();
            bundleInfo.setVersion(manifest.getValue("Bundle-Version"));
            bundleInfo.setName(manifest.getValue("Bundle-Name"));
            bundleInfo.setArtifactId(manifest.getValue("Bundle-SymbolicName"));
            JarEntry entry = null;
            while ((entry = stream.getNextJarEntry()) != null) {
                this.analyzeEntry(stream, bundleInfo, entry);
            }
            return bundleInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyzeEntry(JarInputStream stream, BundleInfo bundleInfo, JarEntry entry) {
        if (entry.getName().endsWith(".class")) {
            bundleInfo.addClass(this.classAnalyzer.analyze(stream));
        }
    }

    public BundleInfo analyzeBundle(File file) {
        try {
            return this.analyzeBundle(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void resolveReferences() {
        this.classAnalyzer.calculateResolvedModel();
    }

    public ClassAnalyzerContext getContext() {
        return this.context;
    }
}

