/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.analysis;

import com.sap.it.asdk.md.generator.analysis.BundleAnalyzer;
import com.sap.it.asdk.md.generator.analysis.BundleInfoReader;
import com.sap.it.asdk.md.generator.analysis.utils.NameUtils;
import com.sap.it.asdk.md.generator.model.BundleInfo;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.FieldInfo;
import com.sap.it.asdk.md.generator.model.MethodCallInfo;
import com.sap.it.asdk.md.generator.model.MethodInfo;
import com.sap.it.asdk.md.generator.model.StaticFieldReference;
import com.sap.it.asdk.md.generator.model.camel.CamelEndpointMetadata;
import com.sap.it.asdk.md.generator.model.camel.CamelParameter;
import com.sap.it.asdk.md.generator.model.camel.ComponentInformation;
import com.sap.it.asdk.md.generator.model.camel.ComponentType;
import com.sap.it.asdk.md.generator.model.camel.ParameterGroup;
import com.sap.it.asdk.md.generator.model.camel.ParameterType;
import com.sap.it.asdk.md.generator.model.camel.ReapingIssue;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelComponentAnalyzer
extends BundleAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(CamelComponentAnalyzer.class);
    private static final String JAVA_PRE_ANALYSIS = "java-lib.xml";
    private static final String CAMEL_CORE_PRE_ANALYSIS = "camel-core-3.14.7.minified.xml";
    private static final String[] CLASS_LINEAGE_STOPS = new String[]{"org.apache.camel.support.DefaultEndpoint", "org.apache.camel.support.service.ServiceSupport"};
    private static final Pattern COMPONENT_FILE_EXPRESSION = Pattern.compile("META-INF/services/org/apache/camel/component/(.+)");
    private final HashMap<String, String> componentsToBeAnalyzed = new HashMap();
    private static final String BEAN_INTERFACE = "interface";
    private static final String BEAN_FILTER = "filter";
    private static final String USE_BEAN_FLAG = "useBean";

    public Collection<CamelEndpointMetadata> analyzeComponents(InputStream stream) {
        return this.analyzeComponents(stream, null);
    }

    public Collection<CamelEndpointMetadata> analyzeComponents(InputStream stream, File preAnalysisFolder) {
        if (null == preAnalysisFolder || !preAnalysisFolder.exists() && !preAnalysisFolder.isDirectory()) {
            this.mixinPreAnalysis(CAMEL_CORE_PRE_ANALYSIS);
            this.mixinPreAnalysis(JAVA_PRE_ANALYSIS);
        } else if (null != preAnalysisFolder && preAnalysisFolder.exists() && preAnalysisFolder.isDirectory()) {
            this.mixinExternalPreAnalysis(preAnalysisFolder);
        } else {
            throw new IllegalArgumentException("Pre-Analysis could not be merged.");
        }
        BundleInfo bundleInfo = super.analyzeBundle(stream);
        super.resolveReferences();
        ArrayList<CamelEndpointMetadata> result = new ArrayList<CamelEndpointMetadata>();
        for (Map.Entry<String, String> entry : this.componentsToBeAnalyzed.entrySet()) {
            result.add(this.analyzeComponent(bundleInfo, entry.getKey(), entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private void mixinExternalPreAnalysis(File preAnalysisFolder) {
        FilenameFilter fileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String expression) {
                return expression.endsWith(".jar");
            }
        };
        File[] listFiles = preAnalysisFolder.listFiles(fileNameFilter);
        for (int i = 0; i < listFiles.length; ++i) {
            new BundleAnalyzer(super.getContext()).analyzeBundle(listFiles[i]);
        }
    }

    private void mixinPreAnalysis(String file) {
        BundleInfoReader reader = new BundleInfoReader();
        BundleInfo camelBundleInfo = reader.read(this.getClass().getResourceAsStream("/analysis-results/" + file));
        this.getContext().addAllClassInfos(camelBundleInfo.getAllClassInfos());
    }

    /*
     * WARNING - void declaration
     */
    private CamelEndpointMetadata analyzeComponent(BundleInfo bundleInfo, String transportProtocol, String messageProtocol, String componentClass) {
        ClassInfo componentClassInfo = super.getContext().getClassInfo(componentClass);
        Set<ClassInfo> endpointClasses = this.searchEndpointClasses(componentClassInfo);
        CamelEndpointMetadata cemd = new CamelEndpointMetadata();
        cemd.setComponentName(NameUtils.humanReadable(componentClassInfo.getSimpleName()));
        cemd.setArtifactId(bundleInfo.getArtifactId());
        cemd.setVersion(bundleInfo.getVersion());
        cemd.setTransportProtocol(transportProtocol);
        cemd.setScheme(transportProtocol);
        cemd.setMessageProtocol(messageProtocol);
        ComponentInformation componentInformation = new ComponentInformation();
        componentInformation.setType(ComponentType.ConsumerProducer);
        cemd.setComponentInformation(componentInformation);
        if (endpointClasses.isEmpty()) {
            log.error("Could not find endpoint class for component class {}", (Object)componentClassInfo.getName());
        }
        for (ClassInfo endpointClass : endpointClasses) {
            void var16_16;
            ClassInfo classInfo;
            ClassInfo classInfo2;
            Object classInfo32;
            componentInformation.addEndpointClass(endpointClass.getName());
            ParameterGroup defaultUriParameterGroup = new ParameterGroup();
            defaultUriParameterGroup.setId("defaultUriParameter");
            defaultUriParameterGroup.setName("URI Setting");
            CamelParameter defaultUriParameter = new CamelParameter(ParameterType.String, false, false, "firstUriPart", "First URI Part", (Object)"", "", new ArrayList<String>());
            defaultUriParameterGroup.add(defaultUriParameter);
            cemd.addParameterGroup(defaultUriParameterGroup);
            HashSet<ClassInfo> visitedClasses = new HashSet<ClassInfo>();
            this.introspectTransferredConfigurationObjects(componentClassInfo, cemd, endpointClass, visitedClasses);
            List<ClassInfo> endpointClassLineage = endpointClass.withClassLineageStopBefore(CLASS_LINEAGE_STOPS);
            for (ClassInfo classInfo4 : endpointClassLineage) {
                cemd.addAllParameterGroups(this.introspect(classInfo4, visitedClasses));
            }
            ClassInfo consumerClass = null;
            for (ClassInfo classInfo22 : endpointClassLineage) {
                consumerClass = this.searchSubclassInstantiatedInMethod("org.apache.camel.Consumer", "createConsumer", classInfo22, endpointClassLineage);
                if (consumerClass == null) continue;
                componentInformation.addConsumerClass(consumerClass.getName());
                break;
            }
            if (consumerClass != null) {
                for (Object classInfo32 : consumerClass.withClassLineage()) {
                    if (!ClassReference.isInCollection("org.apache.camel.ExchangePattern", ((ClassInfo)classInfo32).getReferencedClasses())) continue;
                    log.debug("Found exchange Pattern");
                }
            }
            if (consumerClass != null) {
                HashSet<ParameterGroup> hashSet = new HashSet<ParameterGroup>();
                hashSet.addAll(this.introspect(consumerClass, visitedClasses));
                for (ClassInfo classInfo4 : consumerClass.getClassLineageStopBefore(CLASS_LINEAGE_STOPS)) {
                    hashSet.addAll(this.introspect(classInfo4, visitedClasses));
                }
                for (ParameterGroup consumerGroup : hashSet) {
                    consumerGroup.setInboundOnlyGroup(true);
                    cemd.addParameterGroup(consumerGroup);
                }
            } else {
                boolean bl = this.checkForUnsupportedException("createConsumer", endpointClassLineage);
                if (!bl) {
                    cemd.getComponentInformation().setType(ComponentType.Unknown);
                    cemd.getComponentInformation().addReapingIssue(ReapingIssue.ConsumerClassNotFound);
                    log.warn("Could not find reference to consumer class in endpoint class {}", (Object)endpointClass.getName());
                } else {
                    cemd.getComponentInformation().setType(ComponentType.ProducerOnly);
                    log.debug("Create consumer not supported in endpoint class {}", (Object)endpointClass.getName());
                }
            }
            Object var16_24 = null;
            classInfo32 = endpointClassLineage.iterator();
            while (classInfo32.hasNext() && (classInfo2 = this.searchSubclassInstantiatedInMethod("org.apache.camel.Producer", "createProducer", classInfo = classInfo32.next(), endpointClassLineage)) == null) {
            }
            if (var16_16 != null) {
                HashSet<ParameterGroup> producerGroups = new HashSet<ParameterGroup>();
                producerGroups.addAll(this.introspect((ClassInfo)var16_16, visitedClasses));
                for (ClassInfo classInfo5 : var16_16.getClassLineageStopBefore(CLASS_LINEAGE_STOPS)) {
                    producerGroups.addAll(this.introspect(classInfo5, visitedClasses));
                }
                for (ParameterGroup producerGroup : producerGroups) {
                    producerGroup.setOutboundOnlyGroup(true);
                    cemd.addParameterGroup(producerGroup);
                }
                continue;
            }
            boolean unsupportedException = this.checkForUnsupportedException("createProducer", endpointClassLineage);
            if (!unsupportedException) {
                cemd.getComponentInformation().setType(ComponentType.Unknown);
                cemd.getComponentInformation().addReapingIssue(ReapingIssue.ProducerClassNotFound);
                log.warn("Could not find reference to producer class in endpoint class {}", (Object)endpointClass.getName());
                continue;
            }
            cemd.getComponentInformation().setType(ComponentType.ConsumerOnly);
            log.debug("Create producer not supported in endpoint class {}", (Object)endpointClass.getName());
        }
        ParameterGroup componentParameterGroup = this.introspectCreateEndpointFromComponent(cemd, componentClassInfo);
        if (!componentParameterGroup.getParameters().isEmpty()) {
            cemd.addParameterGroup(componentParameterGroup);
        }
        return cemd;
    }

    private boolean checkForUnsupportedException(String methodName, List<ClassInfo> endpointClassLineage) {
        boolean unsupportedException = false;
        block0: for (ClassInfo classInfo : endpointClassLineage) {
            if (!classInfo.hasMethod(methodName)) continue;
            MethodInfo methodInfo = classInfo.getMethod(methodName);
            for (MethodInfo info : methodInfo.getMethodCallStack(endpointClassLineage)) {
                if (!info.doesThrowsException("UnsupportedOperationException") && !info.doesThrowsException("RuntimeCamelException") && !info.doesThrowsException("OperationNotSupportedException")) continue;
                unsupportedException = true;
                continue block0;
            }
        }
        return unsupportedException;
    }

    private void introspectTransferredConfigurationObjects(ClassInfo componentClassInfo, CamelEndpointMetadata cemd, ClassInfo endpointClass, HashSet<ClassInfo> visitedClasses) {
        if (this.endpointIsInitializedWithConfigurationObject(endpointClass)) {
            for (MethodInfo methodInfo : componentClassInfo.getMethods()) {
                if (!ClassReference.isInCollection(endpointClass, methodInfo.getTypeInstanceCreations())) continue;
                for (ClassInfo configurationClassInfo : ClassReference.iterateResolved(methodInfo.getTypeInstanceCreations())) {
                    if (!configurationClassInfo.getName().endsWith("Configuration")) continue;
                    cemd.addAllParameterGroups(this.introspect(configurationClassInfo, visitedClasses));
                    for (ClassInfo classInfo : configurationClassInfo.getClassLineageStopBefore(CLASS_LINEAGE_STOPS)) {
                        cemd.addAllParameterGroups(this.introspect(classInfo, visitedClasses));
                    }
                }
            }
        }
    }

    private ParameterGroup introspectCreateEndpointFromComponent(CamelEndpointMetadata cemd, ClassInfo componentClassInfo) {
        ParameterGroup parameterGroup = new ParameterGroup();
        parameterGroup.setId(componentClassInfo.getName());
        parameterGroup.setName(NameUtils.humanReadable(componentClassInfo.getSimpleName()));
        for (MethodInfo methodInfo : componentClassInfo.getMethods()) {
            if (!methodInfo.getName().equals("createEndpoint")) continue;
            for (MethodCallInfo methodCallInfo : methodInfo.getMethodCalls()) {
                List<Object> parameterValues = methodCallInfo.getParameterValues();
                if (parameterValues.isEmpty()) continue;
                if (methodCallInfo.getMethodName().equals("getAndRemoveParameter") && methodCallInfo.getType().getResolved().equals(componentClassInfo)) {
                    this.addToParameterGroup(cemd, componentClassInfo, parameterGroup, methodCallInfo);
                }
                if (methodCallInfo.getMethodName().equals("resolveAndRemoveReferenceParameter")) {
                    ParameterGroup beanParameterGroup = new ParameterGroup();
                    ClassReference clazzType = (ClassReference)parameterValues.get(1);
                    beanParameterGroup.setId(clazzType.getUnresolved());
                    beanParameterGroup.setName(NameUtils.humanReadableSimpleClass(clazzType.getUnresolved()));
                    cemd.addParameterGroup(beanParameterGroup);
                    this.addToSimpleParameterGroup(BEAN_INTERFACE, beanParameterGroup.getId(), ParameterType.String, beanParameterGroup);
                    this.addToSimpleParameterGroup(BEAN_FILTER, "", ParameterType.String, beanParameterGroup);
                    this.addToSimpleParameterGroup(USE_BEAN_FLAG, false, ParameterType.Boolean, beanParameterGroup);
                }
                if (!methodCallInfo.getMethodName().equals("resolveAndRemoveReferenceListParameter")) continue;
                log.debug("Ignoring reference parameter list {}", parameterValues.get(0));
            }
        }
        return parameterGroup;
    }

    private void addToSimpleParameterGroup(String name, Object defaultValue, ParameterType type, ParameterGroup parameterGroup) {
        parameterGroup.add(CamelParameter.createFrom(name, type, defaultValue));
    }

    private void addToParameterGroup(CamelEndpointMetadata cemd, ClassInfo componentClassInfo, ParameterGroup parameterGroup, MethodCallInfo methodCallInfo) {
        String parameterName = (String)methodCallInfo.getParameterValues().get(0);
        ClassReference type = null;
        Object referenceParameter = methodCallInfo.getParameterValues().get(1);
        if (referenceParameter instanceof ClassReference) {
            type = (ClassReference)referenceParameter;
        } else if (referenceParameter instanceof StaticFieldReference) {
            type = new ClassReference(((StaticFieldReference)referenceParameter).getType());
        } else {
            return;
        }
        Object defaultValue = null;
        if (methodCallInfo.getParameterValues().size() > 2) {
            defaultValue = methodCallInfo.getParameterValues().get(2);
        }
        if (!this.isParameterExisting(parameterName, cemd, parameterGroup)) {
            parameterGroup.add(CamelParameter.createFrom(parameterName, type, componentClassInfo, defaultValue));
        } else {
            log.debug("Ignoring parameter because of duplicate {}", (Object)parameterName);
        }
    }

    private boolean isParameterExisting(String name, CamelEndpointMetadata cemd, ParameterGroup group) {
        for (CamelParameter camelParameter : group.getParameters()) {
            if (!camelParameter.getName().equals(name) && !camelParameter.getName().equals("consumer." + name)) continue;
            return true;
        }
        for (ParameterGroup parameterGroup : cemd.getParameterGroups()) {
            for (CamelParameter camelParameter : parameterGroup.getParameters()) {
                if (!camelParameter.getName().equals(name) && !camelParameter.getName().equals("consumer." + name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean endpointIsInitializedWithConfigurationObject(ClassInfo endpointClass) {
        for (MethodInfo methodInfo : endpointClass.getMethods()) {
            String[] types;
            if (!methodInfo.getName().equals("<init>")) continue;
            String[] parts = methodInfo.getSignature().split("\\)");
            parts[0] = parts[0].substring(1, parts[0].length());
            for (String type : types = parts[0].split(";")) {
                if (!type.endsWith("Configuration")) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<ParameterGroup> introspect(ClassInfo endpointClass, HashSet<ClassInfo> visitedClasses) {
        ArrayList<ParameterGroup> parameterGroups = new ArrayList<ParameterGroup>();
        this.introspect(endpointClass, parameterGroups, visitedClasses);
        Collections.reverse(parameterGroups);
        return parameterGroups;
    }

    private void introspect(ClassInfo currentClass, List<ParameterGroup> parameterGroups, HashSet<ClassInfo> visitedClasses) {
        visitedClasses.add(currentClass);
        ParameterGroup group = new ParameterGroup();
        if (currentClass.getName() != null && currentClass.getName().contains(".")) {
            group.setId(currentClass.getName().substring(currentClass.getName().lastIndexOf(".") + 1));
        } else {
            group.setId(currentClass.getName());
        }
        group.setName(NameUtils.humanReadable(currentClass.getSimpleName()));
        Collection<FieldInfo> fields = currentClass.getFields();
        for (FieldInfo field : fields) {
            if (this.isConfigurationRelevant(field)) {
                if (ParameterType.isConfigurable(field)) {
                    Object defaultValue = this.getDefaultValue(currentClass, field);
                    CamelParameter parameter = CamelParameter.createFrom(field, defaultValue);
                    group.add(parameter);
                    continue;
                }
                if (field.getType().isResolved() && !this.alreadyVisited(visitedClasses, field.getType().getResolved()) && !this.isForeignPackage(currentClass, field.getType().getResolved()) && !this.isBlacklisted(field.getType().getResolved())) {
                    this.introspect(field.getType().getResolved(), parameterGroups, visitedClasses);
                    for (ClassInfo superClass : field.getType().getResolved().getClassLineageStopBefore(CLASS_LINEAGE_STOPS)) {
                        this.introspect(superClass, parameterGroups, visitedClasses);
                    }
                    continue;
                }
                if (!field.getType().isResolved()) {
                    log.debug("Ignored field " + field.getType() + " because it could not be resolved.");
                    continue;
                }
                if (this.alreadyVisited(visitedClasses, field.getType().getResolved())) {
                    log.debug("Ignored field " + field.getType() + " because it is already visited.");
                    continue;
                }
                if (this.isForeignPackage(currentClass, field.getType().getResolved())) {
                    log.debug("Ignored field " + field.getType() + " because it is located in an foreign package");
                    continue;
                }
                if (!this.isBlacklisted(field.getType().getResolved())) continue;
                log.debug("Ingored field " + field.getType() + " because it is blacklisted");
                continue;
            }
            log.debug("Field is not configuration relevant: {} ", (Object)field.getType());
        }
        if (!group.getParameters().isEmpty()) {
            parameterGroups.add(group);
        }
    }

    private boolean isBlacklisted(ClassInfo resolvedType) {
        String sslParametersType = "org.apache.camel.util.jsse.SSLContextParameters";
        if (resolvedType.getName().equals("org.apache.camel.util.jsse.SSLContextParameters")) {
            log.warn("Field with type {} is not yet supported to be configured", (Object)"org.apache.camel.util.jsse.SSLContextParameters");
            return true;
        }
        return false;
    }

    private Object getDefaultValue(ClassInfo currentClass, FieldInfo field) {
        Object defaultValue = currentClass.getDefaultValue(field);
        if (defaultValue instanceof StaticFieldReference) {
            StaticFieldReference reference = (StaticFieldReference)defaultValue;
            ClassInfo referencedClass = this.getContext().getClassInfo(reference.getType());
            if (referencedClass != null && referencedClass.isEnum()) {
                defaultValue = reference.getFieldName();
            }
        }
        return defaultValue;
    }

    private boolean isForeignPackage(ClassInfo class1, ClassInfo class2) {
        if (class2.getPackage() == null) {
            return true;
        }
        if (class2.getName().toLowerCase(Locale.US).contains("config")) {
            return false;
        }
        return !class2.getPackage().startsWith(class1.getPackage()) && !class2.getPackage().startsWith("org.apache.camel");
    }

    private boolean alreadyVisited(HashSet<ClassInfo> visitedClasses, ClassInfo resolvedType) {
        return visitedClasses.contains(resolvedType);
    }

    private boolean isConfigurationRelevant(FieldInfo field) {
        if (field.isFinal() && !this.isAnnotatedWithUriParam(field)) {
            return false;
        }
        if (field.getDeclaringClass().getResolved().isAnnotationPresent("UriEndpoint") || this.anyNeighborFieldIsAnnotatedWithUriParam(field)) {
            return this.isAnnotatedWithUriParam(field);
        }
        return true;
    }

    private boolean isAnnotatedWithUriParam(FieldInfo field) {
        return field.isAnnotationPresent("UriParam");
    }

    private boolean anyNeighborFieldIsAnnotatedWithUriParam(FieldInfo field) {
        ClassInfo resolvedDeclaringClass = field.getDeclaringClass().getResolved();
        for (FieldInfo fieldInfo : resolvedDeclaringClass.getFields()) {
            if (!this.isAnnotatedWithUriParam(fieldInfo)) continue;
            return true;
        }
        return false;
    }

    private ClassInfo searchSubclassInstantiatedInMethod(String superClass, String methodName, ClassInfo endpointClass, List<ClassInfo> parentLineage) {
        if (endpointClass.hasMethod(methodName)) {
            MethodInfo methodInfo = endpointClass.getMethod(methodName);
            for (ClassReference reference : methodInfo.getTypeInstanceCreations()) {
                if (!reference.isResolved() || !reference.getResolved().isAssignableFrom(superClass)) continue;
                return reference.getResolved();
            }
            for (MethodInfo info : methodInfo.getMethodCallStack(parentLineage)) {
                for (ClassReference reference : info.getTypeInstanceCreations()) {
                    if (!reference.isResolved() || !reference.getResolved().isAssignableFrom(superClass)) continue;
                    return reference.getResolved();
                }
            }
        }
        return null;
    }

    private Set<ClassInfo> searchEndpointClasses(ClassInfo componentClassInfo) {
        HashSet<ClassInfo> endpointClasses = new HashSet<ClassInfo>();
        boolean createEndpointMethodDefined = false;
        for (MethodInfo methodInfo : componentClassInfo.getMethods()) {
            if (!methodInfo.getName().equals("createEndpoint")) continue;
            createEndpointMethodDefined = true;
            this.searchEndpointInMethod(componentClassInfo, endpointClasses, methodInfo);
        }
        if (endpointClasses.isEmpty()) {
            for (MethodInfo methodInfo : componentClassInfo.getMethods()) {
                for (ClassInfo classInfo : ClassReference.iterateResolved(methodInfo.getTypeInstanceCreations())) {
                    if (!classInfo.isAssignableFrom("org.apache.camel.Endpoint") && !classInfo.getName().endsWith("Endpoint")) continue;
                    endpointClasses.add(classInfo);
                }
            }
        }
        if (endpointClasses.isEmpty()) {
            for (ClassInfo classInfo : ClassReference.iterateResolved(componentClassInfo.getReferencedClasses())) {
                if (!classInfo.getName().endsWith("Endpoint") || !componentClassInfo.getPackage().equals(classInfo.getPackage())) continue;
                endpointClasses.add(classInfo);
            }
        }
        if (endpointClasses.isEmpty() && !createEndpointMethodDefined && componentClassInfo.getSuperClass() != null && componentClassInfo.getSuperClass().isResolved()) {
            return this.searchEndpointClasses(componentClassInfo.getSuperClass().getResolved());
        }
        return endpointClasses;
    }

    private void searchEndpointInMethod(ClassInfo componentClassInfo, Set<ClassInfo> endpointClasses, MethodInfo methodInfo) {
        for (ClassInfo classInfo : ClassReference.iterateResolved(methodInfo.getTypeInstanceCreations())) {
            if (!classInfo.isAssignableFrom("org.apache.camel.Endpoint") && !classInfo.getName().endsWith("Endpoint")) continue;
            endpointClasses.add(classInfo);
        }
        if (endpointClasses.isEmpty()) {
            for (MethodCallInfo methodCallInfo : methodInfo.getMethodCalls()) {
                if (!methodCallInfo.getMethodName().equals("createEndpoint") || !componentClassInfo.isAssignableFrom(methodCallInfo.getType().getUnresolved())) continue;
                endpointClasses.addAll(this.searchEndpointClasses(methodCallInfo.getType().getResolved()));
            }
        }
    }

    @Override
    protected void analyzeEntry(JarInputStream stream, BundleInfo bundleInfo, JarEntry entry) {
        super.analyzeEntry(stream, bundleInfo, entry);
        Matcher matcher = COMPONENT_FILE_EXPRESSION.matcher(entry.getName());
        if (matcher.matches()) {
            String protocol = matcher.group(1);
            Properties prop = new Properties();
            try {
                prop.load(stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.componentsToBeAnalyzed.put(protocol, prop.getProperty("class"));
        }
    }
}

