/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.analysis;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.analysis.DefaultClassVisitor;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassAnalyzer.class);
    private ClassAnalyzerContext context = new ClassAnalyzerContext();

    public ClassAnalyzer() {
    }

    public ClassAnalyzer(ClassAnalyzerContext context) {
        this.context = context;
    }

    public ClassInfo analyze(InputStream stream) {
        ClassReader classReader = this.createClassReader(stream);
        ClassInfo classInfo = new ClassInfo();
        classReader.accept((ClassVisitor)new DefaultClassVisitor(327680, classInfo), 2);
        this.context.addClass(classInfo);
        return classInfo;
    }

    private ClassReader createClassReader(InputStream stream) {
        try {
            return new ClassReader(stream);
        }
        catch (IOException e) {
            LOGGER.error("Error: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("failed");
        }
    }

    public void calculateResolvedModel() {
        for (ClassInfo classInfo : this.context.getAllClassInfos()) {
            classInfo.resolve(this.context);
        }
    }
}

