/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.analysis;

import com.sap.it.asdk.md.generator.analysis.DefaultMethodVisitor;
import com.sap.it.asdk.md.generator.model.AnnotationInfo;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.FieldInfo;
import com.sap.it.asdk.md.generator.model.MethodCallInfo;
import com.sap.it.asdk.md.generator.model.MethodInfo;
import com.sap.it.asdk.md.generator.model.Modifier;
import com.sap.it.asdk.md.generator.model.StaticFieldReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClassVisitor
extends ClassVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClassVisitor.class);
    private final ClassInfo classInfo;
    final HashMap<String, List<Object>> methodsCalledByConstructor = new HashMap();

    public DefaultClassVisitor(int opcodes, ClassInfo classInfo) {
        super(opcodes);
        this.classInfo = classInfo;
    }

    public void visit(int i, int i1, String className, String s1, String superName, String[] strings) {
        this.classInfo.setName(this.dot(className));
        this.classInfo.setSuperClass(this.reference(this.dot(superName)));
        this.classInfo.setModifiers(Modifier.modifiersForOpcode(i1));
        this.classInfo.addReferencedClass(this.reference(this.dot(superName)));
        for (String interfaces : strings) {
            this.classInfo.getInterfaces().add(this.reference(this.dot(interfaces)));
        }
    }

    public AnnotationVisitor visitAnnotation(String type, boolean b) {
        AnnotationInfo annotation = new AnnotationInfo();
        annotation.setType(this.reference(this.dot(this.sig(type))));
        this.classInfo.addAnnotation(annotation);
        this.classInfo.addReferencedClass(this.reference(this.dot(this.sig(type))));
        return null;
    }

    public FieldVisitor visitField(int mod, String name, String type, String s2, Object o) {
        final FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.setName(name);
        fieldInfo.setType(this.reference(this.dot(this.sig(type))));
        fieldInfo.setDeclaringClass(this.reference(this.classInfo.getName()));
        fieldInfo.setModifiers(Modifier.modifiersForOpcode(mod));
        this.classInfo.addReferencedClass(this.reference(this.dot(this.sig(type))));
        this.classInfo.addField(fieldInfo);
        return new FieldVisitor(327680){

            public AnnotationVisitor visitAnnotation(String type, boolean b) {
                AnnotationInfo annotation = new AnnotationInfo();
                annotation.setType(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(DefaultClassVisitor.this.sig(type))));
                DefaultClassVisitor.this.classInfo.addReferencedClass(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(DefaultClassVisitor.this.sig(type))));
                fieldInfo.addAnnotation(annotation);
                return null;
            }
        };
    }

    public MethodVisitor visitMethod(int mod, String name, String signature, String s2, String[] strings) {
        Set<Modifier> modifiers = Modifier.modifiersForOpcode(mod);
        if (modifiers.contains((Object)Modifier.SYNTHETIC)) {
            return null;
        }
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setName(name);
        methodInfo.setSignature(signature);
        methodInfo.setModifiers(modifiers);
        this.classInfo.addReferencedClasses(ClassReference.referencesFrom(this.extractClassNamesFromMethodSignature(signature)));
        this.classInfo.addMethod(methodInfo);
        if (name.equals("<init>") || this.methodsCalledByConstructor.containsKey(name)) {
            Stack<Object> valueStack = new Stack<Object>();
            return new MyDefaultInitMethodVisitor(valueStack, name);
        }
        return new MyDefaultMethodVisitor(methodInfo);
    }

    private ClassReference reference(String className) {
        return new ClassReference(className);
    }

    private Set<String> extractClassNamesFromMethodSignature(String signature) {
        String[] parametersArray;
        HashSet<String> result = new HashSet<String>();
        if (signature.equals("()V")) {
            return Collections.emptySet();
        }
        String[] split = signature.split("\\)");
        String parameters = split[0].substring(1);
        for (String parameter : parametersArray = parameters.split(";")) {
            result.add(this.dot(this.sig(parameter)));
        }
        if (!split[1].equals("V")) {
            result.add(this.dot(this.sig(split[1])));
        }
        return result;
    }

    private String sig(String sig) {
        if (sig.startsWith("L")) {
            int end = sig.endsWith(";") ? sig.length() - 1 : sig.length();
            return sig.substring(1, end);
        }
        return sig;
    }

    private String dot(String string) {
        return string.replace("/", ".");
    }

    private class MyDefaultInitMethodVisitor
    extends DefaultMethodVisitor {
        private final Stack<Object> valueStack;
        private final String name;

        public MyDefaultInitMethodVisitor(Stack<Object> valueStack, String name) {
            super(327680);
            this.valueStack = valueStack;
            this.name = name;
        }

        @Override
        public void visitIntInsn(int i, int i1) {
            if (16 == i) {
                this.valueStack.push(i1);
            }
        }

        @Override
        public void visitLdcInsn(Object o) {
            if (!(o instanceof Type)) {
                this.valueStack.push(o);
            }
        }

        @Override
        public void visitFieldInsn(int i, String s, String fieldName, String type) {
            if (178 == i) {
                StaticFieldReference staticFieldReference = new StaticFieldReference();
                staticFieldReference.setFieldName(fieldName);
                staticFieldReference.setType(DefaultClassVisitor.this.dot(s));
                this.valueStack.push(staticFieldReference);
            }
            this.addDefaultValue(i, fieldName, type);
        }

        private void addDefaultValue(int i, String fieldName, String type) {
            if (181 == i) {
                if (!this.valueStack.isEmpty()) {
                    Object value = this.valueStack.pop();
                    FieldInfo field = DefaultClassVisitor.this.classInfo.getField(fieldName);
                    if (type.equals("Z")) {
                        if (value.equals(1)) {
                            value = true;
                        } else if (value.equals(0)) {
                            value = false;
                        }
                    }
                    if (field != null) {
                        DefaultClassVisitor.this.classInfo.addDefaultValue(field, value);
                        LOGGER.debug("Detected default value: {} = {}", (Object)field.getName(), value);
                    }
                } else {
                    LOGGER.debug("Value stack is empty for {} {}", (Object)fieldName, (Object)type);
                }
            }
        }

        @Override
        public void visitInsn(int i) {
            switch (i) {
                case 3: 
                case 9: 
                case 11: 
                case 14: {
                    this.valueStack.push(0);
                    return;
                }
                case 4: 
                case 10: 
                case 12: 
                case 15: {
                    this.valueStack.push(1);
                    return;
                }
                case 5: 
                case 13: {
                    this.valueStack.push(2);
                    return;
                }
                case 6: {
                    this.valueStack.push(3);
                    return;
                }
                case 7: {
                    this.valueStack.push(4);
                    return;
                }
                case 8: {
                    this.valueStack.push(5);
                    return;
                }
            }
        }

        @Override
        public void visitVarInsn(int i, int i1) {
            if (i == 24) {
                int parameterIndex = (i1 - 1) / 2;
                List<Object> objects = DefaultClassVisitor.this.methodsCalledByConstructor.get(this.name);
                if (objects != null && !objects.isEmpty()) {
                    this.valueStack.push(objects.get(parameterIndex));
                }
            }
        }

        @Override
        public void visitTypeInsn(int i, String s) {
            DefaultClassVisitor.this.classInfo.addReferencedClass(new ClassReference(DefaultClassVisitor.this.dot(s)));
        }

        @Override
        public void visitMethodInsn(int i, String type, String s1, String s2) {
            DefaultClassVisitor.this.classInfo.addReferencedClass(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(type)));
            if (182 == i && DefaultClassVisitor.this.dot(type).equals(DefaultClassVisitor.this.classInfo.getName())) {
                ArrayList<Object> parameterValues = new ArrayList<Object>(this.valueStack);
                this.valueStack.removeAllElements();
                DefaultClassVisitor.this.methodsCalledByConstructor.put(s1, parameterValues);
            } else if (184 == i && !s1.equals("valueOf")) {
                this.valueStack.removeAllElements();
            }
        }

        @Override
        public void visitMethodInsn(int i, String s, String s1, String s2, boolean isInterface) {
            this.visitMethodInsn(i, s, s1, s2);
        }
    }

    private class MyDefaultMethodVisitor
    extends DefaultMethodVisitor {
        final Stack<Object> valueStack;
        private final MethodInfo methodInfo;

        public MyDefaultMethodVisitor(MethodInfo methodInfo) {
            super(327680);
            this.methodInfo = methodInfo;
            this.valueStack = new Stack();
        }

        @Override
        public void visitIntInsn(int i, int i1) {
            if (16 == i) {
                this.valueStack.push(i1);
            }
        }

        @Override
        public void visitLdcInsn(Object o) {
            if (!(o instanceof Type)) {
                this.valueStack.push(o);
            } else {
                Type t = (Type)o;
                this.valueStack.push(new ClassReference(t.getClassName()));
            }
        }

        @Override
        public void visitFieldInsn(int i, String s, String fieldName, String type) {
            if (178 == i) {
                StaticFieldReference staticFieldReference = new StaticFieldReference();
                staticFieldReference.setFieldName(fieldName);
                staticFieldReference.setType(DefaultClassVisitor.this.dot(s));
                this.valueStack.push(staticFieldReference);
            }
        }

        @Override
        public void visitTypeInsn(int i, String type) {
            DefaultClassVisitor.this.classInfo.addReferencedClass(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(type)));
            if (i == 187) {
                this.methodInfo.addTypeInstanceCreation(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(type)));
            }
        }

        @Override
        public void visitJumpInsn(int i, Label label) {
            this.valueStack.removeAllElements();
        }

        @Override
        public void visitFrame(int i, int i1, Object[] objects, int i2, Object[] objects1) {
            this.valueStack.removeAllElements();
        }

        @Override
        public void visitInsn(int i) {
            switch (i) {
                case 3: 
                case 9: 
                case 11: 
                case 14: {
                    this.valueStack.push(0);
                    return;
                }
                case 4: 
                case 10: 
                case 12: 
                case 15: {
                    this.valueStack.push(1);
                    return;
                }
                case 5: 
                case 13: {
                    this.valueStack.push(2);
                    return;
                }
                case 6: {
                    this.valueStack.push(3);
                    return;
                }
                case 7: {
                    this.valueStack.push(4);
                    return;
                }
                case 8: {
                    this.valueStack.push(5);
                    return;
                }
                case 191: {
                    List<ClassReference> typeInstanceCreations = this.methodInfo.getTypeInstanceCreations();
                    if (!typeInstanceCreations.isEmpty()) {
                        ClassReference lastTypeInstanceCreation = typeInstanceCreations.get(typeInstanceCreations.size() - 1);
                        this.methodInfo.addThrowsException(lastTypeInstanceCreation);
                    }
                    return;
                }
            }
        }

        @Override
        public void visitMethodInsn(int i, String s, String s1, String s2) {
            DefaultClassVisitor.this.classInfo.addReferencedClass(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(s)));
            if (182 == i || 183 == i || 184 == i && !s1.equals("valueOf")) {
                if (s1.equals("<init>")) {
                    this.methodInfo.addTypeInstanceCreation(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(s)));
                } else {
                    ArrayList<Object> parameterValues = new ArrayList<Object>(this.valueStack);
                    this.valueStack.removeAllElements();
                    MethodCallInfo methodCallInfo = new MethodCallInfo();
                    methodCallInfo.setMethodName(s1);
                    methodCallInfo.setType(DefaultClassVisitor.this.reference(DefaultClassVisitor.this.dot(s)));
                    methodCallInfo.setParameterValues(parameterValues);
                    methodCallInfo.setSignature(s2);
                    this.methodInfo.addMethodCall(methodCallInfo);
                }
            } else if (185 == i) {
                this.valueStack.removeAllElements();
            }
        }

        @Override
        public void visitMethodInsn(int i, String s, String s1, String s2, boolean isInterface) {
            this.visitMethodInsn(i, s, s1, s2);
        }
    }
}

