/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.model.AnnotationInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.FieldInfo;
import com.sap.it.asdk.md.generator.model.MethodInfo;
import com.sap.it.asdk.md.generator.model.Modifier;
import com.sap.it.asdk.md.generator.model.Resolvable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ClassInfo
implements Resolvable {
    private String name;
    private ClassReference superClass;
    private HashMap<String, MethodInfo> methods = new HashMap();
    private Set<AnnotationInfo> annotations = new HashSet<AnnotationInfo>();
    private Set<Modifier> modifiers = new HashSet<Modifier>();
    private Set<ClassReference> referencedClasses = new HashSet<ClassReference>();
    private Set<ClassReference> interfaces = new HashSet<ClassReference>();
    private HashMap<FieldInfo, Object> defaultValues = new HashMap();
    private HashMap<String, FieldInfo> fields = new HashMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    public boolean isAnnotationPresent(String annotation) {
        if (this.getAnnotations() != null) {
            for (AnnotationInfo annotationInfo : this.getAnnotations()) {
                if (!annotationInfo.getType().getUnresolved().contains(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1, this.name.length());
    }

    public ClassInfo getRootClass() {
        ClassReference superClass = this.getSuperClass();
        if (superClass.isResolved()) {
            return superClass.getResolved().getRootClass();
        }
        return this;
    }

    public boolean isSubclassFrom(String className) {
        if (!this.getSuperClass().isResolved()) {
            return false;
        }
        if (this.getSuperClass().getResolved().getName().equals(className)) {
            return true;
        }
        return this.getSuperClass().getResolved().isSubclassFrom(className);
    }

    public boolean isAssignableFrom(String className) {
        if (this.getSuperClass().isResolved() && this.getSuperClass().getResolved().getName().equals(className) || ClassReference.isInCollection(className, this.interfaces)) {
            return true;
        }
        if (this.getSuperClass().isResolved()) {
            for (ClassReference anInterface : this.interfaces) {
                if (!anInterface.isResolved() || !anInterface.getResolved().isAssignableFrom(className)) continue;
                return true;
            }
            return this.getSuperClass().getResolved().isAssignableFrom(className);
        }
        return false;
    }

    public ClassReference getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(ClassReference superClass) {
        this.superClass = superClass;
    }

    public Collection<FieldInfo> getFields() {
        return this.fields.values();
    }

    public void addField(FieldInfo field) {
        this.fields.put(field.getName(), field);
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods.values();
    }

    public MethodInfo getMethod(String name) {
        return this.methods.get(name);
    }

    public void addMethod(MethodInfo method) {
        this.methods.put(method.getName(), method);
    }

    public void addAnnotation(AnnotationInfo annotation) {
        this.annotations.add(annotation);
    }

    public Set<ClassReference> getReferencedClasses() {
        return this.referencedClasses;
    }

    public void setReferencedClasses(Set<ClassReference> referencedClasses) {
        this.referencedClasses = referencedClasses;
    }

    public void addReferencedClass(ClassReference reference) {
        this.referencedClasses.add(reference);
    }

    public void addReferencedClasses(Collection<ClassReference> references) {
        this.referencedClasses.addAll(references);
    }

    public FieldInfo getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public void addDefaultValue(FieldInfo field, Object value) {
        this.defaultValues.put(field, value);
    }

    public Set<ClassReference> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Set<ClassReference> interfaces) {
        this.interfaces = interfaces;
    }

    public Object getDefaultValue(FieldInfo field) {
        Object defaultValue = this.defaultValues.get(field);
        return defaultValue;
    }

    public String getPackage() {
        if (this.name.contains(".")) {
            return this.name.substring(0, this.name.lastIndexOf(46));
        }
        return null;
    }

    public List<ClassInfo> withClassLineageStopBefore(String ... stops) {
        ArrayList<ClassInfo> lineage = new ArrayList<ClassInfo>();
        lineage.add(this);
        this.buildUpLineageStopBefore(lineage, stops);
        return lineage;
    }

    public List<ClassInfo> getClassLineageStopBefore(String ... stops) {
        ArrayList<ClassInfo> lineage = new ArrayList<ClassInfo>();
        this.buildUpLineageStopBefore(lineage, stops);
        return lineage;
    }

    private void buildUpLineageStopBefore(List<ClassInfo> lineage, String[] stops) {
        if (this.superClass.isResolved()) {
            ClassInfo resolvedSuperClass = this.superClass.getResolved();
            if (stops != null) {
                for (String stop : stops) {
                    if (!resolvedSuperClass.getName().equals(stop)) continue;
                    return;
                }
            }
            lineage.add(resolvedSuperClass);
            resolvedSuperClass.buildUpLineageStopBefore(lineage, stops);
        }
    }

    public List<ClassInfo> getClassLineage() {
        ArrayList<ClassInfo> lineage = new ArrayList<ClassInfo>();
        this.buildUpLineageStopBefore(lineage, null);
        return lineage;
    }

    public List<ClassInfo> withClassLineage() {
        ArrayList<ClassInfo> lineage = new ArrayList<ClassInfo>();
        lineage.add(this);
        this.buildUpLineageStopBefore(lineage, null);
        return lineage;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isEnum() {
        return this.modifiers.contains((Object)Modifier.ENUM);
    }

    @Override
    public void resolve(ClassAnalyzerContext context) {
        this.superClass.resolve(context);
        for (ClassReference referencedClass : this.referencedClasses) {
            referencedClass.resolve(context);
        }
        for (ClassReference anInterface : this.interfaces) {
            anInterface.resolve(context);
        }
        for (FieldInfo fieldInfo : this.fields.values()) {
            fieldInfo.resolve(context);
        }
        for (MethodInfo method : this.methods.values()) {
            method.resolve(context);
        }
        for (AnnotationInfo annotation : this.annotations) {
            annotation.resolve(context);
        }
    }

    public boolean hasMethod(String createConsumer) {
        return this.methods.containsKey(createConsumer);
    }
}

