/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import com.sap.it.asdk.md.generator.model.Resolvable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClassReference
implements Resolvable {
    private ClassInfo resolved;
    private String unresolved;
    private static final Set<String> loggedTraversals = new LinkedHashSet<String>();
    private static boolean isTraversalLoggingEnabled = false;

    public ClassReference() {
    }

    public ClassReference(ClassInfo resolved) {
        this.resolved = resolved;
        this.unresolved = resolved.getName();
    }

    public ClassReference(String unresolved) {
        this.resolved = null;
        this.unresolved = unresolved;
    }

    public ClassReference(ClassInfo resolved, String unresolved) {
        this.resolved = resolved;
        this.unresolved = unresolved;
    }

    @Override
    public void resolve(ClassAnalyzerContext context) {
        ClassInfo classInfo = context.getClassInfo(this.unresolved);
        if (classInfo != null) {
            this.resolved = classInfo;
        }
    }

    public static Iterable<ClassInfo> iterateResolved(Collection<ClassReference> references) {
        ArrayList<ClassInfo> result = new ArrayList<ClassInfo>(references.size());
        for (ClassReference reference : references) {
            if (!reference.isResolved()) continue;
            result.add(reference.getResolved());
        }
        return result;
    }

    public void setResolved(ClassInfo resolved) {
        this.resolved = resolved;
    }

    public void setUnresolved(String unresolved) {
        this.unresolved = unresolved;
    }

    public static Set<String> getLoggedTraversals() {
        return loggedTraversals;
    }

    public static void enableTraversalLogging() {
        isTraversalLoggingEnabled = true;
    }

    public ClassInfo getResolved() {
        if (isTraversalLoggingEnabled && this.resolved != null) {
            loggedTraversals.add(this.resolved.getName());
        }
        return this.resolved;
    }

    public String getUnresolved() {
        return this.unresolved;
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public static boolean isInCollection(String className, Collection<ClassReference> collection) {
        for (ClassReference classReference : collection) {
            if (!classReference.getUnresolved().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInCollection(ClassInfo classInfo, Collection<ClassReference> collection) {
        for (ClassInfo otherClass : ClassReference.iterateResolved(collection)) {
            if (!otherClass.equals(classInfo)) continue;
            return true;
        }
        return false;
    }

    public static Collection<ClassReference> referencesFrom(Collection<String> unresolvedReferences) {
        ArrayList<ClassReference> classReferences = new ArrayList<ClassReference>();
        for (String unresolvedReference : unresolvedReferences) {
            classReferences.add(new ClassReference(unresolvedReference));
        }
        return classReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassReference that = (ClassReference)o;
        return !(this.unresolved != null ? !this.unresolved.equals(that.unresolved) : that.unresolved != null);
    }

    public int hashCode() {
        return this.unresolved != null ? this.unresolved.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ClassReference{");
        sb.append("resolved=").append(this.resolved);
        sb.append(", unresolved='").append(this.unresolved).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

