/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.model.AnnotationInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.Modifier;
import com.sap.it.asdk.md.generator.model.Resolvable;
import java.util.HashSet;
import java.util.Set;

public class FieldInfo
implements Resolvable {
    private String name;
    private ClassReference type;
    private ClassReference declaringClass;
    private Set<AnnotationInfo> annotations = new HashSet<AnnotationInfo>();
    private Set<Modifier> modifiers = new HashSet<Modifier>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    public void addAnnotation(AnnotationInfo annotation) {
        this.annotations.add(annotation);
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isFinal() {
        return this.modifiers.contains((Object)Modifier.FINAL);
    }

    public ClassReference getType() {
        return this.type;
    }

    public void setType(ClassReference type) {
        this.type = type;
    }

    public ClassReference getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(ClassReference declaringClass) {
        this.declaringClass = declaringClass;
    }

    public boolean isAnnotationPresent(String annotation) {
        if (this.getAnnotations() != null) {
            for (AnnotationInfo annotationInfo : this.getAnnotations()) {
                if (!annotationInfo.getType().getUnresolved().contains(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        if (this.name != null ? !this.name.equals(fieldInfo.name) : fieldInfo.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(fieldInfo.type) : fieldInfo.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public void resolve(ClassAnalyzerContext context) {
        this.type.resolve(context);
        this.declaringClass.resolve(context);
        for (AnnotationInfo annotation : this.annotations) {
            annotation.resolve(context);
        }
    }
}

