/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model;

import com.sap.it.asdk.md.generator.analysis.ClassAnalyzerContext;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.MethodCallInfo;
import com.sap.it.asdk.md.generator.model.Modifier;
import com.sap.it.asdk.md.generator.model.Resolvable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodInfo
implements Resolvable {
    private String name;
    private String signature;
    private Set<String> checkedExcpetionTypes = new HashSet<String>();
    private List<ClassReference> typeInstanceCreation = new ArrayList<ClassReference>();
    private List<MethodCallInfo> methodCalls = new ArrayList<MethodCallInfo>();
    private Set<Modifier> modifiers;
    private List<ClassReference> throwsException = new ArrayList<ClassReference>();

    public List<ClassReference> getThrowsException() {
        return this.throwsException;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Set<String> getCheckedExcpetionTypes() {
        return this.checkedExcpetionTypes;
    }

    public void setCheckedExcpetionTypes(Set<String> checkedExcpetionTypes) {
        this.checkedExcpetionTypes = checkedExcpetionTypes;
    }

    public List<ClassReference> getTypeInstanceCreations() {
        return this.typeInstanceCreation;
    }

    public void setTypeInstanceCreations(List<ClassReference> typeInstanceCreation) {
        this.typeInstanceCreation = typeInstanceCreation;
    }

    public void addTypeInstanceCreation(ClassReference reference) {
        this.typeInstanceCreation.add(reference);
    }

    public List<MethodCallInfo> getMethodCalls() {
        return this.methodCalls;
    }

    public void addMethodCall(MethodCallInfo methodCall) {
        this.methodCalls.add(methodCall);
    }

    @Override
    public void resolve(ClassAnalyzerContext context) {
        for (ClassReference classReference : this.typeInstanceCreation) {
            classReference.resolve(context);
        }
        for (MethodCallInfo methodCall : this.methodCalls) {
            methodCall.resolve(context);
        }
    }

    public Collection<MethodInfo> getMethodCallStack(List<ClassInfo> lineage) {
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>();
        result.add(this);
        this.recursiveBuildCallStack(lineage, result);
        return result;
    }

    public void recursiveBuildCallStack(List<ClassInfo> lineage, Collection<MethodInfo> result) {
        for (MethodCallInfo methodCall : this.methodCalls) {
            if (!methodCall.getType().isResolved()) continue;
            block1: for (ClassInfo classInfo : lineage) {
                if (classInfo.isAssignableFrom(methodCall.getType().getUnresolved())) {
                    for (MethodInfo methodInfo : classInfo.getMethods()) {
                        if (!methodInfo.getName().equals(methodCall.getMethodName()) || !methodCall.getSignature().equals(methodInfo.getSignature())) continue;
                        if (result.contains(methodInfo)) continue block1;
                        result.add(methodInfo);
                        methodInfo.recursiveBuildCallStack(lineage, result);
                        continue block1;
                    }
                    continue;
                }
                for (MethodInfo methodInfo : methodCall.getType().getResolved().getMethods()) {
                    if (!methodInfo.getName().equals(methodCall.getMethodName()) || result.contains(methodInfo)) continue;
                    result.add(methodInfo);
                    methodInfo.recursiveBuildCallStack(lineage, result);
                }
            }
        }
    }

    public void addThrowsException(ClassReference lastTypeInstanceCreation) {
        this.throwsException.add(lastTypeInstanceCreation);
    }

    public boolean doesThrowsException(String unsupportedOperationException) {
        for (ClassReference classReference : this.throwsException) {
            if (!classReference.getUnresolved().contains(unsupportedOperationException)) continue;
            return true;
        }
        return false;
    }

    public void setModifiers(Set<Modifier> modifiers) {
        this.modifiers = modifiers;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }
}

