/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model.camel;

import com.sap.it.asdk.md.generator.model.camel.CamelParameter;
import com.sap.it.asdk.md.generator.model.camel.ComponentInformation;
import com.sap.it.asdk.md.generator.model.camel.ParameterGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class CamelEndpointMetadata {
    private String componentName;
    private String version;
    private String artifactId;
    private String groupId;
    private String transportProtocol;
    private String messageProtocol;
    private String scheme;
    private ComponentInformation componentInformation;
    private final HashMap<String, ParameterGroup> parameterGroups = new LinkedHashMap<String, ParameterGroup>();
    private final List<String> receiverVariantInputAdd = new ArrayList<String>();
    private String receiverVariantOutputChange;

    public void setComponentName(String name) {
        this.componentName = name;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public String getMessageProtocol() {
        return this.messageProtocol;
    }

    public void setMessageProtocol(String messageProtocol) {
        this.messageProtocol = messageProtocol;
    }

    public List<ParameterGroup> getParameterGroups() {
        return Collections.unmodifiableList(new ArrayList<ParameterGroup>(this.parameterGroups.values()));
    }

    public void addParameterGroup(ParameterGroup group) {
        this.parameterGroups.put(group.getId(), group);
    }

    public void addAllParameterGroups(Collection<ParameterGroup> introspect) {
        for (ParameterGroup parameterGroup : introspect) {
            this.addParameterGroup(parameterGroup);
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ComponentInformation getComponentInformation() {
        return this.componentInformation;
    }

    public void setComponentInformation(ComponentInformation componentInformation) {
        this.componentInformation = componentInformation;
    }

    public CamelParameter selectParameter(String parameterId) {
        for (ParameterGroup parameterGroup : this.getParameterGroups()) {
            for (CamelParameter camelParameter : parameterGroup.getParameters()) {
                if (parameterId == null || !camelParameter.getName().equals(parameterId)) continue;
                return camelParameter;
            }
        }
        return null;
    }

    public ParameterGroup selectParameterGroup(String groupId) {
        for (ParameterGroup parameterGroup : this.getParameterGroups()) {
            if (groupId == null || !parameterGroup.getId().equals(groupId)) continue;
            return parameterGroup;
        }
        return null;
    }

    public ParameterGroup selectGroupOfParameter(String parameterId) {
        for (ParameterGroup parameterGroup : this.getParameterGroups()) {
            for (CamelParameter camelParameter : parameterGroup.getParameters()) {
                if (parameterId == null || !camelParameter.getName().equals(parameterId)) continue;
                return parameterGroup;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CamelEndpointMetadata{");
        sb.append("componentName='").append(this.getComponentName()).append('\'');
        sb.append(", transportProtocol='").append(this.getTransportProtocol()).append('\'');
        sb.append(", scheme='").append(this.getScheme()).append('\'');
        sb.append(", messageProtocol='").append(this.getMessageProtocol()).append('\'');
        sb.append(", version='").append(this.getVersion()).append('\'');
        sb.append(", artifactId='").append(this.getArtifactId()).append('\'');
        sb.append(", groupId='").append(this.getGroupId()).append('\'');
        sb.append(", information='").append(this.getComponentInformation()).append('\'');
        sb.append(", parameterGroups=" + System.lineSeparator());
        for (ParameterGroup parameterGroup : this.parameterGroups.values()) {
            sb.append("\t" + parameterGroup + System.lineSeparator());
        }
        sb.append('}');
        return sb.toString();
    }

    public void removeGroup(ParameterGroup group) {
        this.parameterGroups.remove(group.getId());
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void addReceiverVariantInputContent(String value) {
        this.receiverVariantInputAdd.add(value);
    }

    public void changeReceiverVariantOutputContent(String value) {
        this.receiverVariantOutputChange = value;
    }

    public List<String> getReceiverVariantInputAdd() {
        return this.receiverVariantInputAdd;
    }

    public String getReceiverVariantOutputChange() {
        return this.receiverVariantOutputChange;
    }
}

