/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model.camel;

import com.sap.it.asdk.md.generator.analysis.utils.NameUtils;
import com.sap.it.asdk.md.generator.model.ClassInfo;
import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.FieldInfo;
import com.sap.it.asdk.md.generator.model.Modifier;
import com.sap.it.asdk.md.generator.model.camel.EditConditionExpression;
import com.sap.it.asdk.md.generator.model.camel.ParameterType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CamelParameter {
    private final ParameterType type;
    private boolean isConfidential;
    private boolean isRequired;
    private boolean isParameterized;
    private final String name;
    private String description;
    private String label;
    private Object defaultValue;
    private final String declaringClassName;
    private List<String> enumValues = new ArrayList<String>();
    private final List<String> enumLabels = new ArrayList<String>();
    private static List<String> secureParameters = new ArrayList<String>();
    private EditConditionExpression editCondition;
    private boolean explicitlyAssignedToGroup;

    public CamelParameter(ParameterType type, boolean isConfidential, boolean isRequired, String name, String label, Object value, Class<?> declaringClass, List<String> enumValues) {
        this(type, isConfidential, isRequired, name, label, value, declaringClass.getSimpleName(), enumValues);
    }

    public CamelParameter(ParameterType type, boolean isConfidential, boolean isRequired, String name, String label, Object value, String declaringClassName, List<String> enumValues) {
        this.type = type;
        this.isConfidential = isConfidential;
        this.isRequired = isRequired;
        this.name = name;
        this.description = this.guessDescription(label);
        this.defaultValue = value;
        this.label = label;
        this.declaringClassName = declaringClassName;
        this.enumValues = enumValues;
    }

    public static CamelParameter createFrom(Field field, Object defaultValue) {
        return new CamelParameter(ParameterType.forField(field), CamelParameter.guessConfidentiality(field.getName()), false, field.getName(), NameUtils.humanReadable(field.getName()), defaultValue, field.getDeclaringClass(), CamelParameter.enumValues(field));
    }

    public static CamelParameter createFrom(FieldInfo field, Object defaultValue) {
        return new CamelParameter(ParameterType.forFieldInfo(field), CamelParameter.guessConfidentiality(field.getName()), false, field.getName(), NameUtils.humanReadable(field.getName()), defaultValue, field.getDeclaringClass().getUnresolved(), CamelParameter.enumValues(field));
    }

    public static CamelParameter createFrom(String name, ClassReference type, ClassInfo declaringClass, Object defaultValue) {
        return new CamelParameter(ParameterType.forClassReference(type), CamelParameter.guessConfidentiality(name), false, name, NameUtils.humanReadable(name), defaultValue, declaringClass.getName(), CamelParameter.enumValues(type));
    }

    public static CamelParameter createFrom(String name, ParameterType type, Object defaultValue) {
        return new CamelParameter(type, CamelParameter.guessConfidentiality(name), false, name, NameUtils.humanReadable(name), defaultValue, (String)null, new ArrayList<String>());
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static List<String> enumValues(ClassReference type) {
        if (type.isResolved() && type.getResolved().isEnum()) {
            ArrayList<String> result = new ArrayList<String>();
            for (FieldInfo fieldInfo : type.getResolved().getFields()) {
                if (!fieldInfo.getModifiers().contains((Object)Modifier.ENUM)) continue;
                result.add(fieldInfo.getName());
            }
            return result;
        }
        return new ArrayList<String>();
    }

    private static List<String> enumValues(Field field) {
        if (field.getType().isEnum()) {
            ArrayList<String> enumValues = new ArrayList<String>();
            for (Object o : field.getType().getEnumConstants()) {
                enumValues.add(o.toString());
            }
            return enumValues;
        }
        return new ArrayList<String>();
    }

    private static List<String> enumValues(FieldInfo field) {
        return CamelParameter.enumValues(field.getType());
    }

    private static boolean guessConfidentiality(String fieldName) {
        if (secureParameters.isEmpty() || secureParameters.size() < 1) {
            CamelParameter.addSecureParameters();
        }
        for (String secureParam : secureParameters) {
            if (!fieldName.toLowerCase(Locale.ENGLISH).contains(secureParam)) continue;
            return true;
        }
        return false;
    }

    private String guessDescription(String text) {
        return "Configure " + text;
    }

    public ParameterType getType() {
        return this.type;
    }

    public boolean isConfidential() {
        return this.isConfidential;
    }

    public void setIsConfidential(boolean isConfidential) {
        this.isConfidential = isConfidential;
    }

    public String getName() {
        return this.name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CamelParameter{");
        sb.append("type=").append((Object)this.type);
        sb.append(", isConfidential=").append(this.isConfidential);
        sb.append(", isRequired=").append(this.isRequired);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", label='").append(this.label).append('\'');
        sb.append(", defaultValue=").append(this.defaultValue);
        sb.append(", declaringClassName='").append(this.declaringClassName).append('\'');
        sb.append(", enumValues=").append(this.enumValues);
        sb.append('}');
        return sb.toString();
    }

    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    private static void addSecureParameters() {
        secureParameters.add("password");
        secureParameters.add("key");
        secureParameters.add("secret");
        secureParameters.add("token");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getEnumLabels() {
        return this.enumLabels;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isParameterized() {
        return this.isParameterized;
    }

    public void setParameterized(boolean isParameterized) {
        this.isParameterized = isParameterized;
    }

    public void setEditCondition(EditConditionExpression editCondition) {
        this.editCondition = editCondition;
    }

    public EditConditionExpression getEditCondition() {
        return this.editCondition;
    }

    public void setExplicitlyAssignedToGroupOrHidden(boolean explicitlyAssignedToGroup) {
        this.explicitlyAssignedToGroup = explicitlyAssignedToGroup;
    }

    public boolean isExplicitlyAssignedToGroupOrHidden() {
        return this.explicitlyAssignedToGroup;
    }
}

