/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.asdk.md.generator.model.camel;

import com.sap.it.asdk.md.generator.model.ClassReference;
import com.sap.it.asdk.md.generator.model.FieldInfo;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ParameterType {
    Integer("int", "I", Integer.class, "Ljava/lang/Integer;", "xsd:integer"),
    String(null, null, String.class, "Ljava/lang/String;", "xsd:string"),
    Long("long", "J", Long.class, "Ljava/lang/Long;", "xsd:long"),
    Short("short", "S", Short.class, "Ljava/lang/Short;", "xsd:short"),
    Float("float", "F", Float.class, "Ljava/lang/Float;", "xsd:float"),
    Double("double", "D", Double.class, "Ljava/lang/Double;", "xsd:double"),
    Boolean("boolean", "Z", Boolean.class, "Ljava/lang/Boolean;", "xsd:boolean"),
    Enum(null, null, null, null, "xsd:string"),
    Password(null, null, null, null, "xsd:password"),
    UnsupportedType(null, null, null, null, "xsd:string");

    private static final Logger log;
    private final Class<?> javaType;
    private String primitiveType;
    private final String primitiveSignature;
    private final String wrapperClassSignature;
    private String xsdType;

    private ParameterType(String primitive, String primitiveSignature, Class<?> wrapperClass, String wrapperClassSignature, String xsdType) {
        this.primitiveType = primitive;
        this.javaType = wrapperClass;
        this.primitiveSignature = primitiveSignature;
        this.wrapperClassSignature = wrapperClassSignature;
        this.xsdType = xsdType;
    }

    public static ParameterType forField(Field field) {
        if (field.getType().isEnum()) {
            return Enum;
        }
        if (field.getType().isPrimitive()) {
            for (ParameterType parameterType : ParameterType.values()) {
                if (!field.getType().getCanonicalName().equals(parameterType.getPrimitiveType())) continue;
                return parameterType;
            }
            log.warn("No type defined for " + field.getType() + " fallback to unsupported type");
        } else {
            for (ParameterType parameterType : ParameterType.values()) {
                if (!field.getType().equals(parameterType.getJavaType())) continue;
                return parameterType;
            }
            log.warn("No type defined for " + field.getType() + " fallback to unsupported type");
        }
        return UnsupportedType;
    }

    public static ParameterType forFieldInfo(FieldInfo fieldInfo) {
        return ParameterType.forClassReference(fieldInfo.getType());
    }

    public static ParameterType forClassReference(ClassReference reference) {
        for (ParameterType parameterType : ParameterType.values()) {
            if (parameterType.getPrimitiveSignature() != null && parameterType.getPrimitiveSignature().equals(reference.getUnresolved())) {
                return parameterType;
            }
            if (parameterType.getJavaType() == null || !parameterType.getJavaType().getName().equals(reference.getUnresolved())) continue;
            return parameterType;
        }
        if (reference.isResolved() && reference.getResolved().isEnum()) {
            return Enum;
        }
        return UnsupportedType;
    }

    public static ParameterType forSignature(String signature) {
        for (ParameterType parameterType : ParameterType.values()) {
            if (signature.equals(parameterType.getPrimitiveSignature())) {
                return parameterType;
            }
            if (!signature.equals(parameterType.getWrapperClassSignature())) continue;
            return parameterType;
        }
        return UnsupportedType;
    }

    public static boolean isConfigurable(FieldInfo fieldInfo) {
        for (ParameterType parameterType : ParameterType.values()) {
            if (fieldInfo.getType().getUnresolved().equals(parameterType.getPrimitiveSignature()) || parameterType.getJavaType() != null && fieldInfo.getType().getUnresolved().equals(parameterType.getJavaType().getName())) {
                return true;
            }
            if (!fieldInfo.getType().isResolved() || !fieldInfo.getType().getResolved().isEnum()) continue;
            return true;
        }
        return false;
    }

    public static boolean isConfigurable(Field field) {
        if (field.getType().isPrimitive()) {
            for (ParameterType parameterType : ParameterType.values()) {
                if (!field.getType().getName().equals(parameterType.getPrimitiveType())) continue;
                return true;
            }
        } else {
            for (ParameterType parameterType : ParameterType.values()) {
                if (!field.getType().equals(parameterType.getJavaType())) continue;
                return true;
            }
        }
        return false;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getXsdType() {
        return this.xsdType;
    }

    public String getPrimitiveSignature() {
        return this.primitiveSignature;
    }

    public String getWrapperClassSignature() {
        return this.wrapperClassSignature;
    }

    static {
        log = LoggerFactory.getLogger(ParameterType.class);
    }
}

