/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.api;

import com.sap.it.api.ITApi;
import com.sap.it.api.exception.InvalidContextException;
import com.sap.it.api.impl.ITApiFactoryRegistry;
import com.sap.it.spi.ITApiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ITApiFactory {
    private static final Logger TRACE = LoggerFactory.getLogger(ITApiFactory.class);

    private ITApiFactory() {
    }

    @Deprecated
    public static <T extends ITApi> T getApi(Class<? extends ITApi> apiType, Object context) throws InvalidContextException {
        return ITApiFactory.getServiceInternal(apiType, context);
    }

    public static <T extends ITApi> T getService(Class<? extends ITApi> apiType, Object context) throws InvalidContextException {
        return ITApiFactory.getServiceInternal(apiType, context);
    }

    private static <T extends ITApi> T getServiceInternal(Class<? extends ITApi> apiType, Object context) throws InvalidContextException {
        ITApiHandler<? extends ITApi> apiFactory = ITApiFactoryRegistry.getApiHandler(apiType);
        if (apiFactory == null) {
            TRACE.error("Unable to retrieve API Factory for the apiType: {}", apiType);
            throw new InvalidContextException("Exception occurred while trying to retrieve API Factory for the apiType: " + apiType.toString());
        }
        TRACE.debug("Successfully retrieved API Factory for the apiType: {}", apiType);
        return (T)apiFactory.getApi(context);
    }
}

