/*
 * Decompiled with CFR 0.152.
 */
package com.sap.it.api.impl;

import com.sap.it.api.ITApi;
import com.sap.it.spi.ITApiHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ITApiFactoryRegistry {
    private static final Logger TRACE = LoggerFactory.getLogger(ITApiFactoryRegistry.class);
    private static final Map<String, ITApiHandler<?>> factories = Collections.synchronizedMap(new HashMap());

    public static ITApiHandler<? extends ITApi> getApiHandler(Class<? extends ITApi> apiType) {
        TRACE.debug("Incoming api type: {}", (Object)apiType.getName());
        if (factories.isEmpty()) {
            TRACE.debug("ITApi factories is null or empty!!!!!!!!!!!!");
            return null;
        }
        TRACE.debug("Listing the already registered api names");
        Set<Map.Entry<String, ITApiHandler<?>>> entrySet = factories.entrySet();
        for (Map.Entry<String, ITApiHandler<?>> entry : entrySet) {
            TRACE.debug("Already registered api key: {} Value: {}", (Object)entry.getKey(), entry.getValue());
        }
        return factories.get(apiType.getName());
    }

    @Reference(name="ITApiHandler", service=ITApiHandler.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.RELUCTANT, unbind="unbindApiFactory")
    protected void bindApiFactory(ITApiHandler<?> factory, Map<?, ?> serviceProperties) {
        String apiTypeName = (String)serviceProperties.get("apiType");
        factories.put(apiTypeName, factory);
        TRACE.debug("apiTypeName: {} is added to the map", (Object)apiTypeName);
    }

    protected void unbindApiFactory(ITApiHandler<?> factory, Map<?, ?> serviceProperties) {
        String apiTypeName = (String)serviceProperties.get("apiType");
        factories.remove(apiTypeName);
        TRACE.debug("apiTypeName: {} with handler: {} is removed from the map", (Object)apiTypeName, factory);
    }
}

