/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations;

import com.sap.core.connectivity.api.Destination;
import com.sap.core.connectivity.api.DestinationNotFoundException;
import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.cloud.destinations.AccountProvidersSupplier;
import com.sap.core.connectivity.cloud.destinations.DefaultAccountProvidersSupplier;
import com.sap.core.connectivity.destinations.AbstractDestinationFactory;
import com.sap.core.connectivity.destinations.DefaultConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;
import com.sap.core.connectivity.httpdestination.internal.api.AccountDestinationFactory;

public class CloudDestinationFactory
extends AbstractDestinationFactory
implements AccountDestinationFactory {
    private AccountProvidersSupplier accountProvidersSupplier;

    @Override
    public <T extends Destination> T getDestination(String destinationName, String accountName) throws DestinationNotFoundException {
        ConnectivityConfiguration connectivityConfiguration;
        if (this.accountProvidersSupplier == null && !RUNTIME_UTIL.isOsgiRuntime() && (connectivityConfiguration = RUNTIME_UTIL.loadJavaService(ConnectivityConfiguration.class, true)) != null) {
            this.setConnectivityConfiguration(connectivityConfiguration);
        }
        if (this.accountProvidersSupplier == null) {
            throw new IllegalStateException("Missing AccountProvidersSupplier service");
        }
        ConfigurationProvider configurationProvider = this.accountProvidersSupplier.getConfigurationProvider(accountName);
        return this.getDestination(destinationName, configurationProvider);
    }

    protected void setAccountProvidersSupplier(AccountProvidersSupplier accountProvidersSupplier) {
        this.accountProvidersSupplier = accountProvidersSupplier;
    }

    protected void unsetAccountProvidersSupplier(AccountProvidersSupplier accountProvidersSupplier) {
        this.accountProvidersSupplier = null;
    }

    @Override
    protected void setConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.setConfigurationProvider(new DefaultConfigurationProvider(connectivityConfiguration));
        this.setAccountProvidersSupplier(new DefaultAccountProvidersSupplier(connectivityConfiguration));
    }

    protected void unsetConnectivityConfiguration(ConnectivityConfiguration connectivityConfiguration) {
        this.unsetConfigurationProvider(this.getConfigurationProvider());
        this.unsetAccountProvidersSupplier(this.accountProvidersSupplier);
    }
}

