/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations;

import com.sap.core.connectivity.api.configuration.ConnectivityConfiguration;
import com.sap.core.connectivity.api.configuration.DestinationConfiguration;
import com.sap.core.connectivity.api.configuration.NotAuthorizedException;
import com.sap.core.connectivity.cloud.destinations.AccountProvidersSupplier;
import com.sap.core.connectivity.cloud.destinations.utils.AccountProvider;
import com.sap.core.connectivity.destinations.DefaultConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.AccountConfigurationProvider;
import com.sap.core.connectivity.destinations.internal.api.ConfigurationProvider;

public class DefaultAccountProvidersSupplier
implements AccountProvidersSupplier {
    private final AccountProvider<ConfigurationProvider> configurationProvider;

    public DefaultAccountProvidersSupplier(final ConnectivityConfiguration connectivityConfiguration) {
        this.configurationProvider = new AccountProvider<ConfigurationProvider>(){

            @Override
            public ConfigurationProvider provide() {
                return new DefaultConfigurationProvider(connectivityConfiguration);
            }

            @Override
            public ConfigurationProvider provide(final String accountName) {
                return new AccountConfigurationProvider(){

                    @Override
                    public DestinationConfiguration getDestinationConfiguration(String name) {
                        try {
                            return connectivityConfiguration.getConfiguration(accountName, name);
                        }
                        catch (NotAuthorizedException ex) {
                            throw new IllegalArgumentException(ex);
                        }
                    }

                    @Override
                    public String getDestinationAccount() {
                        return accountName;
                    }
                };
            }
        };
    }

    @Override
    public ConfigurationProvider getConfigurationProvider(String accountName) {
        return this.configurationProvider.provide(accountName);
    }
}

