/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations.jndi;

import com.sap.core.connectivity.api.DestinationException;
import com.sap.core.connectivity.destinations.jndi.ReferenceServiceObjectFactory;
import com.sap.core.connectivity.httpdestination.internal.api.AccountDestinationFactory;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;

public class JavaServiceObjectFactory
extends ReferenceServiceObjectFactory {
    private static final Logger log = Logger.getLogger(JavaServiceObjectFactory.class.getName());
    private static AccountDestinationFactory accountDestinationFactory;

    public JavaServiceObjectFactory() {
        super(JavaServiceObjectFactory.getSupportedReferences());
    }

    private static Map<String, ReferenceServiceObjectFactory.ReferenceHandler> getSupportedReferences() {
        return Collections.singletonMap(AccountDestinationFactory.class.getName(), new ReferenceServiceObjectFactory.ReferenceHandler(){

            @Override
            public Object getObjectInstance(Reference ref, Name name, Context nameCtx, Hashtable<?, ?> environment) throws DestinationException {
                AccountDestinationFactory accountDestinationFactory = JavaServiceObjectFactory.getAccountDestinationFactory();
                log.log(Level.FINE, "Will return AccountDestinationFactory instance : " + accountDestinationFactory);
                return accountDestinationFactory;
            }
        });
    }

    private static AccountDestinationFactory getAccountDestinationFactory() {
        if (accountDestinationFactory == null && !RUNTIME_UTIL.isOsgiRuntime()) {
            accountDestinationFactory = RUNTIME_UTIL.loadJavaService(AccountDestinationFactory.class);
        }
        if (accountDestinationFactory == null) {
            throw new IllegalStateException("Missing AccountDestinationFactory service");
        }
        return accountDestinationFactory;
    }
}

