/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations.tunnel;

import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectionProtocol;
import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReader;
import com.sap.core.connectivity.cloud.destinations.tunnel.utils.SystemPropertyConnectivityProxyAddressReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectivitySocket
extends Socket {
    public static final byte OK = 0;
    public static final byte OK_INFO = 2;
    public static final byte ERROR_DURING_HANDSHAKE = 1;
    public static final String PROPERTY_TUNNEL_ID = "tunnelId";
    public static final String PROPERTY_HOSTNAME = "hostname";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_CONNECTION_PROTOCOL = "connectionProtocol";
    public static final String PROPERTY_REQUEST_CONNECTION_INFO = "requestConnectionInfo";
    public static final String PROPERTY_SSO_TOKEN = "ssoToken";
    public static final String PROPERTY_SSO_TOKEN_TYPE = "ssoTokenType";
    public static final String PROPERTY_PROXY_AUTHORIZATION = "proxy-authorization";
    private static final Logger log = Logger.getLogger(ConnectivitySocket.class.getName());
    private ConnectivityProxyAddressReader connectivityProxyAddressReader;
    private final String tunnelId;
    private final ConnectionProtocol protocol;
    private final String ssoToken;
    private final String ssoTokenType;
    private final Properties connectionInfo;
    private final String proxyAuthCredentials;

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol) {
        this(tunnelId, protocol, null, null, (ConnectivityProxyAddressReader)new SystemPropertyConnectivityProxyAddressReader(), new Properties());
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, String proxyAuthCredentials) {
        this(tunnelId, protocol, null, null, new SystemPropertyConnectivityProxyAddressReader(), new Properties(), proxyAuthCredentials);
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, ConnectivityProxyAddressReader connectivityProxyAddressReader) {
        this(tunnelId, protocol, null, null, connectivityProxyAddressReader, new Properties());
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, ConnectivityProxyAddressReader connectivityProxyAddressReader, Properties connectionInfo) {
        this(tunnelId, protocol, null, null, connectivityProxyAddressReader, connectionInfo);
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, String ssoToken, String ssoTokenType, ConnectivityProxyAddressReader connectivityProxyAddressReader) {
        this(tunnelId, protocol, ssoToken, ssoTokenType, connectivityProxyAddressReader, new Properties());
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, String ssoToken, String ssoTokenType, ConnectivityProxyAddressReader connectivityProxyAddressReader, String proxyAuthCredentials) {
        this(tunnelId, protocol, ssoToken, ssoTokenType, connectivityProxyAddressReader, new Properties(), proxyAuthCredentials);
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, String ssoToken, String ssoTokenType, ConnectivityProxyAddressReader connectivityProxyAddressReader, Properties connectionInfo) {
        this(tunnelId, protocol, ssoToken, ssoTokenType, connectivityProxyAddressReader, connectionInfo, null);
    }

    public ConnectivitySocket(String tunnelId, ConnectionProtocol protocol, String ssoToken, String ssoTokenType, ConnectivityProxyAddressReader connectivityProxyAddressReader, Properties connectionInfo, String proxyAuthCredentials) {
        this.checkNotNull(tunnelId);
        this.checkNotNull((Object)protocol);
        this.checkSSOParameters(ssoToken, ssoTokenType);
        this.checkNotNull(connectivityProxyAddressReader);
        this.checkNotNull(connectionInfo);
        this.tunnelId = tunnelId;
        this.protocol = protocol;
        this.ssoToken = ssoToken;
        this.ssoTokenType = ssoTokenType;
        this.connectionInfo = connectionInfo;
        this.connectivityProxyAddressReader = connectivityProxyAddressReader;
        this.proxyAuthCredentials = proxyAuthCredentials;
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        InetSocketAddress connectivityProxyAddress = this.connectivityProxyAddressReader.getConnectivityProxyAddress();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("Connectivity agent port for on-premise destination is %s", Integer.toString(connectivityProxyAddress.getPort())));
        }
        super.connect(connectivityProxyAddress, timeout);
        OutputStream outputStream = this.getOutputStream();
        byte[] connectionProperties = this.serializeRequestProperties((InetSocketAddress)endpoint);
        outputStream.write(ByteBuffer.allocate(4).putInt(connectionProperties.length).array());
        outputStream.write(connectionProperties);
        outputStream.flush();
        InputStream inputStream = this.getInputStream();
        int returnCode = inputStream.read();
        switch (returnCode) {
            case 0: {
                return;
            }
            case 2: {
                this.readConnectionInfo(inputStream);
                return;
            }
        }
        throw new ConnectException("Unexpected error while connecting to connectivity proxy: " + returnCode);
    }

    private void readConnectionInfo(InputStream inputStream) throws IOException {
        int connectionInfoLen = inputStream.read();
        if (connectionInfoLen > 0) {
            byte[] connectionInfoBytes = new byte[connectionInfoLen];
            int readLen = inputStream.read(connectionInfoBytes);
            if (readLen != connectionInfoLen) {
                throw new IllegalStateException("Connection info cannot be read successfully");
            }
            try {
                this.connectionInfo.load(new ByteArrayInputStream(connectionInfoBytes));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalStateException("Malformed connection info", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeRequestProperties(InetSocketAddress endpointInetAddress) throws IOException {
        ByteArrayOutputStream byteArraysStream = new ByteArrayOutputStream();
        try {
            Properties properties = new Properties();
            properties.put(PROPERTY_TUNNEL_ID, this.tunnelId);
            properties.put(PROPERTY_HOSTNAME, endpointInetAddress.getHostName());
            properties.put(PROPERTY_PORT, Integer.toString(endpointInetAddress.getPort()));
            properties.put(PROPERTY_CONNECTION_PROTOCOL, this.protocol.toString());
            properties.put(PROPERTY_REQUEST_CONNECTION_INFO, Boolean.toString(Boolean.TRUE));
            if (this.ssoToken != null) {
                properties.put(PROPERTY_SSO_TOKEN, this.ssoToken);
                properties.put(PROPERTY_SSO_TOKEN_TYPE, this.ssoTokenType);
            }
            if (this.proxyAuthCredentials != null) {
                properties.put(PROPERTY_PROXY_AUTHORIZATION, this.proxyAuthCredentials);
            }
            properties.store(byteArraysStream, null);
            byte[] byArray = byteArraysStream.toByteArray();
            return byArray;
        }
        finally {
            block9: {
                try {
                    byteArraysStream.close();
                }
                catch (IOException e) {
                    if (!log.isLoggable(Level.WARNING)) break block9;
                    log.log(Level.WARNING, "Exception was thrown while closing byteArraysStream:  ", e);
                }
            }
        }
    }

    private void checkNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Supplied argument is null");
        }
    }

    private void checkSSOParameters(String ssoToken, String ssoTokenType) {
        if (ssoToken == null && ssoTokenType != null || ssoToken != null && ssoTokenType == null) {
            throw new IllegalArgumentException("SSO token and SSO token type should either both by null or should both be set");
        }
    }
}

