/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations.tunnel;

import java.net.URI;
import java.net.URISyntaxException;

public class TunnelIdFactory {
    private static final String ACCOUNT_SCHEME = "account";

    public static String createIdForAccount(String account) {
        return TunnelIdFactory.createIdForAccount(account, null);
    }

    public static String createIdForAccount(String account, String location) {
        if (account == null || account.isEmpty()) {
            throw new IllegalArgumentException("Account cannot be empty");
        }
        try {
            if (location == null || location.isEmpty()) {
                return new URI(ACCOUNT_SCHEME, "", "/" + account, null).toString();
            }
            return new URI(ACCOUNT_SCHEME, "", "/" + account + "/" + location, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(account, e);
        }
    }
}

