/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.cloud.destinations.tunnel.utils;

import com.sap.core.connectivity.cloud.destinations.tunnel.ConnectivityProxyAddressReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class SystemPropertyConnectivityProxyAddressReader
implements ConnectivityProxyAddressReader {
    private static final String CONNECTIVITY_PROXY_PORT_PROPERTY_NAME = "connectivity.proxy.port";
    private static final int CONNECTIVITY_PROXY_PORT_DEFAULT_VALUE = 20001;
    private static volatile InetSocketAddress proxyAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InetSocketAddress getConnectivityProxyAddress() {
        if (proxyAddress != null) return proxyAddress;
        Class<SystemPropertyConnectivityProxyAddressReader> clazz = SystemPropertyConnectivityProxyAddressReader.class;
        synchronized (SystemPropertyConnectivityProxyAddressReader.class) {
            if (proxyAddress != null) return proxyAddress;
            try {
                int connectivityProxyPort = Integer.getInteger(CONNECTIVITY_PROXY_PORT_PROPERTY_NAME, 20001);
                proxyAddress = new InetSocketAddress(InetAddress.getByName(null), connectivityProxyPort);
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Unable to get connectivity proxy address", e);
            }
            return proxyAddress;
        }
    }
}

